/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.ClassLoaderUtil;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.slf4j.LoggerFactory;

public class Swt {
    public static final boolean isLoaded;
    public static final boolean isGtk3;
    private static final Object currentDisplay;
    private static final Thread currentDisplayThread;
    private static final Method syncExecMethod;
    private static final int version;

    public static void dispatch(Runnable runnable) {
        try {
            syncExecMethod.invoke(currentDisplay, runnable);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(Swt.class).error("Unable to execute JavaFX runLater(). Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static boolean isEventThread() {
        return Thread.currentThread() == currentDisplayThread;
    }

    public static void onShutdown(final Runnable runnable) {
        if (Swt.isEventThread()) {
            SwtOverride.onShutdown(currentDisplay, runnable);
        } else {
            Swt.dispatch(new Runnable(){

                @Override
                public void run() {
                    SwtOverride.onShutdown(currentDisplay, runnable);
                }
            });
        }
    }

    public static int getVersion() {
        return version;
    }

    static {
        boolean isSwtLoaded_ = false;
        boolean isSwtGtk3_ = false;
        try {
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            boolean bl = isSwtLoaded_ = null != m.invoke((Object)cl, "org.eclipse.swt.widgets.Display");
            if (isSwtLoaded_) {
                String swt_gtk3 = System.getProperty("SWT_GTK3");
                boolean bl2 = isSwtGtk3_ = swt_gtk3 != null && !swt_gtk3.equals("0");
                if (!isSwtGtk3_) {
                    String property = System.getProperty("org.eclipse.swt.internal.gtk.version");
                    isSwtGtk3_ = property != null && !property.startsWith("2.");
                }
            }
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(Swt.class).debug("Error detecting if SWT is loaded", e);
        }
        isLoaded = isSwtLoaded_;
        isGtk3 = isSwtGtk3_;
        Object _currentDisplay = null;
        Thread _currentDisplayThread = null;
        Method _syncExecMethod = null;
        int _version = 0;
        if (isSwtLoaded_) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.SWT");
                Method getVersionMethod = clazz.getMethod("getVersion", new Class[0]);
                _version = (Integer)getVersionMethod.invoke(null, new Object[0]);
                clazz = Class.forName("org.eclipse.swt.widgets.Display");
                Method getCurrentMethod = clazz.getMethod("getCurrent", new Class[0]);
                Method getThreadMethod = clazz.getMethod("getThread", new Class[0]);
                _syncExecMethod = clazz.getDeclaredMethod("syncExec", Runnable.class);
                _currentDisplay = getCurrentMethod.invoke(null, new Object[0]);
                _currentDisplayThread = (Thread)getThreadMethod.invoke(_currentDisplay, new Object[0]);
                ClassPool pool = ClassPool.getDefault();
                CtClass swtOverriedClass = pool.get("dorkbox.util.Swt$SwtOverride");
                CtClass listener = pool.makeClass("dorkbox.util.Swt_listener");
                listener.addInterface(pool.get("org.eclipse.swt.widgets.Listener"));
                CtField ctField = new CtField(pool.get("java.lang.Runnable"), "runnable", listener);
                ctField.setModifiers(4);
                listener.addField(ctField);
                CtMethod method = CtNewMethod.make((CtClass)CtClass.voidType, (String)"handleEvent", (CtClass[])new CtClass[]{pool.get("org.eclipse.swt.widgets.Event")}, null, (String)"{   this.runnable.run();}", (CtClass)listener);
                listener.addMethod(method);
                byte[] bytes = listener.toBytecode();
                ClassLoaderUtil.defineClass(bytes);
                method = swtOverriedClass.getDeclaredMethod("onShutdown");
                String body = "{org.eclipse.swt.widgets.Display currentDisplay = (org.eclipse.swt.widgets.Display)$1;Runnable runnable = $2;dorkbox.util.Swt_listener listener = new dorkbox.util.Swt_listener();listener.runnable = runnable;org.eclipse.swt.widgets.Shell shell = currentDisplay.getShells()[0];shell.addListener(org.eclipse.swt.SWT.Close, listener);}";
                method.setBody(body);
                bytes = swtOverriedClass.toBytecode();
                ClassLoaderUtil.defineClass(bytes);
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(Swt.class).error("Cannot initialize SWT", e);
            }
        }
        currentDisplay = _currentDisplay;
        currentDisplayThread = _currentDisplayThread;
        syncExecMethod = _syncExecMethod;
        version = _version;
    }

    public static class SwtOverride {
        static void onShutdown(Object currentDisplay, Runnable runnable) {
            throw new RuntimeException("This should never happen, as this class is over-written at runtime.");
        }
    }
}

