/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.win32.W32APIOptions;
import dorkbox.util.OS;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JnaHelper {
    public static NativeLibrary register(String libraryName, Class<?> clazz) throws IllegalArgumentException {
        NativeLibrary library;
        HashMap<String, ClassLoader> options = new HashMap<String, ClassLoader>();
        options.put("classloader", clazz.getClassLoader());
        if (OS.isWindows()) {
            Set entries = W32APIOptions.DEFAULT_OPTIONS.entrySet();
            for (Map.Entry entry : entries) {
                options.put((String)entry.getKey(), (ClassLoader)entry.getValue());
            }
        }
        if ((library = NativeLibrary.getInstance((String)libraryName, options)) == null) {
            throw new IllegalArgumentException(libraryName + " doesn't exist or cannot be loaded.");
        }
        Native.register(clazz, (NativeLibrary)library);
        return library;
    }
}

