/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.jna.linux;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.jna.JnaHelper;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import dorkbox.util.jna.linux.structs.AppIndicatorInstanceStruct;
import org.slf4j.LoggerFactory;

public class AppIndicator {
    public static final boolean isLoaded;
    public static final int CATEGORY_APPLICATION_STATUS = 0;
    public static final int STATUS_PASSIVE = 0;
    public static final int STATUS_ACTIVE = 1;

    public static String getInstallString(boolean isGtk2) {
        String packageName;
        OSUtil.Linux.PackageManager.Type packageManager = OSUtil.Linux.PackageManager.get();
        if (isGtk2) {
            packageName = "libappindicator";
            if (OSUtil.Linux.isFedora()) {
                packageName = "libappindicator-gtk";
            } else if (OSUtil.Linux.isDebian()) {
                packageName = "libappindicator1";
            }
        } else {
            packageName = "libappindicator3";
            if (OSUtil.Linux.isFedora()) {
                packageName = "libappindicator-gtk3";
            } else if (OSUtil.Linux.isDebian()) {
                packageName = "libappindicator3-1";
            }
        }
        return "Please install " + packageName + ", for example: '" + packageManager.installString() + " " + packageName + "'.";
    }

    public static native AppIndicatorInstanceStruct app_indicator_new(String var0, String var1, int var2);

    public static native void app_indicator_set_title(Pointer var0, String var1);

    public static native void app_indicator_set_status(Pointer var0, int var1);

    public static native void app_indicator_set_menu(Pointer var0, Pointer var1);

    public static native void app_indicator_set_icon(Pointer var0, String var1);

    static {
        NativeLibrary library;
        boolean shouldLoadAppIndicator;
        boolean _isLoaded = false;
        boolean bl = shouldLoadAppIndicator = !OS.isWindows() && !OS.isMacOsX();
        if (!shouldLoadAppIndicator) {
            _isLoaded = true;
        }
        if (!Gtk.isLoaded) {
            shouldLoadAppIndicator = false;
            _isLoaded = true;
        }
        String[] GTK2 = new String[]{"appindicator", "appindicator1", "appindicator-gtk"};
        String[] GTK3 = new String[]{"appindicator3", "appindicator3-1", "appindicator-gtk3", "appindicator-gtk3-1"};
        if (Gtk.isGtk2) {
            for (String libraryName : GTK2) {
                if (_isLoaded) continue;
                try {
                    library = JnaHelper.register(libraryName, AppIndicator.class);
                    if (library == null) continue;
                    _isLoaded = true;
                }
                catch (Throwable e) {
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Error loading GTK2 library name '{}'. {}", (Object)libraryName, (Object)e.getMessage());
                }
            }
        }
        if (Gtk.isGtk3) {
            for (String libraryName : GTK3) {
                if (_isLoaded) continue;
                try {
                    library = JnaHelper.register(libraryName, AppIndicator.class);
                    if (library == null) continue;
                    _isLoaded = true;
                }
                catch (Throwable e) {
                    if (!GtkEventDispatch.DEBUG) continue;
                    LoggerFactory.getLogger(AppIndicator.class).debug("Error loading GTK3 library name '{}'. {}", (Object)libraryName, (Object)e.getMessage());
                }
            }
        }
        isLoaded = shouldLoadAppIndicator && _isLoaded;
    }
}

