/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;

public class Checkbox
extends Entry {
    private volatile boolean isChecked = false;
    private volatile String text;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey;
    private volatile String tooltip;

    public Checkbox() {
        this(null, null);
    }

    public Checkbox(String text) {
        this(text, null);
    }

    public Checkbox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        ActionListener[] actionListeners = jCheckBoxMenuItem.getActionListeners();
        if (actionListeners != null) {
            if (actionListeners.length == 1) {
                this.setCallback(actionListeners[0]);
            } else {
                ActionListener actionListener = e -> {
                    for (ActionListener actionListener1 : actionListeners) {
                        actionListener1.actionPerformed(e);
                    }
                };
                this.setCallback(actionListener);
            }
        }
        this.setEnabled(jCheckBoxMenuItem.isEnabled());
        this.setChecked(jCheckBoxMenuItem.getState());
        this.setShortcut(jCheckBoxMenuItem.getMnemonic());
        this.setText(jCheckBoxMenuItem.getText());
    }

    public Checkbox(String text, ActionListener callback) {
        this.text = text;
        this.callback = callback;
    }

    public void bind(CheckboxPeer peer, Menu parent, ImageResizeUtil imageResizeUtil) {
        super.bind(peer, parent, imageResizeUtil);
        peer.setEnabled(this);
        peer.setText(this);
        peer.setCallback(this);
        peer.setShortcut(this);
        peer.setChecked(this);
    }

    public boolean getChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setChecked(this);
        }
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public void setCallback(ActionListener callback) {
        this.callback = callback;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setCallback(this);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setText(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char key) {
        this.mnemonicKey = key;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int key) {
        this.mnemonicKey = SwingUtil.getFromVirtualKey((int)key);
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }

    public void setTooltip(String tooltipText) {
        if (tooltipText != null) {
            if (tooltipText.length() > 64) {
                throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
            }
            if (!MenuItem.alreadyEmittedTooltipWarning) {
                MenuItem.alreadyEmittedTooltipWarning = true;
                SystemTray.logger.warn("Please disable tooltips, as they are not consistent across all platforms and tray types.");
            }
        }
        this.tooltip = tooltipText;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setTooltip(this);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public JCheckBoxMenuItem asSwingComponent() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setText(this.getText());
        jCheckBoxMenuItem.setToolTipText(this.getTooltip());
        jCheckBoxMenuItem.setEnabled(this.getEnabled());
        jCheckBoxMenuItem.setMnemonic(SwingUtil.getVirtualKey((char)this.getShortcut()));
        jCheckBoxMenuItem.setState(this.getChecked());
        jCheckBoxMenuItem.addActionListener(this.getCallback());
        return jCheckBoxMenuItem;
    }
}

