/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.javaFx.JavaFx;
import dorkbox.jna.linux.AppIndicator;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkCheck;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.os.OSUtil;
import dorkbox.propertyLoader.Property;
import dorkbox.swt.Swt;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingUIFactory;
import dorkbox.systemTray.util.AutoDetectTrayType;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.LinuxSwingUI;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import dorkbox.systemTray.util.SystemTrayFixes;
import dorkbox.systemTray.util.WindowsSwingUI;
import dorkbox.updates.Updates;
import dorkbox.util.CacheUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTray {
    public static final Logger logger = LoggerFactory.getLogger(SystemTray.class);
    @Property
    public static boolean AUTO_SIZE = true;
    @Property
    public static boolean FORCE_GTK2 = false;
    @Property
    public static boolean PREFER_GTK3 = true;
    @Property
    public static TrayType FORCE_TRAY_TYPE = TrayType.AutoDetect;
    @Property
    public static boolean AUTO_FIX_INCONSISTENCIES = true;
    @Property
    public static boolean ENABLE_ROOT_CHECK = true;
    @Property
    public static SwingUIFactory SWING_UI = null;
    @Property
    public static boolean DEBUG = false;
    private final String trayName;
    private final Tray menu;
    private final ImageResizeUtil imageResizeUtil;
    private final Runnable shutdownRunnable;

    public static String getVersion() {
        return "4.1";
    }

    public static SystemTray get() {
        return SystemTray.get("SystemTray");
    }

    public static synchronized SystemTray get(String trayName) {
        Class<? extends Tray> trayType;
        if (GraphicsEnvironment.isHeadless()) {
            logger.error("Cannot use the SystemTray in a headless environment");
            return null;
        }
        SystemTray existingTray = AutoDetectTrayType.getInstance(trayName);
        if (existingTray != null) {
            if (DEBUG) {
                logger.info("Returning existing tray: " + trayName);
            }
            return existingTray;
        }
        boolean isNix = OS.isLinux() || OS.isUnix();
        boolean isWindows = OS.isWindows();
        boolean isMacOsX = OS.isMacOsX();
        if (isWindows) {
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.WindowsNative) {
                logger.warn("Windows cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type on windows, auto-detecting implementation!");
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
            }
        } else if (isMacOsX) {
            if (Swt.isLoaded) {
                if (Swt.getVersion() < 4430) {
                    logger.error("Unable to use currently loaded version of SWT, it is TOO OLD. Please use version 4.4+");
                    return null;
                }
                if (FORCE_TRAY_TYPE == TrayType.Swing) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        logger.warn("Unable to load Swing + SWT (for all versions of Java). Using the AWT Tray type instead.");
                        FORCE_TRAY_TYPE = TrayType.Awt;
                    } else {
                        logger.error("Unable to load Swing + SWT (for all versions of Java). Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.\"");
                        return null;
                    }
                }
            }
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.Awt) {
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
                logger.warn("MacOS cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to the AWT Tray type instead.");
            }
        } else if (isNix) {
            int loadedGtkVersion = GtkCheck.getLoadedGtkVersion();
            if (loadedGtkVersion == 2) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (!FORCE_GTK2) {
                        if (JavaFx.isLoaded) {
                            if (OS.javaVersion < 11) {
                                FORCE_GTK2 = true;
                                if (DEBUG) {
                                    logger.debug("Forcing GTK2 because JavaFX is GTK2");
                                }
                            } else {
                                String gtkVer = System.getProperty("jdk.gtk.version", "0");
                                if (gtkVer.startsWith("2")) {
                                    FORCE_GTK2 = true;
                                    if (DEBUG) {
                                        logger.debug("Forcing GTK2 because JavaFX System property `jdk.gtk.version` was set to 2 (so we force GTK2)");
                                    }
                                }
                            }
                        } else if (Swt.isLoaded && !Swt.isGtk3) {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because SWT is GTK2");
                            }
                        } else {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because Java has already loaded GTK2");
                            }
                        }
                    }
                } else if (!FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` or set `SystemTray.AUTO_FIX_INCONSISTENCIES=true`.  Aborting...");
                    return null;
                }
            } else if (loadedGtkVersion == 3) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (JavaFx.isLoaded) {
                        if (FORCE_GTK2 && OS.javaVersion >= 9) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Undoing `FORCE_GTK2`.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because JavaFX is GTK3");
                            }
                        }
                    } else if (Swt.isLoaded) {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because SWT is GTK3");
                            }
                        }
                    } else {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Undoing `FORCE_GTK2.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because Java has already loaded GTK3");
                            }
                        }
                    }
                } else if (JavaFx.isLoaded) {
                    if (FORCE_GTK2) {
                        if (OS.javaVersion == 9) {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        } else {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        }
                        return null;
                    }
                } else if (Swt.isLoaded) {
                    if (FORCE_GTK2) {
                        logger.error("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`");
                        return null;
                    }
                } else if (FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Aborting.");
                    return null;
                }
            } else if (!JavaFx.isLoaded && !Swt.isLoaded) {
                String previousValue = System.getProperty("swing.gtk.version", "0");
                if (previousValue != null && previousValue.startsWith("3") && FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` and System property `swing.gtk.version=\"2.2\".  Aborting...");
                    return null;
                }
                previousValue = System.getProperty("jdk.gtk.version", "0");
                if (previousValue != null && previousValue.startsWith("3") && FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` and System property `jdk.gtk.version=\"2.2\".  Aborting...");
                    return null;
                }
                if ("0".equals(previousValue) && AUTO_FIX_INCONSISTENCIES) {
                    if (PREFER_GTK3) {
                        System.setProperty("swing.gtk.version", "3");
                        System.setProperty("jdk.gtk.version", "3");
                    } else {
                        System.setProperty("swing.gtk.version", "2");
                        System.setProperty("jdk.gtk.version", "2");
                    }
                }
            }
        }
        if (DEBUG) {
            logger.debug("OS: {}", (Object)System.getProperty("os.name"));
            logger.debug("Arch: {}", (Object)System.getProperty("os.arch"));
            String jvmName = System.getProperty("java.vm.name", "");
            String jvmVersion = System.getProperty("java.version", "");
            String jvmVendor = System.getProperty("java.vm.specification.vendor", "");
            logger.debug("{} {} {}", new Object[]{jvmVendor, jvmName, jvmVersion});
            logger.debug("Is Auto sizing tray/menu? {}", (Object)AUTO_SIZE);
            logger.debug("Is JavaFX detected? {}", (Object)JavaFx.isLoaded);
            logger.debug("Is SWT detected? {}", (Object)Swt.isLoaded);
            if (Swt.isLoaded) {
                logger.debug("SWT version: {}", (Object)Swt.getVersion());
            }
            logger.debug("Java Swing L&F: {}", (Object)UIManager.getLookAndFeel().getID());
            if (FORCE_TRAY_TYPE == TrayType.AutoDetect) {
                logger.debug("Auto-detecting tray type");
            } else {
                logger.debug("Forced tray type: {}", (Object)FORCE_TRAY_TYPE.name());
            }
            if (OS.isLinux()) {
                logger.debug("Force GTK2: {}", (Object)FORCE_GTK2);
                logger.debug("Prefer GTK3: {}", (Object)PREFER_GTK3);
            }
        }
        if ((trayType = FORCE_TRAY_TYPE == TrayType.AutoDetect ? AutoDetectTrayType.get(trayName) : AutoDetectTrayType.selectType(FORCE_TRAY_TYPE)) == null) {
            if (OSUtil.DesktopEnv.isChromeOS()) {
                logger.error("ChromeOS detected and it is not supported. Aborting.");
            }
            return null;
        }
        if (isNix) {
            if (AutoDetectTrayType.isTrayType(trayType, TrayType.Gtk)) {
                OSUtil.DesktopEnv.Env de = OSUtil.DesktopEnv.get();
                if (OSUtil.Linux.isUbuntu() && OSUtil.DesktopEnv.isUnity((OSUtil.DesktopEnv.Env)de)) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        if (Gtk.isGtk2) {
                            trayType = AutoDetectTrayType.selectType(TrayType.Swing);
                            logger.warn("Forcing Swing Tray type because Ubuntu Unity display environment removed support for GtkStatusIcons and GTK2+ was specified.");
                        } else {
                            FORCE_TRAY_TYPE = TrayType.AppIndicator;
                            trayType = AutoDetectTrayType.selectType(TrayType.AppIndicator);
                            logger.warn("Forcing AppIndicator because Ubuntu Unity display environment removed support for GtkStatusIcons.");
                        }
                    } else {
                        logger.error("Unable to use the GtkStatusIcons when running on Ubuntu with the Unity display environment, and thus the SystemTray will not work. Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.");
                        return null;
                    }
                }
                if (de == OSUtil.DesktopEnv.Env.Gnome) {
                    boolean hasWeirdOsProblems;
                    boolean bl = hasWeirdOsProblems = OSUtil.Linux.isKali() || OSUtil.Linux.isFedora();
                    if (hasWeirdOsProblems) {
                        PREFER_GTK3 = false;
                        if (DEBUG) {
                            logger.debug("Preferring GTK2 because this OS has weird graphical issues with GTK3 status icons");
                        }
                    }
                }
            }
            if (AutoDetectTrayType.isTrayType(trayType, TrayType.AppIndicator)) {
                if (ENABLE_ROOT_CHECK && OSUtil.Linux.isRoot()) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        trayType = AutoDetectTrayType.selectType(TrayType.Swing);
                        logger.warn("Attempting to load the SystemTray as the 'root/sudo' user. This will likely not work because of dbus restrictions. Using the Swing Tray type instead. Please refer to the readme notes or issue #63 on how to work around this.");
                    } else {
                        logger.error("Attempting to load the SystemTray as the 'root/sudo' user. This will likely NOT WORK because of dbus restrictions. Please refer to the readme notes or issue #63 on how to work around this.");
                    }
                }
                if (OSUtil.Linux.isElementaryOS() && OSUtil.Linux.getElementaryOSVersion()[0] >= 5 && !new File("/usr/share/doc/wingpanel-indicator-ayatana").isDirectory()) {
                    logger.error("Unable to use the SystemTray as-is with this version of ElementaryOS. By default, tray icons *are not* supported, but a workaround has been developed. Please see: https://git.dorkbox.com/dorkbox/elementary-indicators");
                    return null;
                }
            }
        }
        if (trayType == null) {
            trayType = AutoDetectTrayType.selectType(TrayType.Swing);
            logger.error("SystemTray initialization failed. (Unable to discover which implementation to use). Falling back to the Swing Tray.");
        }
        try {
            if (isNix) {
                GtkEventDispatch.startGui((boolean)FORCE_GTK2, (boolean)PREFER_GTK3, (boolean)DEBUG);
                GtkEventDispatch.waitForEventsToComplete();
                if (DEBUG) {
                    logger.debug("GTK Version: " + Gtk.MAJOR + "." + Gtk.MINOR + "." + Gtk.MICRO);
                    logger.debug("Is the system already running GTK? {}", (Object)Gtk.alreadyRunningGTK);
                }
                if (!Gtk.isLoaded) {
                    trayType = AutoDetectTrayType.selectType(TrayType.Swing);
                    logger.error("Unable to initialize GTK! Something is severely wrong! Using the Swing Tray type instead.");
                } else if (AutoDetectTrayType.isTrayType(trayType, TrayType.AppIndicator) && !AppIndicator.isLoaded) {
                    String installer = AppIndicator.getInstallString((boolean)GtkCheck.isGtk2);
                    String packageInstall = OSUtil.Linux.PackageManager.get().installString() + " " + installer;
                    String installString = "Please install " + installer + ", for example: '" + packageInstall + "'.";
                    if (AUTO_FIX_INCONSISTENCIES && java.awt.SystemTray.isSupported() && !OSUtil.DesktopEnv.isKDE()) {
                        trayType = AutoDetectTrayType.selectType(TrayType.Swing);
                        logger.warn("Unable to initialize the AppIndicator correctly. Using the Swing Tray type instead.");
                        logger.warn(installString);
                    } else {
                        logger.error("AppIndicator unable to load.  " + installString);
                        return null;
                    }
                }
            }
            if (AUTO_FIX_INCONSISTENCIES && SWING_UI == null) {
                if (isNix && AutoDetectTrayType.isTrayType(trayType, TrayType.Swing)) {
                    SWING_UI = new LinuxSwingUI();
                } else if (isWindows && (AutoDetectTrayType.isTrayType(trayType, TrayType.Swing) || AutoDetectTrayType.isTrayType(trayType, TrayType.WindowsNative))) {
                    SWING_UI = new WindowsSwingUI();
                }
            }
            int trayImageSize = SizeAndScalingUtil.getTrayImageSize();
            int menuImageSize = SizeAndScalingUtil.getMenuImageSize(trayType);
            if (DEBUG) {
                logger.debug("Tray indicator image size: {}", (Object)trayImageSize);
                logger.debug("Tray menu image size: {}", (Object)menuImageSize);
            }
            if (AUTO_FIX_INCONSISTENCIES) {
                if (isWindows && AutoDetectTrayType.isTrayType(trayType, TrayType.Swing)) {
                    SystemTrayFixes.fixWindows(trayImageSize);
                } else if (isMacOsX && (AutoDetectTrayType.isTrayType(trayType, TrayType.Awt) || AutoDetectTrayType.isTrayType(trayType, TrayType.Swing))) {
                    SystemTrayFixes.fixMacOS();
                } else if (isNix && AutoDetectTrayType.isTrayType(trayType, TrayType.Swing)) {
                    SystemTrayFixes.fixLinux(trayImageSize);
                }
            }
            if ((JavaFx.isLoaded || Swt.isLoaded) && SwingUtilities.isEventDispatchThread()) {
                logger.error("SystemTray initialization for JavaFX or SWT **CAN NOT** occur on the Swing Event Dispatch Thread (EDT). Something is seriously wrong.");
                return null;
            }
            if (AutoDetectTrayType.isTrayType(trayType, TrayType.Swing) || AutoDetectTrayType.isTrayType(trayType, TrayType.Awt) || AutoDetectTrayType.isTrayType(trayType, TrayType.WindowsNative)) {
                Toolkit.getDefaultToolkit();
            }
            SizeAndScalingUtil.getMenuImageSize(trayType);
            Runnable onRemoveEvent = () -> {
                AutoDetectTrayType.removeSystemTrayHook(trayName);
                if (!AutoDetectTrayType.hasOtherTrays()) {
                    EventDispatch.shutdown();
                }
            };
            CacheUtil cache = new CacheUtil(trayName + "Cache_" + System.getProperty("user.name"));
            ImageResizeUtil imageResizeUtil = new ImageResizeUtil(cache);
            AtomicReference<Tray> reference = new AtomicReference<Tray>();
            if (!JavaFx.isLoaded && !Swt.isLoaded && (AutoDetectTrayType.isTrayType(trayType, TrayType.Swing) || AutoDetectTrayType.isTrayType(trayType, TrayType.Awt))) {
                Class<? extends Tray> finalTrayType = trayType;
                SwingUtil.invokeAndWait(() -> {
                    try {
                        reference.set((Tray)finalTrayType.getConstructors()[0].newInstance(trayName, imageResizeUtil, onRemoveEvent));
                    }
                    catch (Exception e) {
                        logger.error("Unable to create tray type: '{}'", (Object)finalTrayType.getSimpleName(), (Object)e);
                    }
                });
            } else {
                reference.set((Tray)trayType.getConstructors()[0].newInstance(trayName, imageResizeUtil, onRemoveEvent));
            }
            Tray systemTrayMenu = (Tray)reference.get();
            if (systemTrayMenu == null) {
                logger.error("Unable to create tray type: '{}'", (Object)trayType.getSimpleName());
                return null;
            }
            if (DEBUG) {
                logger.info("Successfully loaded type: {}", (Object)trayType.getSimpleName());
            } else {
                logger.info("Successfully loaded");
            }
            Runnable shutdownRunnable = AutoDetectTrayType.getShutdownHook(trayName);
            SystemTray systemTray = new SystemTray(trayName, systemTrayMenu, imageResizeUtil, shutdownRunnable);
            AutoDetectTrayType.setInstance(trayName, systemTray);
            Runtime.getRuntime().addShutdownHook(new Thread(shutdownRunnable));
            return systemTray;
        }
        catch (Exception e) {
            logger.error("Unable to create tray type: '{}'", (Object)trayType.getSimpleName(), (Object)e);
            return null;
        }
    }

    private SystemTray(String trayName, Tray systemTrayMenu, ImageResizeUtil imageResizeUtil, Runnable shutdownRunnable) {
        this.trayName = trayName;
        this.menu = systemTrayMenu;
        this.imageResizeUtil = imageResizeUtil;
        this.shutdownRunnable = shutdownRunnable;
    }

    public void installShutdownHook() {
        AutoDetectTrayType.installShutdownHooks(this.trayName, this.getType(), this.shutdownRunnable);
    }

    public void shutdown() {
        this.menu.remove();
    }

    public String getStatus() {
        return this.menu.getStatus();
    }

    public Menu setStatus(String statusText) {
        this.menu.setStatus(statusText);
        return this.menu;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Menu setMenu(JMenu jMenu) {
        Component[] menuComponents;
        Icon icon = jMenu.getIcon();
        if (icon != null) {
            BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage(bimage);
        }
        for (Component c : menuComponents = jMenu.getMenuComponents()) {
            if (c instanceof JMenu) {
                this.menu.add((JMenu)c);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                this.menu.add((JCheckBoxMenuItem)c);
                continue;
            }
            if (c instanceof JMenuItem) {
                this.menu.add((JMenuItem)c);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            this.menu.add((JSeparator)c);
        }
        return this.menu;
    }

    public Menu setEnabled(boolean enabled) {
        this.menu.setEnabled(enabled);
        return this.menu;
    }

    public Menu setTooltip(String tooltipText) {
        this.menu.setTooltip(tooltipText);
        return this.menu;
    }

    public void setImage(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imageFile));
    }

    public Menu setImage(String imagePath) {
        if (imagePath == null) {
            throw new NullPointerException("imagePath");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imagePath));
        return this.menu;
    }

    public Menu setImage(URL imageUrl) {
        if (imageUrl == null) {
            throw new NullPointerException("imageUrl");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imageUrl));
        return this.menu;
    }

    public Menu setImage(InputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("imageStream");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imageStream));
        return this.menu;
    }

    public Menu setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, image));
        return this.menu;
    }

    public Menu setImage(ImageInputStream imageStream) {
        if (imageStream == null) {
            throw new NullPointerException("image");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imageStream));
        return this.menu;
    }

    public int getTrayImageSize() {
        return SizeAndScalingUtil.getTrayImageSize();
    }

    public int getMenuImageSize() {
        return SizeAndScalingUtil.TRAY_MENU_SIZE;
    }

    public TrayType getType() {
        return AutoDetectTrayType.fromClass(this.menu.getClass());
    }

    public void remove() {
        this.menu.remove();
    }

    static {
        Updates.INSTANCE.add(SystemTray.class, "b35c107332d844559a3f877fcef42a21", SystemTray.getVersion());
    }

    public static enum TrayType {
        AutoDetect,
        Gtk,
        AppIndicator,
        WindowsNative,
        Swing,
        Osx,
        Awt;

    }
}

