/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.awt;

import dorkbox.os.OS;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.awt.AwtMenu;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import dorkbox.util.collections.ArrayMap;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.File;
import javax.swing.ImageIcon;

public final class _AwtTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final Object keepAliveLock = new Object[0];
    private volatile Thread keepAliveThread;
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _AwtTray(String trayName, ImageResizeUtil imageResizeUtil, Runnable onRemoveEvent) {
        super(onRemoveEvent);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        AwtMenu awtMenu = new AwtMenu(null){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.invokeLater(() -> {
                    if (_AwtTray.this.tray == null) {
                        _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean enabled = menuItem.getEnabled();
                    if (OS.isMacOsX()) {
                        if (_AwtTray.this.keepAliveThread != null) {
                            Object object = _AwtTray.this.keepAliveLock;
                            synchronized (object) {
                                _AwtTray.this.keepAliveLock.notifyAll();
                            }
                        }
                        _AwtTray.this.keepAliveThread = null;
                        if (_AwtTray.this.visible && !enabled) {
                            _AwtTray.this.keepAliveThread = new Thread(() -> {
                                Object object = _AwtTray.this.keepAliveLock;
                                synchronized (object) {
                                    _AwtTray.this.keepAliveLock.notifyAll();
                                    try {
                                        _AwtTray.this.keepAliveLock.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }, "TrayKeepAliveThread");
                            _AwtTray.this.keepAliveThread.start();
                        }
                    }
                    if (_AwtTray.this.visible && !enabled) {
                        _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                        _AwtTray.this.visible = false;
                    } else if (!_AwtTray.this.visible && enabled && _AwtTray.this.trayIcon != null) {
                        try {
                            _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = true;
                            _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                        }
                        catch (AWTException e) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)e);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AwtTray.this.imageFile = menuItem.getImage();
                SwingUtil.invokeLater(() -> {
                    Image trayImage;
                    if (_AwtTray.this.tray == null) {
                        _AwtTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_AwtTray.this.imageFile != null) {
                        String path = _AwtTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _AwtTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image previousImage = (Image)_AwtTray.this.imageCache.get((Object)path);
                            if (previousImage == null) {
                                previousImage = new ImageIcon(path).getImage();
                                _AwtTray.this.imageCache.put((Object)path, (Object)previousImage);
                                if (((_AwtTray)_AwtTray.this).imageCache.size > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            trayImage = previousImage;
                        }
                    } else {
                        trayImage = null;
                    }
                    if (_AwtTray.this.trayIcon == null) {
                        if (trayImage == null) {
                            return;
                        }
                        _AwtTray.this.trayIcon = new TrayIcon(trayImage);
                        _AwtTray.this.trayIcon.setPopupMenu((PopupMenu)this._native);
                        try {
                            _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = true;
                        }
                        catch (AWTException e) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)e);
                        }
                    } else {
                        _AwtTray.this.trayIcon.setImage(trayImage);
                    }
                    _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String text = menuItem.getTooltip();
                if (_AwtTray.this.tooltipText != null && _AwtTray.this.tooltipText.equals(text) || _AwtTray.this.tooltipText == null && text != null) {
                    return;
                }
                _AwtTray.this.tooltipText = text;
                SwingUtil.invokeLater(() -> {
                    if (_AwtTray.this.trayIcon != null) {
                        _AwtTray.this.trayIcon.setToolTip(text);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = _AwtTray.this.imageCache;
                synchronized (object) {
                    for (Image value : _AwtTray.this.imageCache.values()) {
                        value.flush();
                    }
                    _AwtTray.this.imageCache.clear();
                }
                SwingUtil.invokeLater(() -> {
                    if (_AwtTray.this.trayIcon != null) {
                        _AwtTray.this.trayIcon.setPopupMenu(null);
                        if (_AwtTray.this.tray != null) {
                            _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                        }
                        _AwtTray.this.trayIcon = null;
                    }
                    _AwtTray.this.tray = null;
                });
                super.remove();
                if (_AwtTray.this.keepAliveThread != null) {
                    object = _AwtTray.this.keepAliveLock;
                    synchronized (object) {
                        _AwtTray.this.keepAliveLock.notifyAll();
                    }
                }
            }
        };
        this.bind(awtMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

