/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.jna.linux.AppIndicator;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.linux.structs.AppIndicatorInstanceStruct;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.ui.gtk.GtkMenuItemCheckbox;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public final class _AppIndicatorNativeTray
extends Tray {
    public static boolean isLoaded = false;
    private volatile AppIndicatorInstanceStruct appIndicator;
    private boolean isActive = false;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile boolean setName = false;

    public _AppIndicatorNativeTray(final String trayName, ImageResizeUtil imageResizeUtil, Runnable onRemoveEvent) {
        super(onRemoveEvent);
        isLoaded = true;
        GtkBaseMenuItem.transparentIcon = imageResizeUtil.getTransparentImage();
        GtkMenuItemCheckbox.uncheckedFile = imageResizeUtil.getTransparentImage().getAbsolutePath();
        GtkMenu gtkMenu = new GtkMenu(){

            @Override
            protected final void onMenuAdded(Pointer menu) {
                _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_menu(menu);
                if (!_AppIndicatorNativeTray.this.setName) {
                    _AppIndicatorNativeTray.this.setName = true;
                    _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_title(trayName);
                }
            }

            @Override
            public void setEnabled(MenuItem menuItem) {
                GtkEventDispatch.dispatch(() -> {
                    boolean enabled = menuItem.getEnabled();
                    if (_AppIndicatorNativeTray.this.visible && !enabled) {
                        _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(0);
                        _AppIndicatorNativeTray.this.visible = false;
                    } else if (!_AppIndicatorNativeTray.this.visible && enabled) {
                        _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(1);
                        _AppIndicatorNativeTray.this.visible = true;
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AppIndicatorNativeTray.this.imageFile = menuItem.getImage();
                if (_AppIndicatorNativeTray.this.imageFile == null) {
                    return;
                }
                GtkEventDispatch.dispatch(() -> {
                    _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_icon(_AppIndicatorNativeTray.this.imageFile.getAbsolutePath());
                    if (!_AppIndicatorNativeTray.this.isActive) {
                        _AppIndicatorNativeTray.this.isActive = true;
                        _AppIndicatorNativeTray.this.appIndicator.app_indicator_set_status(1);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
            }

            @Override
            public void remove() {
                if (!_AppIndicatorNativeTray.this.shuttingDown.getAndSet(true)) {
                    super.remove();
                    GtkEventDispatch.dispatch(() -> {
                        AppIndicatorInstanceStruct savedAppIndicator = _AppIndicatorNativeTray.this.appIndicator;
                        _AppIndicatorNativeTray.this.appIndicator = null;
                        savedAppIndicator.app_indicator_set_status(0);
                        Pointer p = savedAppIndicator.getPointer();
                        GObject.g_object_unref((Pointer)p);
                        GtkEventDispatch.shutdownGui();
                    });
                }
            }
        };
        GtkEventDispatch.dispatchAndWait(() -> {
            String id = "DBST" + System.nanoTime();
            File image = imageResizeUtil.getTransparentImage(SizeAndScalingUtil.TRAY_MENU_SIZE);
            this.appIndicator = AppIndicator.app_indicator_new((String)id, (String)image.getAbsolutePath(), (int)0);
        });
        GtkEventDispatch.waitForEventsToComplete();
        this.bind(gtkMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

