/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.jna.macos.cocoa.NSImage;
import dorkbox.jna.macos.cocoa.NSInteger;
import dorkbox.jna.macos.cocoa.NSMenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.EntryPeer;
import dorkbox.systemTray.ui.osx.OsxMenu;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import dorkbox.util.ImageUtil;
import java.awt.image.BufferedImage;

abstract class OsxBaseMenuItem
implements EntryPeer {
    private static NSImage transparentIcon = null;
    protected final OsxMenu parent;
    protected final NSMenuItem _native = new NSMenuItem();
    private final NSInteger indentationLevel = new NSInteger(1L);

    static NSImage getTransparentIcon(int menuImageSize) {
        if (transparentIcon == null) {
            NSImage transparentIcon_;
            try {
                BufferedImage image = ImageUtil.createImageAsBufferedImage((int)3, (int)menuImageSize, null);
                transparentIcon_ = new NSImage(ImageUtil.toBytes((BufferedImage)image));
            }
            catch (Exception e) {
                transparentIcon_ = null;
                SystemTray.logger.error("Error creating transparent image.", (Throwable)e);
            }
            transparentIcon = transparentIcon_;
        }
        return transparentIcon;
    }

    OsxBaseMenuItem(OsxMenu parent) {
        this.parent = parent;
        this._native.setIndentationLevel(this.indentationLevel);
        this._native.setImage(OsxBaseMenuItem.getTransparentIcon(SizeAndScalingUtil.TRAY_MENU_SIZE));
        parent.addItem(this._native);
    }

    @Override
    public void remove() {
        this._native.setImage(null);
        if (this.parent != null) {
            this.parent.removeItem(this._native);
        }
    }
}

