/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.jna.macos.cocoa.NSImage;
import dorkbox.jna.macos.cocoa.NSInteger;
import dorkbox.jna.macos.cocoa.NSMenu;
import dorkbox.jna.macos.cocoa.NSMenuItem;
import dorkbox.jna.macos.cocoa.NSString;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.osx.OsxBaseMenuItem;
import dorkbox.systemTray.ui.osx.OsxMenuItem;
import dorkbox.systemTray.ui.osx.OsxMenuItemCheckbox;
import dorkbox.systemTray.ui.osx.OsxMenuItemSeparator;
import dorkbox.systemTray.ui.osx.OsxMenuItemStatus;
import dorkbox.systemTray.util.SizeAndScalingUtil;

class OsxMenu
implements MenuPeer {
    protected final OsxMenu parent;
    protected final NSMenuItem _native = new NSMenuItem();
    volatile NSMenu _nativeMenu;
    private volatile NSImage image;
    private NSString tooltip;
    private NSString title;
    private NSString keyEquivalent;
    private final NSInteger indentationLevel = new NSInteger(1L);

    OsxMenu() {
        this(null);
    }

    OsxMenu(OsxMenu parent) {
        this.parent = parent;
        this._nativeMenu = new NSMenu();
        if (parent != null) {
            this._native.setSubmenu(this._nativeMenu);
            parent.addItem(this._native);
            this._native.setIndentationLevel(this.indentationLevel);
            this._native.setImage(OsxBaseMenuItem.getTransparentIcon(SizeAndScalingUtil.TRAY_MENU_SIZE));
        }
    }

    @Override
    public void add(Menu parentMenu, Entry entry, int index) {
        if (entry instanceof Menu) {
            OsxMenu menu = new OsxMenu(this);
            ((Menu)entry).bind(menu, parentMenu, parentMenu.getImageResizeUtil());
        } else if (entry instanceof Separator) {
            OsxMenuItemSeparator item = new OsxMenuItemSeparator(this);
            entry.bind(item, parentMenu, parentMenu.getImageResizeUtil());
        } else if (entry instanceof Checkbox) {
            OsxMenuItemCheckbox item = new OsxMenuItemCheckbox(this);
            ((Checkbox)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
        } else if (entry instanceof Status) {
            OsxMenuItemStatus item = new OsxMenuItemStatus(this);
            ((Status)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
        } else if (entry instanceof MenuItem) {
            OsxMenuItem item = new OsxMenuItem(this);
            ((MenuItem)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
        }
    }

    @Override
    public void setImage(MenuItem menuItem) {
        if (menuItem.getImage() != null) {
            this._native.setState(1);
            this.image = new NSImage(menuItem.getImage());
            this._native.setOnStateImage(this.image);
        } else {
            this._native.setState(0);
            this._native.setOnStateImage(null);
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        this._native.setEnabled(menuItem.getEnabled());
    }

    @Override
    public void setText(MenuItem menuItem) {
        String text = menuItem.getText();
        this.title = text == null || text.isEmpty() ? null : new NSString(text);
        this._native.setTitle(this.title);
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        this.keyEquivalent = shortcut != '\u0000' ? new NSString(Character.toString(shortcut).toLowerCase()) : new NSString("");
        this._native.setKeyEquivalent(this.keyEquivalent);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        String tooltip = menuItem.getTooltip();
        this.tooltip = tooltip == null || tooltip.isEmpty() ? null : new NSString(tooltip);
        this._native.setToolTip(this.tooltip);
    }

    @Override
    public void remove() {
        if (this.parent != null) {
            this.parent.removeItem(this._native);
        }
        this.title = null;
        this.tooltip = null;
        this.keyEquivalent = null;
        this.image = null;
        this._native.setImage(null);
        this._native.setTarget(null);
        this._native.setAction(null);
    }

    void addItem(NSMenuItem item) {
        this._nativeMenu.addItem(item);
    }

    void removeItem(NSMenuItem item) {
        this._nativeMenu.removeItem(item);
    }
}

