/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.jna.macos.cocoa.NSImage;
import dorkbox.jna.macos.cocoa.NSObject;
import dorkbox.jna.macos.cocoa.NSString;
import dorkbox.jna.macos.cocoa.OsxClickCallback;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.osx.OsxBaseMenuItem;
import dorkbox.systemTray.ui.osx.OsxClickAction;
import dorkbox.systemTray.ui.osx.OsxMenu;
import dorkbox.systemTray.util.EventDispatch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class OsxMenuItem
extends OsxBaseMenuItem
implements MenuItemPeer,
OsxClickCallback {
    private volatile ActionListener callback;
    private final OsxClickAction clickAction = new OsxClickAction(this);
    private volatile NSImage image;
    private NSString tooltip;
    private NSString title;
    private NSString keyEquivalent;

    OsxMenuItem(OsxMenu parent) {
        super(parent);
        this._native.setTarget((NSObject)this.clickAction);
        this._native.setAction(OsxClickAction.action);
    }

    public void click() {
        ActionListener callback = this.callback;
        if (callback != null) {
            callback.actionPerformed(null);
        }
    }

    @Override
    public void setImage(MenuItem menuItem) {
        if (menuItem.getImage() != null) {
            this._native.setState(1);
            this.image = new NSImage(menuItem.getImage());
            this._native.setOnStateImage(this.image);
        } else {
            this._native.setState(0);
            this._native.setOnStateImage(null);
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        this._native.setEnabled(menuItem.getEnabled());
    }

    @Override
    public void setText(MenuItem menuItem) {
        String text = menuItem.getText();
        this.title = text == null || text.isEmpty() ? null : new NSString(text);
        this._native.setTitle(this.title);
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        this.keyEquivalent = shortcut != '\u0000' ? new NSString(Character.toString(shortcut).toLowerCase()) : new NSString("");
        this._native.setKeyEquivalent(this.keyEquivalent);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        String tooltip = menuItem.getTooltip();
        this.tooltip = tooltip == null || tooltip.isEmpty() ? null : new NSString(tooltip);
        this._native.setToolTip(this.tooltip);
    }

    @Override
    public void remove() {
        super.remove();
        this.title = null;
        this.tooltip = null;
        this.keyEquivalent = null;
        this.callback = null;
        this._native.setTarget(null);
        this._native.setAction(null);
        this.clickAction.remove();
        this.image = null;
    }
}

