/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.jna.macos.cocoa.NSImage;
import dorkbox.jna.macos.cocoa.NSStatusBar;
import dorkbox.jna.macos.cocoa.NSStatusItem;
import dorkbox.jna.macos.cocoa.NSString;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.osx.OsxMenu;
import dorkbox.systemTray.util.ImageResizeUtil;
import java.io.File;

public class _OsxNativeTray
extends Tray {
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final Object keepAliveLock = new Object[0];
    private final Thread keepAliveThread = new Thread(() -> {
        Object object = this.keepAliveLock;
        synchronized (object) {
            this.keepAliveLock.notifyAll();
            try {
                this.keepAliveLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }, "TrayKeepAliveThread");
    private final NSStatusBar statusBar;
    private volatile NSStatusItem statusItem;
    private volatile NSString statusItemTooltip;
    private volatile NSImage statusItemImage;

    public _OsxNativeTray(String trayName, ImageResizeUtil imageResizeUtil, Runnable onRemoveEvent) {
        super(onRemoveEvent);
        this.keepAliveThread.start();
        OsxMenu osxMenu = new OsxMenu(){

            @Override
            public void setEnabled(MenuItem menuItem) {
                if (_OsxNativeTray.this.statusItem == null) {
                    _OsxNativeTray.this.statusItem = _OsxNativeTray.this.statusBar.newStatusItem();
                    _OsxNativeTray.this.statusItem.setHighlightMode(true);
                    _OsxNativeTray.this.statusItem.setMenu(this._nativeMenu);
                }
                boolean enabled = menuItem.getEnabled();
                if (_OsxNativeTray.this.visible && !enabled) {
                    _OsxNativeTray.this.statusBar.removeStatusItem(_OsxNativeTray.this.statusItem);
                    _OsxNativeTray.this.visible = false;
                } else if (!_OsxNativeTray.this.visible && enabled) {
                    _OsxNativeTray.this.visible = true;
                    _OsxNativeTray.this.statusItem.setToolTip(_OsxNativeTray.this.statusItemTooltip);
                    _OsxNativeTray.this.statusItem.setImage(_OsxNativeTray.this.statusItemImage);
                }
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _OsxNativeTray.this.imageFile = menuItem.getImage();
                if (_OsxNativeTray.this.statusItem == null) {
                    _OsxNativeTray.this.statusItem = _OsxNativeTray.this.statusBar.newStatusItem();
                    _OsxNativeTray.this.statusItem.setHighlightMode(true);
                    _OsxNativeTray.this.statusItem.setMenu(this._nativeMenu);
                }
                if (_OsxNativeTray.this.imageFile == null) {
                    _OsxNativeTray.this.statusItemImage = null;
                } else {
                    _OsxNativeTray.this.statusItemImage = new NSImage(_OsxNativeTray.this.imageFile);
                }
                _OsxNativeTray.this.statusItem.setImage(_OsxNativeTray.this.statusItemImage);
                _OsxNativeTray.this.statusItem.setToolTip(_OsxNativeTray.this.statusItemTooltip);
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                if (_OsxNativeTray.this.statusItem == null) {
                    _OsxNativeTray.this.statusItem = _OsxNativeTray.this.statusBar.newStatusItem();
                    _OsxNativeTray.this.statusItem.setHighlightMode(true);
                    _OsxNativeTray.this.statusItem.setMenu(this._nativeMenu);
                }
                String text = menuItem.getTooltip();
                if (_OsxNativeTray.this.tooltipText != null && _OsxNativeTray.this.tooltipText.equals(text) || _OsxNativeTray.this.tooltipText == null && text != null) {
                    return;
                }
                if (text == null) {
                    _OsxNativeTray.this.tooltipText = "";
                } else {
                    _OsxNativeTray.this.tooltipText = text;
                }
                _OsxNativeTray.this.statusItemTooltip = new NSString(_OsxNativeTray.this.tooltipText);
                _OsxNativeTray.this.statusItem.setImage(_OsxNativeTray.this.statusItemImage);
                _OsxNativeTray.this.statusItem.setToolTip(_OsxNativeTray.this.statusItemTooltip);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (_OsxNativeTray.this.statusItem != null) {
                    _OsxNativeTray.this.statusBar.removeStatusItem(_OsxNativeTray.this.statusItem);
                }
                _OsxNativeTray.this.statusItem = null;
                _OsxNativeTray.this.statusItemTooltip = null;
                _OsxNativeTray.this.statusItemImage = null;
                Object object = _OsxNativeTray.this.keepAliveLock;
                synchronized (object) {
                    _OsxNativeTray.this.keepAliveLock.notifyAll();
                }
                super.remove();
            }
        };
        this.statusBar = NSStatusBar.systemStatusBar();
        this.bind(osxMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

