/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.SizeAndScalingUtil;
import dorkbox.util.SwingUtil;
import dorkbox.util.collections.ArrayMap;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public final class _SwingTray
extends Tray {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final ArrayMap<String, Image> imageCache = new ArrayMap(false, 10);

    public _SwingTray(String trayName, ImageResizeUtil imageResizeUtil, Runnable onRemoveEvent) {
        super(onRemoveEvent);
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        SwingMenuItem.createTransparentIcon(SizeAndScalingUtil.TRAY_MENU_SIZE, imageResizeUtil);
        SwingMenuItemCheckbox.createCheckedIcon(SizeAndScalingUtil.TRAY_MENU_SIZE);
        SwingMenu swingMenu = new SwingMenu(trayName){

            @Override
            public void setEnabled(MenuItem menuItem) {
                SwingUtil.invokeLater(() -> {
                    if (_SwingTray.this.tray == null) {
                        _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    boolean enabled = menuItem.getEnabled();
                    if (_SwingTray.this.visible && !enabled) {
                        _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                        _SwingTray.this.visible = false;
                    } else if (!_SwingTray.this.visible && enabled) {
                        try {
                            _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                            _SwingTray.this.visible = true;
                            _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                        }
                        catch (AWTException e) {
                            SystemTray.logger.error("Error adding the icon back to the tray", (Throwable)e);
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _SwingTray.this.imageFile = menuItem.getImage();
                SwingUtil.invokeLater(() -> {
                    Image trayImage;
                    if (_SwingTray.this.tray == null) {
                        _SwingTray.this.tray = java.awt.SystemTray.getSystemTray();
                    }
                    if (_SwingTray.this.imageFile != null) {
                        String path = _SwingTray.this.imageFile.getAbsolutePath();
                        ArrayMap arrayMap = _SwingTray.this.imageCache;
                        synchronized (arrayMap) {
                            Image previousImage = (Image)_SwingTray.this.imageCache.get((Object)path);
                            if (previousImage == null) {
                                previousImage = new ImageIcon(path).getImage();
                                _SwingTray.this.imageCache.put((Object)path, (Object)previousImage);
                                if (((_SwingTray)_SwingTray.this).imageCache.size > 120) {
                                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                                }
                            }
                            trayImage = previousImage;
                        }
                    } else {
                        trayImage = null;
                    }
                    if (_SwingTray.this.trayIcon == null) {
                        if (trayImage == null) {
                            return;
                        }
                        _SwingTray.this.trayIcon = new TrayIcon(trayImage);
                        JPopupMenu popupMenu = (JPopupMenu)this._native;
                        popupMenu.pack();
                        popupMenu.setFocusable(true);
                        if (_SwingTray.this.tooltipText != null && !_SwingTray.this.tooltipText.isEmpty()) {
                            _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                        }
                        _SwingTray.this.trayIcon.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent e) {
                                TrayPopup popupMenu = (TrayPopup)_native;
                                Point mousePosition = e.getPoint();
                                double scale = SizeAndScalingUtil.getWindowsDpiScaleForMouseClick(mousePosition.x, mousePosition.y);
                                Point point = new Point((int)((double)mousePosition.x * scale), (int)((double)mousePosition.y * scale));
                                popupMenu.doShow(point, 0);
                            }
                        });
                        try {
                            _SwingTray.this.tray.add(_SwingTray.this.trayIcon);
                        }
                        catch (AWTException e) {
                            SystemTray.logger.error("TrayIcon could not be added.", (Throwable)e);
                        }
                    } else if (trayImage != null) {
                        _SwingTray.this.trayIcon.setImage(trayImage);
                    }
                    _SwingTray.this.trayIcon.setToolTip(_SwingTray.this.tooltipText);
                    if (_SwingTray.this.imageFile != null) {
                        ((TrayPopup)this._native).setTitleBarImage(_SwingTray.this.imageFile);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String text = menuItem.getTooltip();
                if (_SwingTray.this.tooltipText != null && _SwingTray.this.tooltipText.equals(text) || _SwingTray.this.tooltipText == null && text != null) {
                    return;
                }
                _SwingTray.this.tooltipText = text;
                SwingUtil.invokeLater(() -> {
                    if (_SwingTray.this.trayIcon != null) {
                        _SwingTray.this.trayIcon.setToolTip(text);
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                ArrayMap arrayMap = _SwingTray.this.imageCache;
                synchronized (arrayMap) {
                    for (Image value : _SwingTray.this.imageCache.values()) {
                        value.flush();
                    }
                    _SwingTray.this.imageCache.clear();
                }
                SwingUtil.invokeLater(() -> {
                    if (_SwingTray.this.trayIcon != null) {
                        if (_SwingTray.this.tray != null) {
                            _SwingTray.this.tray.remove(_SwingTray.this.trayIcon);
                        }
                        _SwingTray.this.trayIcon = null;
                    }
                    _SwingTray.this.tray = null;
                });
                super.remove();
                if (OS.isLinux() || OS.isUnix()) {
                    GtkEventDispatch.shutdownGui();
                }
            }
        };
        this.bind(swingMenu, null, imageResizeUtil);
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

