/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.javaFx.JavaFx;
import dorkbox.os.OS;
import dorkbox.os.OSUtil;
import dorkbox.swt.Swt;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.gnomeShell.AppIndicatorExtension;
import dorkbox.systemTray.gnomeShell.DummyFile;
import dorkbox.systemTray.gnomeShell.LegacyExtension;
import dorkbox.systemTray.ui.awt._AwtTray;
import dorkbox.systemTray.ui.gtk._AppIndicatorNativeTray;
import dorkbox.systemTray.ui.gtk._GtkStatusIconNativeTray;
import dorkbox.systemTray.ui.osx._OsxNativeTray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.IO;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;

public class AutoDetectTrayType {
    private static final Map<String, SystemTray> traySingletons = new HashMap<String, SystemTray>();

    public static Class<? extends Tray> selectType(SystemTray.TrayType trayType) {
        if (trayType == SystemTray.TrayType.Gtk) {
            return _GtkStatusIconNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.AppIndicator) {
            return _AppIndicatorNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.WindowsNative) {
            return _WindowsNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.Swing) {
            return _SwingTray.class;
        }
        if (trayType == SystemTray.TrayType.Osx) {
            return _OsxNativeTray.class;
        }
        if (trayType == SystemTray.TrayType.Awt) {
            return _AwtTray.class;
        }
        return null;
    }

    public static SystemTray.TrayType fromClass(Class<? extends Tray> trayClass) {
        if (trayClass == _GtkStatusIconNativeTray.class) {
            return SystemTray.TrayType.Gtk;
        }
        if (trayClass == _AppIndicatorNativeTray.class) {
            return SystemTray.TrayType.AppIndicator;
        }
        if (trayClass == _WindowsNativeTray.class) {
            return SystemTray.TrayType.WindowsNative;
        }
        if (trayClass == _SwingTray.class) {
            return SystemTray.TrayType.Swing;
        }
        if (trayClass == _OsxNativeTray.class) {
            return SystemTray.TrayType.Osx;
        }
        if (trayClass == _AwtTray.class) {
            return SystemTray.TrayType.Awt;
        }
        return null;
    }

    public static boolean isTrayType(Class<? extends Tray> tray, SystemTray.TrayType trayType) {
        switch (trayType) {
            case Gtk: {
                return tray == _GtkStatusIconNativeTray.class;
            }
            case AppIndicator: {
                return tray == _AppIndicatorNativeTray.class;
            }
            case WindowsNative: {
                return tray == _WindowsNativeTray.class;
            }
            case Swing: {
                return tray == _SwingTray.class;
            }
            case Osx: {
                return tray == _OsxNativeTray.class;
            }
            case Awt: {
                return tray == _AwtTray.class;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<? extends Tray> get(String trayName) {
        block43: {
            if (OS.isWindows()) {
                return AutoDetectTrayType.selectType(SystemTray.TrayType.WindowsNative);
            }
            if (OS.isMacOsX()) {
                return AutoDetectTrayType.selectType(SystemTray.TrayType.Osx);
            }
            if (!OS.isLinux()) {
                if (!OS.isUnix()) throw new RuntimeException("This OS is not supported. Please create an issue with the details from `SystemTray.DEBUG=true;`");
            }
            OSUtil.DesktopEnv.Env de = OSUtil.DesktopEnv.get();
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Currently using the '{}' desktop environment" + OS.LINE_SEPARATOR + OSUtil.Linux.getInfo(), (Object)de);
            }
            switch (de) {
                case Gnome: {
                    String GDM = System.getenv("GDMSESSION");
                    if (GDM == null) {
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("GDMSESSION value is not set by OS. Checking '/etc/os-release' for more info.");
                        }
                        if (OSUtil.Linux.isPop()) {
                            GDM = "ubuntu";
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("Detected popOS! Using 'ubuntu' for that configuration.");
                            }
                        }
                    }
                    if (SystemTray.DEBUG) {
                        SystemTray.logger.debug("Currently using the '{}' session type", (Object)GDM);
                    }
                    if ("gnome".equalsIgnoreCase(GDM) || "default".equalsIgnoreCase(GDM)) {
                        if (OSUtil.Linux.isUbuntu()) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        String gnomeVersion = OSUtil.DesktopEnv.getGnomeVersion();
                        if (gnomeVersion == null) {
                            SystemTray.logger.error("GNOME shell detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Gnome Version: {}", (Object)gnomeVersion);
                        }
                        int major = 0;
                        double minorAndPatch = 0.0;
                        String[] split = gnomeVersion.split("\\.", 2);
                        try {
                            major = Integer.parseInt(split[0]);
                            minorAndPatch = Double.parseDouble(split[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (major == 2) {
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (major != 3) {
                            SystemTray.logger.error("GNOME shell detected, but UNSUPPORTED shell version (" + gnomeVersion + "). Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (minorAndPatch < 16.0) {
                            SystemTray.logger.warn("SystemTray works, but will only show via SUPER+M.");
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (minorAndPatch < 26.0) {
                            Tray.gtkGnomeWorkaround = true;
                            LegacyExtension.install(trayName);
                            return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                        }
                        if (AppIndicatorExtension.isInstalled()) return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                        AppIndicatorExtension.install();
                        SystemTray.logger.error("You must log out and then in again for system tray settings to apply.");
                        return null;
                    }
                    if ("cinnamon".equalsIgnoreCase(GDM)) {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    if ("gnome-classic".equalsIgnoreCase(GDM)) {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    if ("gnome-fallback".equalsIgnoreCase(GDM)) {
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    if (!"ubuntu".equalsIgnoreCase(GDM)) {
                        SystemTray.logger.error("GNOME shell detected, but UNKNOWN type. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    int[] version = OSUtil.Linux.getUbuntuVersion();
                    if (version[0] == 17 && version[1] == 10) {
                        Tray.gtkGnomeWorkaround = true;
                        LegacyExtension.install(trayName);
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    }
                    if (version[0] < 18) return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    DummyFile.install();
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                case KDE: {
                    double plasmaVersion = OSUtil.DesktopEnv.getPlasmaVersion();
                    if (SystemTray.DEBUG) {
                        SystemTray.logger.debug("KDE Plasma Version: {}", (Object)plasmaVersion);
                    }
                    if (plasmaVersion == 0.0) {
                        SystemTray.logger.error("KDE Plasma detected, but UNDEFINED shell version. This should never happen. Falling back to GtkStatusIcon. Please create an issue with as many details as possible.");
                        return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                    }
                    if (!(plasmaVersion <= 5.5)) return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                }
                case Unity: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                case Unity7: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                case XFCE: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                }
                case LXDE: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                }
                case MATE: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.Gtk);
                }
                case Pantheon: {
                    return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                }
                case ChromeOS: {
                    return null;
                }
            }
            BufferedReader bin = null;
            try {
                File proc = new File("/proc");
                File[] listFiles = proc.listFiles();
                if (listFiles == null) break block43;
                for (File procs : listFiles) {
                    block44: {
                        Class<? extends Tray> clazz;
                        File status;
                        String name = procs.getName();
                        if (!Character.isDigit(name.charAt(0)) || !(status = new File(procs, "status")).canRead()) continue;
                        try {
                            bin = new BufferedReader(new FileReader(status));
                            String readLine = bin.readLine();
                            if (readLine == null || !readLine.contains("indicator-app")) break block44;
                            clazz = AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
                        }
                        catch (Throwable throwable) {
                            IO.closeQuietly(bin);
                            throw throwable;
                        }
                        IO.closeQuietly((Closeable)bin);
                        return clazz;
                    }
                    IO.closeQuietly((Closeable)bin);
                }
            }
            catch (Throwable e) {
                if (!SystemTray.DEBUG) break block43;
                SystemTray.logger.error("Error detecting gnome version", e);
            }
        }
        if (!OS.isLinux()) throw new RuntimeException("This OS is not supported. Please create an issue with the details from `SystemTray.DEBUG=true;`");
        if (OSUtil.Linux.isUbuntu()) {
            return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
        }
        if (!OSUtil.Linux.isFedora()) return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
        return AutoDetectTrayType.selectType(SystemTray.TrayType.AppIndicator);
    }

    public static Runnable getShutdownHook(String trayName) {
        return () -> {
            Map<String, SystemTray> map = traySingletons;
            synchronized (map) {
                if (traySingletons.containsKey(trayName)) {
                    EventDispatch.runLater(() -> {
                        Map<String, SystemTray> map = traySingletons;
                        synchronized (map) {
                            SystemTray systemTray = traySingletons.remove(trayName);
                            if (systemTray != null) {
                                systemTray.shutdown();
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(String trayName, SystemTray systemTray) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.put(trayName, systemTray);
        }
    }

    public static void installShutdownHooks(String trayName, SystemTray.TrayType trayType, Runnable shutdownRunnable) {
        if (JavaFx.isLoaded) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Installing JavaFX shutdown hook");
            }
            JavaFx.onShutdown((Runnable)shutdownRunnable);
        } else if (Swt.isLoaded) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Installing SWT shutdown hook");
            }
            Swt.onShutdown((Runnable)shutdownRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSystemTrayHook(String trayName) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            traySingletons.remove(trayName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOtherTrays() {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return !traySingletons.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemTray getInstance(String trayName) {
        Map<String, SystemTray> map = traySingletons;
        synchronized (map) {
            return traySingletons.get(trayName);
        }
    }
}

