/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import dorkbox.jna.linux.GtkTheme;
import dorkbox.jna.windows.ShCore;
import dorkbox.jna.windows.User32;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing._SwingTray;
import dorkbox.systemTray.ui.swing._WindowsNativeTray;
import dorkbox.util.SwingUtil;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class SizeAndScalingUtil {
    public static int TRAY_SIZE = 0;
    public static int TRAY_MENU_SIZE = 0;

    public static int getMacOSScaleFactor() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfig = graphicsDevice.getDefaultConfiguration();
        return (int)graphicsConfig.getDefaultTransform().getScaleX();
    }

    public static double getWindowsDpiScaleForMouseClick(int mousePositionX, int mousePositionY) {
        WinDef.POINT.ByValue pointValue = new WinDef.POINT.ByValue(mousePositionX, mousePositionY);
        WinUser.HMONITOR monitorFromPoint = User32.User32.MonitorFromPoint(pointValue, 2);
        IntByReference xScalePtr = new IntByReference();
        IntByReference yScalePtr = new IntByReference();
        ShCore.GetDpiForMonitor((WinUser.HMONITOR)monitorFromPoint, (int)0, (IntByReference)xScalePtr, (IntByReference)yScalePtr);
        return 96.0 / (double)xScalePtr.getValue();
    }

    public static int getTrayImageSize() {
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = OS.isLinux() ? GtkTheme.getIndicatorSize() : (OS.isMacOsX() ? SizeAndScalingUtil.getMacOSScaleFactor() * 18 : (OS.isWindows() ? User32.User32.GetSystemMetrics(50) : 32));
        }
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = 32;
        }
        return TRAY_SIZE;
    }

    public static int getMenuImageSize(Class<? extends Tray> trayType) {
        if (TRAY_MENU_SIZE == 0) {
            if (OS.isMacOsX()) {
                TRAY_MENU_SIZE = SizeAndScalingUtil.getMacOSScaleFactor() * 18;
            } else if (trayType == _SwingTray.class || trayType == _WindowsNativeTray.class) {
                if (OS.isWindows()) {
                    TRAY_MENU_SIZE = User32.User32.GetSystemMetrics(72) - 1;
                } else {
                    AtomicInteger iconSize = new AtomicInteger();
                    SwingUtil.invokeAndWaitQuietly(() -> {
                        JMenuItem jMenuItem = new JMenuItem();
                        if (SystemTray.SWING_UI != null) {
                            jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                        }
                        int height = SwingUtil.getLargestIconHeightForButton((AbstractButton)jMenuItem);
                        iconSize.set(height);
                    });
                    TRAY_MENU_SIZE = iconSize.get();
                }
            } else {
                TRAY_MENU_SIZE = OS.isLinux() ? GtkTheme.getMenuEntryImageSize() : 16;
            }
        }
        return TRAY_MENU_SIZE;
    }
}

