/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.FileUtil;
import dorkbox.util.LocationResolver;
import dorkbox.util.Sys;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u001c\u0010\u0012\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0014\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldorkbox/util/CacheUtil;", "", "tempDir", "", "(Ljava/lang/String;)V", "check", "Ljava/io/File;", "file", "fileStream", "Ljava/io/InputStream;", "fileResource", "Ljava/net/URL;", "fileName", "cacheName", "clear", "", "create", "makeCacheFile", "makeFileViaStream", "resourceStream", "save", "Companion", "Utilities"})
@SourceDebugExtension(value={"SMAP\nCacheUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheUtil.kt\ndorkbox/util/CacheUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,369:1\n1#2:370\n*E\n"})
public final class CacheUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tempDir;
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();
    private static final ThreadLocal<MessageDigest> digestLocal = ThreadLocal.withInitial(CacheUtil::digestLocal$lambda$1);

    public CacheUtil(@NotNull String tempDir) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        this.tempDir = tempDir;
    }

    public /* synthetic */ CacheUtil(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "cache";
        }
        this(string);
    }

    public final void clear() {
        FileUtil.INSTANCE.delete(new File(OS.INSTANCE.getTEMP_DIR(), this.tempDir), new String[0]);
    }

    @Nullable
    public final File check(@Nullable File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return this.check(file.getAbsolutePath());
    }

    @Nullable
    public final File check(@Nullable String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        File newFile = this.makeCacheFile(fileName);
        return newFile.canRead() && newFile.isFile() ? newFile : null;
    }

    @Nullable
    public final File check(@NotNull URL fileResource) {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.check(fileResource.getPath());
    }

    @Nullable
    public final File check(@NotNull InputStream fileStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileStream, (String)"fileStream");
        return this.check(null, fileStream);
    }

    @Nullable
    public final File check(@Nullable String cacheName, @NotNull InputStream fileStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileStream, (String)"fileStream");
        File newFile = cacheName == null ? this.makeCacheFile(Companion.createNameAsHash(fileStream)) : this.makeCacheFile(cacheName);
        return newFile.canRead() && newFile.isFile() ? newFile : null;
    }

    @NotNull
    public final File save(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.save(file.getAbsolutePath(), file);
    }

    @NotNull
    public final File save(@Nullable String cacheName, @NotNull File file) throws IOException {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (cacheName == null) {
            String string = file.getAbsolutePath();
            String string2 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
            file2 = this.save(string, string2);
        } else {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            file2 = this.save(cacheName, string);
        }
        return file2;
    }

    @NotNull
    public final File save(@NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.save(null, fileName);
    }

    @NotNull
    public final File save(@Nullable String cacheName, @NotNull String fileName) throws IOException {
        File file;
        File newFile;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file2 = newFile = cacheName == null ? this.makeCacheFile(fileName) : this.makeCacheFile(cacheName);
        if (newFile.canRead() && newFile.isFile()) {
            return newFile;
        }
        File iconTest = new File(fileName);
        if (iconTest.isFile()) {
            if (!iconTest.canRead()) {
                throw new IOException("File exists but unable to read source file " + fileName);
            }
            FileUtil.INSTANCE.copyFile(iconTest, newFile);
            file = newFile;
        } else {
            URL uRL = LocationResolver.Companion.getResource(fileName);
            if (uRL == null) {
                throw new IOException("Unable to load URL resource " + fileName);
            }
            URL systemResource = uRL;
            InputStream inStream = systemResource.openStream();
            file = this.makeFileViaStream(cacheName, inStream);
        }
        return file;
    }

    @NotNull
    public final File save(@NotNull URL fileResource) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        return this.save(null, fileResource);
    }

    @NotNull
    public final File save(@Nullable String cacheName, @NotNull URL fileResource) throws IOException {
        File newFile;
        File file;
        Intrinsics.checkNotNullParameter((Object)fileResource, (String)"fileResource");
        if (cacheName == null) {
            String string = fileResource.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileResource.path");
            file = this.makeCacheFile(string);
        } else {
            file = newFile = this.makeCacheFile(cacheName);
        }
        if (newFile.canRead() && newFile.isFile()) {
            return newFile;
        }
        InputStream inStream = fileResource.openStream();
        return this.makeFileViaStream(cacheName, inStream);
    }

    @NotNull
    public final File save(@Nullable InputStream fileStream) throws IOException {
        if (fileStream == null) {
            throw new NullPointerException("fileStream");
        }
        return this.save(null, fileStream);
    }

    @NotNull
    public final File save(@Nullable String cacheName, @NotNull InputStream fileStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileStream, (String)"fileStream");
        File newFile = cacheName == null ? this.makeCacheFile(Companion.createNameAsHash(fileStream)) : this.makeCacheFile(cacheName);
        return newFile.canRead() && newFile.isFile() ? newFile : this.makeFileViaStream(cacheName, fileStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final File makeFileViaStream(String cacheName, InputStream resourceStream) throws IOException {
        if (resourceStream == null) {
            throw new NullPointerException("resourceStream");
        }
        if (cacheName == null) {
            throw new NullPointerException("cacheName");
        }
        File newFile = this.makeCacheFile(cacheName);
        if (newFile.canRead() && newFile.isFile()) {
            File file = newFile.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"newFile.absoluteFile");
            return file;
        }
        OutputStream outStream = null;
        try {
            int read2332 = 0;
            byte[] buffer = new byte[2048];
            outStream = new FileOutputStream(newFile);
            while (true) {
                int n;
                int it = n = resourceStream.read(buffer);
                boolean bl = false;
                read2332 = it;
                if (n > 0) {
                    ((FileOutputStream)outStream).write(buffer, 0, read2332);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            try {
                String message = "Unable to copy '" + cacheName + "' to temporary location: '" + newFile.getAbsolutePath() + '\'';
                throw new IOException(message, e);
            }
            catch (Throwable throwable) {
                try {
                    resourceStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    OutputStream outputStream;
                    OutputStream outputStream2 = outputStream = outStream;
                    if (outputStream2 == null) throw throwable;
                    outputStream2.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            resourceStream.close();
        }
        catch (Exception read2332) {
            // empty catch block
        }
        try {
            OutputStream read2332 = outStream;
            read2332.close();
        }
        catch (Exception read2332) {}
        File file = newFile.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"newFile.absoluteFile");
        return file;
    }

    @NotNull
    public final File create(@NotNull String cacheName) {
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        return this.makeCacheFile(cacheName);
    }

    private final File makeCacheFile(String cacheName) {
        File saveDir = new File(OS.INSTANCE.getTEMP_DIR(), this.tempDir);
        String hash = CacheUtil.Companion.hashName(cacheName);
        String extension = Sys.INSTANCE.getExtension(cacheName);
        if (((CharSequence)extension).length() == 0) {
            extension = "cache";
        }
        File newFile = new File(saveDir, hash + '.' + extension).getAbsoluteFile();
        newFile.getParentFile().mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)newFile, (String)"newFile");
        return newFile;
    }

    private static final MessageDigest digestLocal$lambda$1() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize hash algorithm. SHA1 digest doesn't exist?!? (This should not happen");
        }
    }

    public CacheUtil() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ldorkbox/util/CacheUtil$Companion;", "", "()V", "digestLocal", "Ljava/lang/ThreadLocal;", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "version", "", "getVersion", "()Ljava/lang/String;", "clear", "", "tempDir", "createNameAsHash", "resourceStream", "Ljava/io/InputStream;", "hashName", "name", "Utilities"})
    @SourceDebugExtension(value={"SMAP\nCacheUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheUtil.kt\ndorkbox/util/CacheUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,369:1\n1#2:370\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        public final void clear(@NotNull String tempDir) {
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            new CacheUtil(tempDir).clear();
        }

        private final String hashName(String name) {
            String string = name;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            MessageDigest digest = (MessageDigest)digestLocal.get();
            digest.reset();
            digest.update(bytes);
            String string2 = new BigInteger(1, digest.digest()).toString(32);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BigInteger(1, digest.digest()).toString(32)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String createNameAsHash(@NotNull InputStream resourceStream) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)resourceStream, (String)"resourceStream");
            MessageDigest digest = (MessageDigest)digestLocal.get();
            digest.reset();
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
                int read2 = 0;
                byte[] buffer = new byte[2048];
                while (true) {
                    int n;
                    int it = n = resourceStream.read(buffer);
                    boolean bl = false;
                    read2 = it;
                    if (n <= 0) break;
                    digest.update(buffer, 0, read2);
                    outStream.write(buffer, 0, read2);
                }
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = new BigInteger(1, digest.digest()).toString(32);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"BigInteger(1, digest.digest()).toString(32)");
                String string3 = string2.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                string = stringBuilder.append(string3).append(".cache").toString();
            }
            catch (IOException e) {
                String message = "Unable to copy InputStream to memory.";
                throw new IOException(message, e);
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (Exception exception) {}
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

