/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.Sys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\f"}, d2={"Ldorkbox/util/LocationResolver;", "", "()V", "getDirectoryContents", "", "", "clazz", "Ljava/lang/Class;", "path", "(Ljava/lang/Class;Ljava/lang/String;)[Ljava/lang/String;", "Companion", "Root", "Utilities"})
@SourceDebugExtension(value={"SMAP\nLocationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationResolver.kt\ndorkbox/util/LocationResolver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,561:1\n37#2,2:562\n*S KotlinDebug\n*F\n+ 1 LocationResolver.kt\ndorkbox/util/LocationResolver\n*L\n74#1:562,2\n*E\n"})
public final class LocationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();
    private static final Pattern SLASH_PATTERN = Pattern.compile("\\\\");

    @NotNull
    public final String[] getDirectoryContents(@NotNull Class<?> clazz, @NotNull String path) throws URISyntaxException, IOException {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && Intrinsics.areEqual((Object)dirURL.getProtocol(), (Object)"file")) {
            String[] stringArray = new File(dirURL.toURI()).list();
            Intrinsics.checkNotNull((Object)stringArray);
            return stringArray;
        }
        if (dirURL == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
            String me = stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null)).append(".class").toString();
            dirURL = clazz.getClassLoader().getResource(me);
        }
        URL uRL = dirURL;
        Intrinsics.checkNotNull((Object)uRL);
        if (Intrinsics.areEqual((Object)uRL.getProtocol(), (Object)"jar")) {
            String string = dirURL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dirURL.path");
            String string2 = string;
            int n = 5;
            String string3 = dirURL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dirURL.path");
            int n2 = StringsKt.indexOf$default((CharSequence)string3, (String)"!", (int)0, (boolean)false, (int)6, null);
            String string4 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String jarPath = string4;
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            Set result = new HashSet();
            while (entries.hasMoreElements()) {
                String entry;
                String name = entries.nextElement().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (!StringsKt.startsWith$default((String)name, (String)path, (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name.substring(path.length()), (String)"this as java.lang.String).substring(startIndex)");
                int checkSubdir = StringsKt.indexOf$default((CharSequence)entry, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (checkSubdir >= 0) {
                    String string5 = entry.substring(0, checkSubdir);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    entry = string5;
                }
                result.add(entry);
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\b\u0002\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0087\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007J&\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002J \u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0002J\u001e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Ldorkbox/util/LocationResolver$Companion;", "", "()V", "SLASH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "version", "", "getVersion", "()Ljava/lang/String;", "get", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "getResource", "Ljava/net/URL;", "resourceName", "getResourceAsStream", "Ljava/io/InputStream;", "getResources", "Ljava/util/Enumeration;", "log", "", "message", "normalizePath", "path", "prefix", "searchResource", "visitDir", "root", "dir", "out", "", "visitRoot", "url", "resources", "", "visitZip", "jar", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersion() {
            return version;
        }

        private final void log(String message) {
            System.err.println(this.prefix() + message);
        }

        private final String normalizePath(String path) throws IOException {
            String path2 = SLASH_PATTERN.matcher(path).replaceAll("/");
            String string = URLDecoder.decode(path2, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(path, \"UTF-8\")");
            return string;
        }

        @JvmOverloads
        @Nullable
        public final File get(@NotNull Class<?> clazz) {
            File file;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            ProtectionDomain pDomain = clazz.getProtectionDomain();
            CodeSource cSource = pDomain.getCodeSource();
            URL uRL = cSource.getLocation();
            if (uRL == null) {
                return null;
            }
            URL loc = uRL;
            try {
                String string = loc.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loc.file");
                file = new File(this.normalizePath(string)).getAbsoluteFile().getCanonicalFile();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to decode file path!", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get canonical file path!", e);
            }
            return file;
        }

        public static /* synthetic */ File get$default(Companion companion, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = LocationResolver.class;
            }
            return companion.get(clazz);
        }

        @Nullable
        public final URL getResource(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String resourceName2 = resourceName;
            try {
                resourceName2 = this.normalizePath(resourceName2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            URL resource = null;
            File file = new File(resourceName2);
            if (file.canRead()) {
                try {
                    resource = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (resource == null) {
                resource = Thread.currentThread().getContextClassLoader().getResource(resourceName2);
            }
            if (resource == null) {
                resource = ClassLoader.getSystemResource(resourceName2);
            }
            if (resource == null) {
                try {
                    this.searchResource(resourceName2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return resource;
        }

        @Nullable
        public final Enumeration<URL> getResources(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String resourceName2 = resourceName;
            try {
                resourceName2 = this.normalizePath(resourceName2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Enumeration<URL> resources = null;
            try {
                File file = new File(resourceName2);
                if (file.canRead()) {
                    File[] files;
                    ArrayDeque<URL> urlList = new ArrayDeque<URL>(4);
                    urlList.add(file.toURI().toURL());
                    if (file.isDirectory() && (files = file.listFiles()) != null) {
                        int n = files.length;
                        for (int i = 0; i < n; ++i) {
                            urlList.add(files[i].toURI().toURL());
                        }
                    }
                    resources = new Vector(urlList).elements();
                }
                if (resources == null) {
                    resources = Thread.currentThread().getContextClassLoader().getResources(resourceName2);
                }
                if (resources == null) {
                    resources = ClassLoader.getSystemResources(resourceName2);
                }
                if (resources == null) {
                    this.searchResource(resourceName2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return resources;
        }

        @Nullable
        public final InputStream getResourceAsStream(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String resourceName2 = resourceName;
            try {
                resourceName2 = this.normalizePath(resourceName2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputStream resourceAsStream = null;
            if (new File(resourceName2).canRead()) {
                try {
                    resourceAsStream = new FileInputStream(resourceName2);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (resourceAsStream == null) {
                resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName2);
            }
            if (resourceAsStream == null) {
                resourceAsStream = ClassLoader.getSystemResourceAsStream(resourceName2);
            }
            if (resourceAsStream == null) {
                try {
                    this.searchResource(resourceName2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return resourceAsStream;
        }

        public final void searchResource(@NotNull String path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String path2 = path;
            try {
                path2 = this.normalizePath(path2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List roots = new ArrayList();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof URLClassLoader) {
                URL[] urLs = ((URLClassLoader)contextClassLoader).getURLs();
                Intrinsics.checkNotNullExpressionValue((Object)urLs, (String)"urLs");
                for (URL url : urLs) {
                    Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                    roots.add(new Root(url));
                }
                System.err.println();
                this.log("SEARCHING: \"" + path2 + '\"');
                for (int attempt = 1; attempt < 7; ++attempt) {
                    for (Root root : roots) {
                        if (!root.search(path2, attempt)) continue;
                        return;
                    }
                }
                this.log("FAILED: failed to find anything like");
                this.log("               \"" + path2 + '\"');
                this.log("         in all classpath entries:");
                for (Root root : roots) {
                    File entry = root.getEntry();
                    if (entry == null) continue;
                    this.log("               \"" + entry.getAbsolutePath() + '\"');
                }
            } else {
                throw new IOException("Unable to search for '" + path2 + "' in the context classloader of type '" + contextClassLoader.getClass() + "'.  Please report this issue with as many specific details as possible (OS, Java version, application version");
            }
        }

        private final File visitRoot(URL url, List<String> resources) throws IOException {
            File root;
            if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String path = url.getPath();
            if (OS.INSTANCE.isWindows()) {
                String string = path;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                if (StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null)) {
                    String string2 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
                    String string3 = string2;
                    int n = 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    path = string4;
                }
            }
            if (!(root = new File(path)).exists()) {
                this.log("failed to find classpath entry in filesystem: " + path);
                return null;
            }
            if (root.isDirectory()) {
                String string = root.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.absolutePath");
                this.visitDir(this.normalizePath(string), root, (Collection<String>)resources);
            } else {
                String string = root.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.name");
                String string5 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string6 = string5.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase(locale)");
                String s = string6;
                if (StringsKt.endsWith$default((String)s, (String)".zip", (boolean)false, (int)2, null)) {
                    this.visitZip(root, (Collection<String>)resources);
                } else if (StringsKt.endsWith$default((String)s, (String)".jar", (boolean)false, (int)2, null)) {
                    this.visitZip(root, (Collection<String>)resources);
                } else {
                    this.log("unknown classpath entry type: " + path);
                    return null;
                }
            }
            return root;
        }

        private final void visitDir(String root, File dir, Collection<String> out) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        this.visitDir(root, file, out);
                    }
                    String string = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                    String string2 = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    int n = root.length() + 1;
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    out.add(string3);
                }
            }
        }

        private final void visitZip(File jar, Collection<String> out) throws IOException {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));
            while (zis.getNextEntry() != null) {
                ZipEntry entry;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                out.add(StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
            zis.close();
        }

        private final String prefix() {
            return '[' + LocationResolver.class.getSimpleName() + "] ";
        }

        @JvmOverloads
        @Nullable
        public final File get() {
            return dorkbox.util.LocationResolver$Companion.get$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Ldorkbox/util/LocationResolver$Root;", "", "entry", "Ljava/net/URL;", "(Ljava/net/URL;)V", "Ljava/io/File;", "getEntry", "()Ljava/io/File;", "resources", "", "", "getResources", "()Ljava/util/List;", "search", "", "path", "attempt", "", "Utilities"})
    private static final class Root {
        @Nullable
        private final File entry;
        @NotNull
        private final List<String> resources;

        public Root(@NotNull URL entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.resources = new ArrayList();
            this.entry = Companion.visitRoot(entry, this.resources);
        }

        @Nullable
        public final File getEntry() {
            return this.entry;
        }

        @NotNull
        public final List<String> getResources() {
            return this.resources;
        }

        public final boolean search(@NotNull String path, int attempt) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String path2 = path;
            try {
                path2 = Companion.normalizePath(path2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            switch (attempt) {
                case 1: {
                    for (String resource : this.resources) {
                        if (!Intrinsics.areEqual((Object)path2, (Object)resource)) continue;
                        Companion.log("SUCCESS: found resource \"" + path2 + "\" in root: " + this.entry);
                        return true;
                    }
                    break;
                }
                case 2: {
                    for (String resource : this.resources) {
                        String string = path2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        String string2 = string.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                        string = resource;
                        Locale locale2 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                        String string3 = string.toLowerCase(locale2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                        if (!Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                        Companion.log("FOUND: similarly named resource:");
                        Companion.log("               \"" + resource + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + resource + "\");");
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (String resource : this.resources) {
                        String r1 = path2;
                        String r2 = resource;
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string = r1.substring(StringsKt.lastIndexOf$default((CharSequence)r1, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            r1 = string;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string = r2.substring(StringsKt.lastIndexOf$default((CharSequence)r2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            r2 = string;
                        }
                        if (!Intrinsics.areEqual((Object)r1, (Object)r2)) continue;
                        Companion.log("FOUND: mislocated resource:");
                        Companion.log("               \"" + resource + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + resource + "\");");
                        return true;
                    }
                    break;
                }
                case 4: {
                    for (String resource : this.resources) {
                        String r1;
                        String r2 = path2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        Intrinsics.checkNotNullExpressionValue((Object)r2.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                        String string = resource;
                        Locale locale3 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault()");
                        String string4 = string.toLowerCase(locale3);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                        r2 = string4;
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string5 = r1.substring(StringsKt.lastIndexOf$default((CharSequence)r1, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                            r1 = string5;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string6 = r2.substring(StringsKt.lastIndexOf$default((CharSequence)r2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                            r2 = string6;
                        }
                        if (!Intrinsics.areEqual((Object)r1, (Object)r2)) continue;
                        Companion.log("FOUND: mislocated, similarly named resource:");
                        Companion.log("               \"" + resource + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + resource + "\");");
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (String resource : this.resources) {
                        String r1 = path2;
                        String r2 = resource;
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string = r1.substring(StringsKt.lastIndexOf$default((CharSequence)r1, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            r1 = string;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string = r2.substring(StringsKt.lastIndexOf$default((CharSequence)r2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            r2 = string;
                        }
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string = r1.substring(0, StringsKt.lastIndexOf$default((CharSequence)r1, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            r1 = string;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string = r2.substring(0, StringsKt.lastIndexOf$default((CharSequence)r2, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            r2 = string;
                        }
                        if (!Intrinsics.areEqual((Object)r1, (Object)r2)) continue;
                        Companion.log("FOUND: resource with different extension:");
                        Companion.log("               \"" + resource + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + resource + "\");");
                        return true;
                    }
                    break;
                }
                case 6: {
                    for (String resource : this.resources) {
                        String r1;
                        String r2 = path2;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        Intrinsics.checkNotNullExpressionValue((Object)r2.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
                        String string = resource;
                        Locale locale4 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault()");
                        String string7 = string.toLowerCase(locale4);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(locale)");
                        r2 = string7;
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string8 = r1.substring(StringsKt.lastIndexOf$default((CharSequence)r1, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).substring(startIndex)");
                            r1 = string8;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string9 = r2.substring(StringsKt.lastIndexOf$default((CharSequence)r2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).substring(startIndex)");
                            r2 = string9;
                        }
                        if (StringsKt.contains$default((CharSequence)r1, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string10 = r1.substring(0, StringsKt.lastIndexOf$default((CharSequence)r1, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            r1 = string10;
                        }
                        if (StringsKt.contains$default((CharSequence)r2, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string11 = r2.substring(0, StringsKt.lastIndexOf$default((CharSequence)r2, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            r2 = string11;
                        }
                        if (!Intrinsics.areEqual((Object)r1, (Object)r2)) continue;
                        Companion.log("FOUND: similarly named resource with different extension:");
                        Companion.log("               \"" + resource + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + resource + "\");");
                        return true;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return false;
        }
    }
}

