/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.properties;

import dorkbox.util.properties.SortedProperties;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J0\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003J\u001a\u0010\u0014\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldorkbox/util/properties/PropertiesProvider;", "", "propertiesFile", "", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "comments", "properties", "Ljava/util/Properties;", "_load", "", "_save", "get", "T", "key", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "remove", "save", "value", "setComments", "toString", "Utilities"})
public final class PropertiesProvider {
    @NotNull
    private final Properties properties;
    @NotNull
    private final File propertiesFile;
    @NotNull
    private String comments;

    public PropertiesProvider(@NotNull File propertiesFile) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        this.properties = new SortedProperties();
        this.comments = "Settings and configuration file. Strings must be escape formatted!";
        File propertiesFile2 = FilesKt.normalize((File)propertiesFile);
        File parentFile = propertiesFile2.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new RuntimeException("Unable to create directories for: " + propertiesFile2);
        }
        this.propertiesFile = propertiesFile2;
        this._load();
    }

    public PropertiesProvider(@NotNull String propertiesFile) {
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        this(new File(propertiesFile));
    }

    public final void setComments(@NotNull String comments) {
        Intrinsics.checkNotNullParameter((Object)comments, (String)"comments");
        this.comments = comments;
    }

    private final void _load() {
        if (!this.propertiesFile.canRead() || !this.propertiesFile.exists()) {
            this._save();
        }
        try {
            FileInputStream fis = new FileInputStream(this.propertiesFile);
            this.properties.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Properties cannot load!");
            e.printStackTrace();
        }
    }

    private final void _save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.propertiesFile);
            this.properties.store(fos, this.comments);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println("Properties cannot save!");
        }
        catch (IOException e) {
            System.err.println("Properties cannot save!");
            e.printStackTrace();
        }
    }

    public final synchronized void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.properties.remove(key);
        this._save();
    }

    public final synchronized void save(@Nullable String key, @Nullable Object value) {
        Object value2 = value;
        if (key == null || value2 == null) {
            return;
        }
        if (value2 instanceof Color) {
            value2 = ((Color)value2).getRGB();
        }
        this.properties.setProperty(key, value2.toString());
        this._save();
    }

    @Nullable
    public final synchronized <T> T get(@Nullable String key, @Nullable Class<T> clazz) {
        Object object;
        if (key == null || clazz == null) {
            return null;
        }
        String string = this.properties.getProperty(key);
        if (string == null) {
            return null;
        }
        String property = string;
        try {
            if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                return (T)((Object)Integer.parseInt(property));
            }
            if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                return (T)((Object)Long.parseLong(property));
            }
            object = Intrinsics.areEqual(clazz, Color.class) ? (Object)new Color(Integer.parseInt(property), true) : (Object)property;
        }
        catch (Exception e) {
            throw new RuntimeException("Properties Loader for property: " + key + System.getProperty("line.separator") + e.getMessage());
        }
        return (T)object;
    }

    @NotNull
    public String toString() {
        return "PropertiesProvider [" + this.propertiesFile + ']';
    }
}

