/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version;

import dorkbox.version.NullMetadataVersion;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0010\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u001dB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0011\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J)\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\tH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001e"}, d2={"Ldorkbox/version/MetadataVersion;", "", "Ljava/io/Serializable;", "identifiers", "", "", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "compareIdentifierArrays", "", "otherIdents", "([Ljava/lang/String;)I", "compareIdentifiers", "ident1", "ident2", "compareTo", "other", "equals", "", "", "getLeastCommonArrayLength", "arr1", "arr2", "([Ljava/lang/String;[Ljava/lang/String;)I", "hashCode", "increment", "isInt", "str", "toString", "Companion", "Version"})
public class MetadataVersion
implements Comparable<MetadataVersion>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] identifiers;
    private static final long serialVersionUID = -1722535646295099910L;
    @NotNull
    private static final MetadataVersion NULL = new NullMetadataVersion();

    public MetadataVersion(@NotNull String[] identifiers) {
        Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
        this.identifiers = identifiers;
    }

    private final int compareIdentifierArrays(String[] otherIdents) {
        int result = 0;
        int length = this.getLeastCommonArrayLength(this.identifiers, otherIdents);
        for (int i = 0; i < length && (result = this.compareIdentifiers(this.identifiers[i], otherIdents[i])) == 0; ++i) {
        }
        return result;
    }

    private final int compareIdentifiers(String ident1, String ident2) {
        return this.isInt(ident1) && this.isInt(ident2) ? Integer.parseInt(ident1) - Integer.parseInt(ident2) : ident1.compareTo(ident2);
    }

    @Override
    public int compareTo(@NotNull MetadataVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other == NULL) {
            return -1;
        }
        int result = this.compareIdentifierArrays(other.identifiers);
        if (result == 0) {
            result = this.identifiers.length - other.identifiers.length;
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return !(other instanceof MetadataVersion) ? false : this.compareTo((MetadataVersion)other) == 0;
    }

    private final int getLeastCommonArrayLength(String[] arr1, String[] arr2) {
        return arr1.length <= arr2.length ? arr1.length : arr2.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.identifiers);
    }

    @Nullable
    public MetadataVersion increment() {
        String[] ids = this.identifiers;
        String lastId = ids[ids.length - 1];
        if (this.isInt(lastId)) {
            int intId = Integer.parseInt(lastId) + 1;
            ids[ids.length - 1] = String.valueOf(intId);
        } else {
            String[] stringArray = Arrays.copyOf(ids, ids.length + 1);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(ids, ids.size + 1)");
            ids = stringArray;
            ids[ids.length - 1] = "1";
        }
        return new MetadataVersion(ids);
    }

    private final boolean isInt(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String ident : this.identifiers) {
            sb.append(ident).append(".");
        }
        String string = sb.deleteCharAt(sb.lastIndexOf(".")).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.deleteCharAt(sb.lastIndexOf(\".\")).toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ldorkbox/version/MetadataVersion$Companion;", "", "()V", "NULL", "Ldorkbox/version/MetadataVersion;", "getNULL", "()Ldorkbox/version/MetadataVersion;", "serialVersionUID", "", "Version"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetadataVersion getNULL() {
            return NULL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

