/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version;

import dorkbox.version.CharType;
import dorkbox.version.ParseException;
import dorkbox.version.util.Stream;
import dorkbox.version.util.UnexpectedElementException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\b\u0010\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Ldorkbox/version/UnexpectedCharacterException;", "Ldorkbox/version/ParseException;", "cause", "Ldorkbox/version/util/UnexpectedElementException;", "(Ldorkbox/version/util/UnexpectedElementException;)V", "unexpected", "", "position", "", "expected", "", "Ldorkbox/version/CharType;", "(Ljava/lang/Character;I[Ldorkbox/version/CharType;)V", "expectedCharTypes", "getExpectedCharTypes", "()[Ldorkbox/version/CharType;", "[Ldorkbox/version/CharType;", "getPosition", "()I", "unexpectedCharacter", "getUnexpectedCharacter", "()Ljava/lang/Character;", "Ljava/lang/Character;", "toString", "", "Version"})
public final class UnexpectedCharacterException
extends ParseException {
    @Nullable
    private final Character unexpectedCharacter;
    private final int position;
    @NotNull
    private final CharType[] expectedCharTypes;

    @Nullable
    public final Character getUnexpectedCharacter() {
        return this.unexpectedCharacter;
    }

    public final int getPosition() {
        return this.position;
    }

    @NotNull
    public final CharType[] getExpectedCharTypes() {
        return this.expectedCharTypes;
    }

    public UnexpectedCharacterException(@NotNull UnexpectedElementException cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.position = cause.getPosition();
        this.unexpectedCharacter = (Character)cause.getUnexpectedElement();
        Stream.ElementType<?>[] elementTypeArray = cause.getExpectedElementTypes();
        Intrinsics.checkNotNull(elementTypeArray, (String)"null cannot be cast to non-null type kotlin.Array<dorkbox.version.CharType>");
        this.expectedCharTypes = (CharType[])elementTypeArray;
    }

    public UnexpectedCharacterException(@Nullable Character unexpected, int position, CharType ... expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.unexpectedCharacter = unexpected;
        this.position = position;
        this.expectedCharTypes = expected;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "Unexpected character '%s(%s)' at position '%d'";
        Object[] objectArray = new Object[]{CharType.Companion.forCharacter(this.unexpectedCharacter), this.unexpectedCharacter, this.position};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String message = string2;
        if (!(this.expectedCharTypes.length == 0)) {
            StringBuilder stringBuilder = new StringBuilder().append(message);
            string = ", expecting '%s'";
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.toString(this.expectedCharTypes), (String)"toString(this)");
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            message = stringBuilder.append(string3).toString();
        }
        return message;
    }
}

