/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version;

import dorkbox.updates.Updates;
import dorkbox.version.MetadataVersion;
import dorkbox.version.NormalVersion;
import dorkbox.version.Parser;
import dorkbox.version.VersionParser;
import dorkbox.version.expr.Expression;
import dorkbox.version.expr.ExpressionParser;
import dorkbox.version.expr.LexerException;
import dorkbox.version.expr.UnexpectedTokenException;
import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0003;<=B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rB\u001f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0010B'\b\u0000\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0000J\u0013\u0010&\u001a\u00020'2\b\u0010$\u001a\u0004\u0018\u00010(H\u0096\u0002J\u000e\u0010)\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\b\u0010+\u001a\u00020\nH\u0016J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010/\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\u000e\u00102\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\u000e\u00103\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\u000e\u00104\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000J\u000e\u00105\u001a\u00020'2\u0006\u00106\u001a\u000207J\u0010\u00105\u001a\u00020'2\b\u00106\u001a\u0004\u0018\u00010\u0004J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\b\u0010:\u001a\u00020\u0004H\u0016R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019\u00a8\u0006>"}, d2={"Ldorkbox/version/Version;", "", "Ljava/io/Serializable;", "version", "", "(Ljava/lang/String;)V", "majorAndMinor", "", "(D)V", "major", "", "(I)V", "minor", "(II)V", "patch", "(III)V", "(Ldorkbox/version/Version;)V", "normal", "Ldorkbox/version/NormalVersion;", "preRelease", "Ldorkbox/version/MetadataVersion;", "build", "(Ldorkbox/version/NormalVersion;Ldorkbox/version/MetadataVersion;Ldorkbox/version/MetadataVersion;)V", "buildMetadata", "getBuildMetadata", "()Ljava/lang/String;", "", "getMajor", "()J", "getMinor", "normalVersion", "getNormalVersion", "getPatch", "preReleaseVersion", "getPreReleaseVersion", "compareTo", "other", "compareWithBuildsTo", "equals", "", "", "greaterThan", "greaterThanOrEqualTo", "hashCode", "incrementBuildMetadata", "incrementMajorVersion", "incrementMinorVersion", "incrementPatchVersion", "incrementPreReleaseVersion", "isMajorVersionCompatible", "isMinorVersionCompatible", "lessThan", "lessThanOrEqualTo", "satisfies", "expr", "Ldorkbox/version/expr/Expression;", "setBuildMetadata", "setPreReleaseVersion", "toString", "BuildAwareOrder", "Builder", "Companion", "Version"})
public final class Version
implements Comparable<Version>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NormalVersion normal;
    @Nullable
    private final MetadataVersion preRelease;
    @Nullable
    private final MetadataVersion build;
    private static final long serialVersionUID = -2008891377046871654L;
    @NotNull
    private static final Comparator<Version> BUILD_AWARE_ORDER = new BuildAwareOrder();
    @NotNull
    private static final String BUILD_PREFIX = "+";
    @NotNull
    private static final String PRE_RELEASE_PREFIX = "-";
    @NotNull
    public static final String version = "3.1";

    public Version(@NotNull NormalVersion normal, @Nullable MetadataVersion preRelease, @Nullable MetadataVersion build) {
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        this.normal = normal;
        this.preRelease = preRelease;
        this.build = build;
    }

    public /* synthetic */ Version(NormalVersion normalVersion, MetadataVersion metadataVersion, MetadataVersion metadataVersion2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            metadataVersion = MetadataVersion.Companion.getNULL();
        }
        if ((n & 4) != 0) {
            metadataVersion2 = MetadataVersion.Companion.getNULL();
        }
        this(normalVersion, metadataVersion, metadataVersion2);
    }

    public Version(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(VersionParser.Companion.parseValidSemVer(version));
    }

    public Version(double majorAndMinor) {
        this(VersionParser.Companion.parseValidSemVer(majorAndMinor));
    }

    public Version(int major) {
        this(new NormalVersion(major, 0L), null, null, 6, null);
    }

    public Version(int major, int minor) {
        this(new NormalVersion(major, minor), null, null, 6, null);
    }

    public Version(int major, int minor, int patch) {
        this(new NormalVersion(major, minor, patch), null, null, 6, null);
    }

    public Version(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(version.normal, version.preRelease, version.build);
    }

    public final long getMajor() {
        return this.normal.getMajor();
    }

    public final long getMinor() {
        return this.normal.getMinor();
    }

    public final long getPatch() {
        return this.normal.getPatch();
    }

    @NotNull
    public final String getNormalVersion() {
        return this.normal.toString();
    }

    @NotNull
    public final String getPreReleaseVersion() {
        return String.valueOf(this.preRelease);
    }

    @NotNull
    public final String getBuildMetadata() {
        return String.valueOf(this.build);
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int result = this.normal.compareTo(other.normal);
        if (result == 0) {
            MetadataVersion metadataVersion = this.preRelease;
            Intrinsics.checkNotNull((Object)metadataVersion);
            MetadataVersion metadataVersion2 = other.preRelease;
            Intrinsics.checkNotNull((Object)metadataVersion2);
            result = metadataVersion.compareTo(metadataVersion2);
        }
        return result;
    }

    public final int compareWithBuildsTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return BUILD_AWARE_ORDER.compare(this, other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return !(other instanceof Version) ? false : this.compareTo((Version)other) == 0;
    }

    @NotNull
    public final Version setBuildMetadata(@NotNull String build) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        return new Version(this.normal, this.preRelease, VersionParser.Companion.parseBuild(build));
    }

    @NotNull
    public final Version setPreReleaseVersion(@NotNull String preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        return new Version(this.normal, VersionParser.Companion.parsePreRelease(preRelease), null, 4, null);
    }

    public final boolean greaterThan(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0;
    }

    public final boolean greaterThanOrEqualTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.normal.hashCode();
        MetadataVersion metadataVersion = this.preRelease;
        hash = 97 * hash + (metadataVersion != null ? ((Object)metadataVersion).hashCode() : 0);
        return hash;
    }

    @NotNull
    public final Version incrementBuildMetadata() {
        MetadataVersion metadataVersion = this.build;
        Intrinsics.checkNotNull((Object)metadataVersion);
        return new Version(this.normal, this.preRelease, metadataVersion.increment());
    }

    @NotNull
    public final Version incrementMajorVersion() {
        return new Version(this.normal.incrementMajor(), null, null, 6, null);
    }

    @NotNull
    public final Version incrementMajorVersion(@NotNull String preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        return new Version(this.normal.incrementMajor(), VersionParser.Companion.parsePreRelease(preRelease), null, 4, null);
    }

    @NotNull
    public final Version incrementMinorVersion() {
        return new Version(this.normal.incrementMinor(), null, null, 6, null);
    }

    @NotNull
    public final Version incrementMinorVersion(@NotNull String preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        return new Version(this.normal.incrementMinor(), VersionParser.Companion.parsePreRelease(preRelease), null, 4, null);
    }

    @NotNull
    public final Version incrementPatchVersion() {
        return new Version(this.normal.incrementPatch(), null, null, 6, null);
    }

    @NotNull
    public final Version incrementPatchVersion(@NotNull String preRelease) {
        Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
        return new Version(this.normal.incrementPatch(), VersionParser.Companion.parsePreRelease(preRelease), null, 4, null);
    }

    @NotNull
    public final Version incrementPreReleaseVersion() {
        MetadataVersion metadataVersion = this.preRelease;
        Intrinsics.checkNotNull((Object)metadataVersion);
        return new Version(this.normal, metadataVersion.increment(), null, 4, null);
    }

    public final boolean isMajorVersionCompatible(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getMajor() == other.getMajor();
    }

    public final boolean isMinorVersionCompatible(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor();
    }

    public final boolean lessThan(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean lessThanOrEqualTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean satisfies(@Nullable String expr) throws LexerException, UnexpectedTokenException {
        Parser<Expression> parser = ExpressionParser.Companion.newInstance();
        String string = expr;
        Intrinsics.checkNotNull((Object)string);
        return this.satisfies(parser.parse(string));
    }

    public final boolean satisfies(@NotNull Expression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        return expr.interpret(this);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getNormalVersion());
        if (!(((CharSequence)this.getPreReleaseVersion()).length() == 0)) {
            sb.append(PRE_RELEASE_PREFIX).append(this.getPreReleaseVersion());
        }
        if (!(((CharSequence)this.getBuildMetadata()).length() == 0)) {
            sb.append(BUILD_PREFIX).append(this.getBuildMetadata());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        Updates.INSTANCE.add(Version.class, "ccdb2067336845faa33b04ac57892205", version);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldorkbox/version/Version$Companion;", "", "()V", "BUILD_AWARE_ORDER", "Ljava/util/Comparator;", "Ldorkbox/version/Version;", "Lkotlin/Comparator;", "getBUILD_AWARE_ORDER", "()Ljava/util/Comparator;", "BUILD_PREFIX", "", "PRE_RELEASE_PREFIX", "serialVersionUID", "", "version", "Version"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Version> getBUILD_AWARE_ORDER() {
            return BUILD_AWARE_ORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ldorkbox/version/Version$BuildAwareOrder;", "Ljava/util/Comparator;", "Ldorkbox/version/Version;", "Lkotlin/Comparator;", "()V", "compare", "", "v1", "v2", "Version"})
    private static final class BuildAwareOrder
    implements Comparator<Version> {
        @Override
        public int compare(@NotNull Version v1, @NotNull Version v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            int result = v1.compareTo(v2);
            if (result == 0) {
                MetadataVersion metadataVersion = v1.build;
                Intrinsics.checkNotNull((Object)metadataVersion);
                MetadataVersion metadataVersion2 = v2.build;
                Intrinsics.checkNotNull((Object)metadataVersion2);
                result = metadataVersion.compareTo(metadataVersion2);
                if (v1.build == MetadataVersion.Companion.getNULL() || v2.build == MetadataVersion.Companion.getNULL()) {
                    result = -1 * result;
                }
            }
            return result;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/version/Version$Builder;", "", "()V", "normal", "", "(Ljava/lang/String;)V", "metaData", "preRelease", "build", "Ldorkbox/version/Version;", "isFilled", "", "str", "setBuildMetadata", "setNormalVersion", "setPreReleaseVersion", "Version"})
    public static final class Builder {
        @Nullable
        private String normal;
        @Nullable
        private String preRelease;
        @Nullable
        private String metaData;

        public Builder() {
        }

        public Builder(@Nullable String normal) {
            this.normal = normal;
        }

        @NotNull
        public final Version build() {
            StringBuilder sb = new StringBuilder();
            if (this.isFilled(this.normal)) {
                sb.append(this.normal);
            }
            if (this.isFilled(this.preRelease)) {
                sb.append(Version.PRE_RELEASE_PREFIX).append(this.preRelease);
            }
            if (this.isFilled(this.metaData)) {
                sb.append(Version.BUILD_PREFIX).append(this.metaData);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return VersionParser.Companion.parseValidSemVer(string);
        }

        private final boolean isFilled(String str) {
            CharSequence charSequence = str;
            return !(charSequence == null || charSequence.length() == 0);
        }

        @NotNull
        public final Builder setBuildMetadata(@Nullable String metaData) {
            this.metaData = metaData;
            return this;
        }

        @NotNull
        public final Builder setNormalVersion(@Nullable String normal) {
            this.normal = normal;
            return this;
        }

        @NotNull
        public final Builder setPreReleaseVersion(@Nullable String preRelease) {
            this.preRelease = preRelease;
            return this;
        }
    }
}

