/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version;

import dorkbox.version.CharType;
import dorkbox.version.MetadataVersion;
import dorkbox.version.NormalVersion;
import dorkbox.version.ParseException;
import dorkbox.version.Parser;
import dorkbox.version.UnexpectedCharacterException;
import dorkbox.version.Version;
import dorkbox.version.util.Stream;
import dorkbox.version.util.UnexpectedElementException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J!\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0002J!\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0002H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldorkbox/version/VersionParser;", "Ldorkbox/version/Parser;", "Ldorkbox/version/Version;", "input", "", "(Ljava/lang/String;)V", "chars", "Ldorkbox/version/util/Stream;", "", "alphanumericIdentifier", "buildIdentifier", "checkForEmptyIdentifier", "", "checkForLeadingZeroes", "checkNextCharacter", "", "expected", "", "Ldorkbox/version/CharType;", "([Ldorkbox/version/CharType;)Z", "consumeNextCharacter", "([Ldorkbox/version/CharType;)Ljava/lang/Character;", "digits", "ensureValidLookahead", "([Ldorkbox/version/CharType;)V", "nearestCharType", "types", "([Ldorkbox/version/CharType;)Ldorkbox/version/CharType;", "numericIdentifier", "parse", "parseBuild", "Ldorkbox/version/MetadataVersion;", "parsePreRelease", "parseValidSemVer", "parseVersionCore", "Ldorkbox/version/NormalVersion;", "preReleaseIdentifier", "Companion", "Version"})
@SourceDebugExtension(value={"SMAP\nVersionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionParser.kt\ndorkbox/version/VersionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,500:1\n1#2:501\n970#3:502\n1041#3,3:503\n37#4,2:506\n37#4,2:508\n37#4,2:510\n*S KotlinDebug\n*F\n+ 1 VersionParser.kt\ndorkbox/version/VersionParser\n*L\n47#1:502\n47#1:503,3\n47#1:506,2\n259#1:508,2\n286#1:510,2\n*E\n"})
public final class VersionParser
implements Parser<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Stream<Character> chars;

    /*
     * WARNING - void declaration
     */
    public VersionParser(@NotNull String input) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(((CharSequence)input).length() > 0)) {
            boolean $i$a$-require-VersionParser$22 = false;
            String $i$a$-require-VersionParser$22 = "Input string is empty";
            throw new IllegalArgumentException($i$a$-require-VersionParser$22.toString());
        }
        CharSequence $this$map$iv = input;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Character[] elements = thisCollection$iv.toArray(new Character[0]);
        this.chars = new Stream<Character>(elements);
    }

    private final String alphanumericIdentifier() {
        CharType[] charTypeArray;
        StringBuilder sb = new StringBuilder();
        do {
            charTypeArray = new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN};
            sb.append(this.consumeNextCharacter(charTypeArray));
            charTypeArray = new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN};
        } while (this.chars.positiveLookahead(charTypeArray));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String buildIdentifier() {
        this.checkForEmptyIdentifier();
        CharType[] charTypeArray = new CharType[]{CharType.DOT, CharType.EOI};
        CharType boundary = this.nearestCharType(charTypeArray);
        charTypeArray = new CharType[]{CharType.LETTER, CharType.HYPHEN};
        return this.chars.positiveLookaheadBefore(boundary, charTypeArray) ? this.alphanumericIdentifier() : this.digits();
    }

    private final void checkForEmptyIdentifier() {
        Character la = this.chars.lookahead(1);
        if (CharType.DOT.isMatchedBy(la) || CharType.PLUS.isMatchedBy(la) || CharType.EOI.isMatchedBy(la)) {
            CharType[] charTypeArray = new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN};
            throw new ParseException("Identifiers MUST NOT be empty", new UnexpectedCharacterException(la, this.chars.currentOffset(), charTypeArray));
        }
    }

    private final void checkForLeadingZeroes() {
        Character la1 = this.chars.lookahead(1);
        Character la2 = this.chars.lookahead(2);
        if (la1 != null) {
            char c = '0';
            if (la1.charValue() == c && CharType.DIGIT.isMatchedBy(la2)) {
                throw new ParseException("Numeric identifier MUST NOT contain leading zeroes");
            }
        }
    }

    private final Character consumeNextCharacter(CharType ... expected) {
        Character c;
        try {
            c = (Character)this.chars.consume(Arrays.copyOf(expected, expected.length));
        }
        catch (UnexpectedElementException e) {
            throw new UnexpectedCharacterException(e);
        }
        return c;
    }

    private final boolean checkNextCharacter(CharType ... expected) {
        return this.chars.contains(Arrays.copyOf(expected, expected.length));
    }

    private final String digits() {
        CharType[] charTypeArray;
        StringBuilder sb = new StringBuilder();
        do {
            charTypeArray = new CharType[]{CharType.DIGIT};
            sb.append(this.consumeNextCharacter(charTypeArray));
            charTypeArray = new CharType[]{CharType.DIGIT};
        } while (this.chars.positiveLookahead(charTypeArray));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final void ensureValidLookahead(CharType ... expected) {
        if (!this.chars.positiveLookahead(Arrays.copyOf(expected, expected.length))) {
            throw new UnexpectedCharacterException(this.chars.lookahead(1), this.chars.currentOffset(), Arrays.copyOf(expected, expected.length));
        }
    }

    private final CharType nearestCharType(CharType ... types) {
        for (char chr : this.chars) {
            for (CharType type : types) {
                if (!type.isMatchedBy(Character.valueOf(chr))) continue;
                return type;
            }
        }
        return CharType.EOI;
    }

    private final String numericIdentifier() {
        this.checkForLeadingZeroes();
        return this.digits();
    }

    @Override
    @NotNull
    public Version parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.parseValidSemVer();
    }

    private final MetadataVersion parseBuild() {
        CharType[] charTypeArray = new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN};
        this.ensureValidLookahead(charTypeArray);
        List idents = new ArrayList();
        while (true) {
            idents.add(this.buildIdentifier());
            CharType[] charTypeArray2 = new CharType[]{CharType.DOT};
            if (!this.chars.positiveLookahead(charTypeArray2)) break;
            charTypeArray2 = new CharType[]{CharType.DOT};
            this.consumeNextCharacter(charTypeArray2);
        }
        Collection $this$toTypedArray$iv = idents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new MetadataVersion(thisCollection$iv.toArray(new String[0]));
    }

    private final MetadataVersion parsePreRelease() {
        CharType[] charTypeArray = new CharType[]{CharType.DIGIT, CharType.LETTER, CharType.HYPHEN, CharType.UNDER_SCORE};
        this.ensureValidLookahead(charTypeArray);
        List idents = new ArrayList();
        while (true) {
            idents.add(this.preReleaseIdentifier());
            CharType[] charTypeArray2 = new CharType[]{CharType.DOT};
            if (!this.chars.positiveLookahead(charTypeArray2)) break;
            charTypeArray2 = new CharType[]{CharType.DOT};
            this.consumeNextCharacter(charTypeArray2);
        }
        Collection $this$toTypedArray$iv = idents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new MetadataVersion(thisCollection$iv.toArray(new String[0]));
    }

    private final Version parseValidSemVer() {
        CharType[] charTypeArray;
        Character next;
        CharType[] charTypeArray2;
        NormalVersion normal = this.parseVersionCore();
        MetadataVersion preRelease = MetadataVersion.Companion.getNULL();
        MetadataVersion build = MetadataVersion.Companion.getNULL();
        if (!normal.getMinorSpecified() || !normal.getPatchSpecified()) {
            charTypeArray2 = new CharType[]{CharType.LETTER, CharType.DIGIT};
            if (this.checkNextCharacter(charTypeArray2)) {
                build = this.parseBuild();
            }
            if (!this.checkNextCharacter(charTypeArray2 = new CharType[]{CharType.HYPHEN, CharType.PLUS, CharType.UNDER_SCORE, CharType.EOI})) {
                if (!normal.getMinorSpecified() && this.checkNextCharacter(charTypeArray2 = new CharType[]{CharType.SPACE})) {
                    charTypeArray2 = new CharType[]{CharType.DOT};
                    this.consumeNextCharacter(charTypeArray2);
                }
                charTypeArray2 = new CharType[]{CharType.DIGIT};
                this.consumeNextCharacter(charTypeArray2);
            }
        }
        if (this.checkNextCharacter(charTypeArray2 = new CharType[]{CharType.DOT})) {
            charTypeArray2 = new CharType[]{CharType.DOT};
            this.consumeNextCharacter(charTypeArray2);
            build = this.parseBuild();
        }
        if (this.checkNextCharacter(charTypeArray2 = new CharType[]{CharType.SPACE})) {
            charTypeArray2 = new CharType[]{CharType.DIGIT};
            this.consumeNextCharacter(charTypeArray2);
        }
        if (CharType.HYPHEN.isMatchedBy(next = this.consumeNextCharacter(charTypeArray = new CharType[]{CharType.HYPHEN, CharType.PLUS, CharType.UNDER_SCORE, CharType.EOI}))) {
            preRelease = this.parsePreRelease();
            charTypeArray = new CharType[]{CharType.PLUS, CharType.EOI};
            next = this.consumeNextCharacter(charTypeArray);
        }
        if (CharType.UNDER_SCORE.isMatchedBy(next)) {
            preRelease = this.parsePreRelease();
            charTypeArray = new CharType[]{CharType.PLUS, CharType.EOI};
            next = this.consumeNextCharacter(charTypeArray);
        }
        if (CharType.PLUS.isMatchedBy(next)) {
            build = this.parseBuild();
        }
        charTypeArray = new CharType[]{CharType.EOI};
        this.consumeNextCharacter(charTypeArray);
        return new Version(normal, preRelease, build);
    }

    private final NormalVersion parseVersionCore() {
        long major = Long.parseLong(this.numericIdentifier());
        CharType[] charTypeArray = new CharType[]{CharType.DOT};
        if (!this.checkNextCharacter(charTypeArray)) {
            return new NormalVersion(major);
        }
        charTypeArray = new CharType[]{CharType.DOT};
        this.consumeNextCharacter(charTypeArray);
        long minor = Long.parseLong(this.numericIdentifier());
        CharType[] charTypeArray2 = new CharType[]{CharType.DOT};
        if (this.checkNextCharacter(charTypeArray2)) {
            charTypeArray2 = new CharType[]{CharType.DOT};
            this.consumeNextCharacter(charTypeArray2);
            charTypeArray2 = new CharType[]{CharType.DIGIT};
            if (this.checkNextCharacter(charTypeArray2)) {
                long patch = Long.parseLong(this.numericIdentifier());
                return new NormalVersion(major, minor, patch);
            }
            charTypeArray2 = new CharType[]{CharType.EOI};
            if (this.checkNextCharacter(charTypeArray2)) {
                throw new ParseException("Unexpected end of information");
            }
        }
        return new NormalVersion(major, minor);
    }

    private final String preReleaseIdentifier() {
        this.checkForEmptyIdentifier();
        CharType[] charTypeArray = new CharType[]{CharType.DOT, CharType.PLUS, CharType.EOI};
        CharType boundary = this.nearestCharType(charTypeArray);
        charTypeArray = new CharType[]{CharType.LETTER, CharType.HYPHEN};
        return this.chars.positiveLookaheadBefore(boundary, charTypeArray) ? this.alphanumericIdentifier() : this.numericIdentifier();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Ldorkbox/version/VersionParser$Companion;", "", "()V", "parseBuild", "Ldorkbox/version/MetadataVersion;", "build", "", "parsePreRelease", "preRelease", "parseValidSemVer", "Ldorkbox/version/Version;", "majorAndMinor", "", "version", "parseVersionCore", "Ldorkbox/version/NormalVersion;", "versionCore", "Version"})
    @SourceDebugExtension(value={"SMAP\nVersionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionParser.kt\ndorkbox/version/VersionParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,500:1\n1#2:501\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version parseValidSemVer(double majorAndMinor) {
            if (!(majorAndMinor >= 0.0)) {
                boolean bl = false;
                String string = "Major.minor number MUST be non-negative!";
                throw new IllegalArgumentException(string.toString());
            }
            String string = Double.toString(majorAndMinor);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(majorAndMinor)");
            VersionParser parser = new VersionParser(string);
            return parser.parseValidSemVer();
        }

        @NotNull
        public final Version parseValidSemVer(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            VersionParser parser = new VersionParser(version);
            return parser.parseValidSemVer();
        }

        @NotNull
        public final NormalVersion parseVersionCore(@NotNull String versionCore) {
            Intrinsics.checkNotNullParameter((Object)versionCore, (String)"versionCore");
            VersionParser parser = new VersionParser(versionCore);
            return parser.parseVersionCore();
        }

        @NotNull
        public final MetadataVersion parsePreRelease(@NotNull String preRelease) {
            Intrinsics.checkNotNullParameter((Object)preRelease, (String)"preRelease");
            VersionParser parser = new VersionParser(preRelease);
            return parser.parsePreRelease();
        }

        @NotNull
        public final MetadataVersion parseBuild(@NotNull String build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            VersionParser parser = new VersionParser(build);
            return parser.parseBuild();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

