/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version.expr;

import dorkbox.version.Version;
import dorkbox.version.expr.And;
import dorkbox.version.expr.Equal;
import dorkbox.version.expr.Expression;
import dorkbox.version.expr.Greater;
import dorkbox.version.expr.GreaterOrEqual;
import dorkbox.version.expr.Less;
import dorkbox.version.expr.LessOrEqual;
import dorkbox.version.expr.Not;
import dorkbox.version.expr.NotEqual;
import dorkbox.version.expr.Or;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldorkbox/version/expr/CompositeExpression;", "Ldorkbox/version/expr/Expression;", "exprTree", "(Ldorkbox/version/expr/Expression;)V", "and", "expr", "interpret", "", "version", "Ldorkbox/version/Version;", "", "or", "Helper", "Version"})
public final class CompositeExpression
implements Expression {
    @NotNull
    private Expression exprTree;

    public CompositeExpression(@NotNull Expression exprTree) {
        Intrinsics.checkNotNullParameter((Object)exprTree, (String)"exprTree");
        this.exprTree = exprTree;
    }

    @NotNull
    public final CompositeExpression and(@NotNull Expression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.exprTree = new And(this.exprTree, expr);
        return this;
    }

    public final boolean interpret(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.interpret(new Version(version));
    }

    @Override
    public boolean interpret(@Nullable Version version) {
        return this.exprTree.interpret(version);
    }

    @NotNull
    public final CompositeExpression or(@NotNull Expression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.exprTree = new Or(this.exprTree, expr);
        return this;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Ldorkbox/version/expr/CompositeExpression$Helper;", "", "()V", "eq", "Ldorkbox/version/expr/CompositeExpression;", "version", "Ldorkbox/version/Version;", "", "gt", "gte", "lt", "lte", "neq", "not", "expr", "Ldorkbox/version/expr/Expression;", "Version"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        @NotNull
        public final CompositeExpression not(@NotNull Expression expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            return new CompositeExpression(new Not(expr));
        }

        @NotNull
        public final CompositeExpression eq(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new Equal(version));
        }

        @NotNull
        public final CompositeExpression eq(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.eq(new Version(version));
        }

        @NotNull
        public final CompositeExpression neq(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new NotEqual(version));
        }

        @NotNull
        public final CompositeExpression neq(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.neq(new Version(version));
        }

        @NotNull
        public final CompositeExpression gt(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new Greater(version));
        }

        @NotNull
        public final CompositeExpression gt(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.gt(new Version(version));
        }

        @NotNull
        public final CompositeExpression gte(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new GreaterOrEqual(version));
        }

        @NotNull
        public final CompositeExpression gte(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.gte(new Version(version));
        }

        @NotNull
        public final CompositeExpression lt(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new Less(version));
        }

        @NotNull
        public final CompositeExpression lt(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.lt(new Version(version));
        }

        @NotNull
        public final CompositeExpression lte(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new CompositeExpression(new LessOrEqual(version));
        }

        @NotNull
        public final CompositeExpression lte(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return this.lte(new Version(version));
        }
    }
}

