/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version.expr;

import dorkbox.version.Parser;
import dorkbox.version.Version;
import dorkbox.version.expr.CompositeExpression;
import dorkbox.version.expr.Expression;
import dorkbox.version.expr.Lexer;
import dorkbox.version.expr.UnexpectedTokenException;
import dorkbox.version.util.Stream;
import dorkbox.version.util.UnexpectedElementException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001dH\u0002J$\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00142\b\b\u0002\u0010+\u001a\u00020\u00142\b\b\u0002\u0010,\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldorkbox/version/expr/ExpressionParser;", "Ldorkbox/version/Parser;", "Ldorkbox/version/expr/Expression;", "lexer", "Ldorkbox/version/expr/Lexer;", "(Ldorkbox/version/expr/Lexer;)V", "isHyphenRange", "", "()Z", "isPartialVersionRange", "isWildcardRange", "tokens", "Ldorkbox/version/util/Stream;", "Ldorkbox/version/expr/Lexer$Token;", "consumeNextToken", "expected", "", "Ldorkbox/version/expr/Lexer$Token$Type;", "([Ldorkbox/version/expr/Lexer$Token$Type;)Ldorkbox/version/expr/Lexer$Token;", "intOf", "", "value", "", "isVersionFollowedBy", "type", "Ldorkbox/version/util/Stream$ElementType;", "parse", "input", "parseCaretRange", "Ldorkbox/version/expr/CompositeExpression;", "parseComparisonRange", "parseHyphenRange", "parseMoreExpressions", "expr", "parsePartialVersionRange", "parseRange", "parseSemVerExpression", "parseTildeRange", "parseVersion", "Ldorkbox/version/Version;", "parseWildcardRange", "versionFor", "major", "minor", "patch", "Companion", "Version"})
@SourceDebugExtension(value={"SMAP\nExpressionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionParser.kt\ndorkbox/version/expr/ExpressionParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,462:1\n37#2,2:463\n*S KotlinDebug\n*F\n+ 1 ExpressionParser.kt\ndorkbox/version/expr/ExpressionParser\n*L\n108#1:463,2\n*E\n"})
public final class ExpressionParser
implements Parser<Expression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lexer lexer;
    private Stream<Lexer.Token> tokens;

    public ExpressionParser(@NotNull Lexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.lexer = lexer;
    }

    @Override
    @NotNull
    public Expression parse(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.tokens = this.lexer.tokenize(input);
        Expression expr = this.parseSemVerExpression();
        Lexer.Token.Type[] typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.EOI};
        this.consumeNextToken(typeArray);
        return expr;
    }

    private final Lexer.Token consumeNextToken(Lexer.Token.Type ... expected) {
        Lexer.Token token;
        try {
            Stream<Lexer.Token> stream = this.tokens;
            if (stream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream = null;
            }
            token = (Lexer.Token)stream.consume(Arrays.copyOf(expected, expected.length));
        }
        catch (UnexpectedElementException e) {
            throw new UnexpectedTokenException(e);
        }
        return token;
    }

    private final int intOf(String value) {
        return Integer.parseInt(value);
    }

    private final boolean isHyphenRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.HYPHEN);
    }

    private final boolean isPartialVersionRange() {
        Lexer.Token.Type[] typeArray;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (!stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC})) {
            return false;
        }
        EnumSet<Enum> expected = EnumSet.complementOf(EnumSet.of((Enum)Lexer.Token.Type.NUMERIC, (Enum)Lexer.Token.Type.DOT));
        Stream<Lexer.Token> stream2 = this.tokens;
        if (stream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream2 = null;
        }
        Intrinsics.checkNotNullExpressionValue(expected, (String)"expected");
        Collection $this$toTypedArray$iv = expected;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Lexer.Token.Type[] typeArray2 = thisCollection$iv.toArray(new Lexer.Token.Type[0]);
        return stream2.positiveLookaheadUntil(5, Arrays.copyOf(typeArray2, typeArray2.length));
    }

    private final boolean isVersionFollowedBy(Stream.ElementType<Lexer.Token> type) {
        EnumSet<Enum> expected = EnumSet.of((Enum)Lexer.Token.Type.NUMERIC, (Enum)Lexer.Token.Type.DOT);
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        Iterator<Lexer.Token> it = stream.iterator();
        Lexer.Token lookahead = null;
        while (it.hasNext() && expected.contains((lookahead = it.next()).getType())) {
        }
        return type.isMatchedBy(lookahead);
    }

    private final boolean isWildcardRange() {
        return this.isVersionFollowedBy(Lexer.Token.Type.WILDCARD);
    }

    private final CompositeExpression parseCaretRange() {
        Lexer.Token.Type[] lower;
        Lexer.Token.Type[] typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.CARET};
        this.consumeNextToken(typeArray);
        Lexer.Token.Type[] typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token = this.consumeNextToken(typeArray2);
        Intrinsics.checkNotNull((Object)token);
        int major = this.intOf(token.getLexeme());
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (!stream.positiveLookahead(typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, 0, 0, 6, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major + 1, 0, 0, 6, null)));
        }
        typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray2);
        Lexer.Token.Type[] typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token2 = this.consumeNextToken(typeArray3);
        Intrinsics.checkNotNull((Object)token2);
        int minor = this.intOf(token2.getLexeme());
        Stream<Lexer.Token> stream2 = this.tokens;
        if (stream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream2 = null;
        }
        if (!stream2.positiveLookahead(typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            lower = ExpressionParser.versionFor$default(this, major, minor, 0, 4, null);
            Version upper = major > 0 ? lower.incrementMajorVersion() : lower.incrementMinorVersion();
            return CompositeExpression.Helper.INSTANCE.gte((Version)lower).and(CompositeExpression.Helper.INSTANCE.lt(upper));
        }
        lower = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(lower);
        Lexer.Token.Type[] upper = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token3 = this.consumeNextToken(upper);
        Intrinsics.checkNotNull((Object)token3);
        int patch = this.intOf(token3.getLexeme());
        Version version = this.versionFor(major, minor, patch);
        CompositeExpression gte = CompositeExpression.Helper.INSTANCE.gte(version);
        return major > 0 ? gte.and(CompositeExpression.Helper.INSTANCE.lt(version.incrementMajorVersion())) : (minor > 0 ? gte.and(CompositeExpression.Helper.INSTANCE.lt(version.incrementMinorVersion())) : (patch > 0 ? gte.and(CompositeExpression.Helper.INSTANCE.lt(version.incrementPatchVersion())) : CompositeExpression.Helper.INSTANCE.eq(version)));
    }

    private final CompositeExpression parseComparisonRange() {
        CompositeExpression compositeExpression;
        Lexer.Token token;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        Lexer.Token token2 = token = (Lexer.Token)Stream.lookahead$default(stream, 0, 1, null);
        Lexer.Token.Type type = token2 != null ? token2.getType() : null;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Stream<Lexer.Token> stream2 = this.tokens;
                if (stream2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream2 = null;
                }
                stream2.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.eq(this.parseVersion());
                break;
            }
            case 2: {
                Stream<Lexer.Token> stream3 = this.tokens;
                if (stream3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream3 = null;
                }
                stream3.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.neq(this.parseVersion());
                break;
            }
            case 3: {
                Stream<Lexer.Token> stream4 = this.tokens;
                if (stream4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream4 = null;
                }
                stream4.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.gt(this.parseVersion());
                break;
            }
            case 4: {
                Stream<Lexer.Token> stream5 = this.tokens;
                if (stream5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream5 = null;
                }
                stream5.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.gte(this.parseVersion());
                break;
            }
            case 5: {
                Stream<Lexer.Token> stream6 = this.tokens;
                if (stream6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream6 = null;
                }
                stream6.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.lt(this.parseVersion());
                break;
            }
            case 6: {
                Stream<Lexer.Token> stream7 = this.tokens;
                if (stream7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream7 = null;
                }
                stream7.consume();
                compositeExpression = CompositeExpression.Helper.INSTANCE.lte(this.parseVersion());
                break;
            }
            default: {
                compositeExpression = CompositeExpression.Helper.INSTANCE.eq(this.parseVersion());
            }
        }
        CompositeExpression expr = compositeExpression;
        return expr;
    }

    private final CompositeExpression parseHyphenRange() {
        CompositeExpression gte = CompositeExpression.Helper.INSTANCE.gte(this.parseVersion());
        Lexer.Token.Type[] typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.HYPHEN};
        this.consumeNextToken(typeArray);
        return gte.and(CompositeExpression.Helper.INSTANCE.lte(this.parseVersion()));
    }

    private final CompositeExpression parseMoreExpressions(CompositeExpression expr) {
        Lexer.Token.Type[] typeArray;
        CompositeExpression expr2 = expr;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.AND})) {
            Stream<Lexer.Token> stream2 = this.tokens;
            if (stream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream2 = null;
            }
            stream2.consume();
            expr2 = expr2.and(this.parseSemVerExpression());
        } else {
            Stream<Lexer.Token> stream3 = this.tokens;
            if (stream3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream3 = null;
            }
            if (stream3.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.OR})) {
                Stream<Lexer.Token> stream4 = this.tokens;
                if (stream4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                    stream4 = null;
                }
                stream4.consume();
                expr2 = expr2.or(this.parseSemVerExpression());
            }
        }
        return expr2;
    }

    private final CompositeExpression parsePartialVersionRange() {
        Lexer.Token.Type[] typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token = this.consumeNextToken(typeArray);
        Intrinsics.checkNotNull((Object)token);
        int major = this.intOf(token.getLexeme());
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (!stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, 0, 0, 6, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major + 1, 0, 0, 6, null)));
        }
        typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray);
        Lexer.Token.Type[] typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token2 = this.consumeNextToken(typeArray2);
        Intrinsics.checkNotNull((Object)token2);
        int minor = this.intOf(token2.getLexeme());
        return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, minor, 0, 4, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major, minor + 1, 0, 4, null)));
    }

    private final CompositeExpression parseRange() {
        CompositeExpression compositeExpression;
        Lexer.Token.Type[] typeArray;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.TILDE})) {
            compositeExpression = this.parseTildeRange();
        } else {
            Stream<Lexer.Token> stream2 = this.tokens;
            if (stream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream2 = null;
            }
            compositeExpression = stream2.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.CARET}) ? this.parseCaretRange() : (this.isWildcardRange() ? this.parseWildcardRange() : (this.isHyphenRange() ? this.parseHyphenRange() : (this.isPartialVersionRange() ? this.parsePartialVersionRange() : this.parseComparisonRange())));
        }
        return compositeExpression;
    }

    private final CompositeExpression parseSemVerExpression() {
        Lexer.Token.Type[] typeArray;
        CompositeExpression expr = null;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.NOT})) {
            Stream<Lexer.Token> stream2 = this.tokens;
            if (stream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream2 = null;
            }
            stream2.consume();
            typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_PAREN};
            this.consumeNextToken(typeArray);
            expr = CompositeExpression.Helper.INSTANCE.not(this.parseSemVerExpression());
            typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_PAREN};
            this.consumeNextToken(typeArray);
        } else {
            Stream<Lexer.Token> stream3 = this.tokens;
            if (stream3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream3 = null;
            }
            if (stream3.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_PAREN})) {
                typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_PAREN};
                this.consumeNextToken(typeArray);
                expr = this.parseSemVerExpression();
                typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_PAREN};
                this.consumeNextToken(typeArray);
            } else {
                expr = this.parseRange();
            }
        }
        return this.parseMoreExpressions(expr);
    }

    private final CompositeExpression parseTildeRange() {
        Lexer.Token.Type[] typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.TILDE};
        this.consumeNextToken(typeArray);
        Lexer.Token.Type[] typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token = this.consumeNextToken(typeArray2);
        Intrinsics.checkNotNull((Object)token);
        int major = this.intOf(token.getLexeme());
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (!stream.positiveLookahead(typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, 0, 0, 6, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major + 1, 0, 0, 6, null)));
        }
        typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray2);
        Lexer.Token.Type[] typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token2 = this.consumeNextToken(typeArray3);
        Intrinsics.checkNotNull((Object)token2);
        int minor = this.intOf(token2.getLexeme());
        Stream<Lexer.Token> stream2 = this.tokens;
        if (stream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream2 = null;
        }
        if (!stream2.positiveLookahead(typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, minor, 0, 4, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major, minor + 1, 0, 4, null)));
        }
        typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray3);
        Lexer.Token.Type[] typeArray4 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token3 = this.consumeNextToken(typeArray4);
        Intrinsics.checkNotNull((Object)token3);
        int patch = this.intOf(token3.getLexeme());
        return CompositeExpression.Helper.INSTANCE.gte(this.versionFor(major, minor, patch)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major, minor + 1, 0, 4, null)));
    }

    private final Version parseVersion() {
        Lexer.Token.Type[] typeArray;
        Lexer.Token.Type[] typeArray2;
        Lexer.Token.Type[] typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token = this.consumeNextToken(typeArray3);
        Intrinsics.checkNotNull((Object)token);
        int major = this.intOf(token.getLexeme());
        int minor = 0;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (stream.positiveLookahead(typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Stream<Lexer.Token> stream2 = this.tokens;
            if (stream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream2 = null;
            }
            stream2.consume();
            typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
            Lexer.Token token2 = this.consumeNextToken(typeArray2);
            Intrinsics.checkNotNull((Object)token2);
            minor = this.intOf(token2.getLexeme());
        }
        int patch = 0;
        Stream<Lexer.Token> stream3 = this.tokens;
        if (stream3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream3 = null;
        }
        if (stream3.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.DOT})) {
            Stream<Lexer.Token> stream4 = this.tokens;
            if (stream4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream4 = null;
            }
            stream4.consume();
            typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
            Lexer.Token token3 = this.consumeNextToken(typeArray);
            Intrinsics.checkNotNull((Object)token3);
            patch = this.intOf(token3.getLexeme());
        }
        return this.versionFor(major, minor, patch);
    }

    private final CompositeExpression parseWildcardRange() {
        Lexer.Token.Type[] typeArray;
        Stream<Lexer.Token> stream = this.tokens;
        if (stream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream = null;
        }
        if (stream.positiveLookahead(typeArray = new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            Stream<Lexer.Token> stream2 = this.tokens;
            if (stream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream2 = null;
            }
            stream2.consume();
            return CompositeExpression.Helper.INSTANCE.gte(this.versionFor(0, 0, 0));
        }
        Lexer.Token.Type[] typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token = this.consumeNextToken(typeArray2);
        Intrinsics.checkNotNull((Object)token);
        int major = this.intOf(token.getLexeme());
        typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray2);
        Stream<Lexer.Token> stream3 = this.tokens;
        if (stream3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
            stream3 = null;
        }
        if (stream3.positiveLookahead(typeArray2 = new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD})) {
            Stream<Lexer.Token> stream4 = this.tokens;
            if (stream4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tokens");
                stream4 = null;
            }
            stream4.consume();
            return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, 0, 0, 6, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major + 1, 0, 0, 6, null)));
        }
        Lexer.Token.Type[] typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.NUMERIC};
        Lexer.Token token2 = this.consumeNextToken(typeArray3);
        Intrinsics.checkNotNull((Object)token2);
        int minor = this.intOf(token2.getLexeme());
        typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.DOT};
        this.consumeNextToken(typeArray3);
        typeArray3 = new Lexer.Token.Type[]{Lexer.Token.Type.WILDCARD};
        this.consumeNextToken(typeArray3);
        return CompositeExpression.Helper.INSTANCE.gte(ExpressionParser.versionFor$default(this, major, minor, 0, 4, null)).and(CompositeExpression.Helper.INSTANCE.lt(ExpressionParser.versionFor$default(this, major, minor + 1, 0, 4, null)));
    }

    private final Version versionFor(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    static /* synthetic */ Version versionFor$default(ExpressionParser expressionParser, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return expressionParser.versionFor(n, n2, n3);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Lexer.Token.Type.values().length];
            try {
                nArray[Lexer.Token.Type.EQUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.Token.Type.NOT_EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.Token.Type.GREATER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.Token.Type.GREATER_EQUAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.Token.Type.LESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.Token.Type.LESS_EQUAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Ldorkbox/version/expr/ExpressionParser$Companion;", "", "()V", "newInstance", "Ldorkbox/version/Parser;", "Ldorkbox/version/expr/Expression;", "Version"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Parser<Expression> newInstance() {
            return new ExpressionParser(new Lexer());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

