/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.version.expr;

import dorkbox.version.expr.LexerException;
import dorkbox.version.util.Stream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Ldorkbox/version/expr/Lexer;", "", "()V", "tokenize", "Ldorkbox/version/util/Stream;", "Ldorkbox/version/expr/Lexer$Token;", "input", "", "Token", "Version"})
@SourceDebugExtension(value={"SMAP\nLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lexer.kt\ndorkbox/version/expr/Lexer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n37#2,2:181\n*S KotlinDebug\n*F\n+ 1 Lexer.kt\ndorkbox/version/expr/Lexer\n*L\n177#1:181,2\n*E\n"})
public final class Lexer {
    @NotNull
    public final Stream<Token> tokenize(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String input2 = input;
        List tokens = new ArrayList();
        int tokenPos = 0;
        while (((CharSequence)input2).length() > 0) {
            boolean matched = false;
            for (Token.Type tokenType : Token.Type.values()) {
                Matcher matcher = tokenType.getPattern().matcher(input2);
                if (!matcher.find()) continue;
                matched = true;
                Intrinsics.checkNotNullExpressionValue((Object)matcher.replaceFirst(""), (String)"matcher.replaceFirst(\"\")");
                if (tokenType != Token.Type.WHITESPACE) {
                    String string = matcher.group();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
                    tokens.add(new Token(tokenType, string, tokenPos));
                }
                tokenPos += matcher.end();
                break;
            }
            if (matched) continue;
            throw new LexerException(input2);
        }
        tokens.add(new Token(Token.Type.EOI, "", tokenPos));
        Collection $this$toTypedArray$iv = tokens;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new Stream<Token>(thisCollection$iv.toArray(new Token[0]));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Ldorkbox/version/expr/Lexer$Token;", "", "type", "Ldorkbox/version/expr/Lexer$Token$Type;", "lexeme", "", "position", "", "(Ldorkbox/version/expr/Lexer$Token$Type;Ljava/lang/String;I)V", "getLexeme", "()Ljava/lang/String;", "getPosition", "()I", "getType", "()Ldorkbox/version/expr/Lexer$Token$Type;", "equals", "", "other", "hashCode", "toString", "Type", "Version"})
    public static final class Token {
        @NotNull
        private final Type type;
        @NotNull
        private final String lexeme;
        private final int position;

        public Token(@NotNull Type type, @NotNull String lexeme, int position) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)lexeme, (String)"lexeme");
            this.type = type;
            this.lexeme = lexeme;
            this.position = position;
        }

        public /* synthetic */ Token(Type type, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = "";
            }
            this(type, string, n);
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final String getLexeme() {
            return this.lexeme;
        }

        public final int getPosition() {
            return this.position;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            return this.type == ((Token)other).type && Intrinsics.areEqual((Object)this.lexeme, (Object)((Token)other).lexeme) && this.position == ((Token)other).position;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + this.type.hashCode();
            hash = 71 * hash + this.lexeme.hashCode();
            hash = 71 * hash + this.position;
            return hash;
        }

        @NotNull
        public String toString() {
            String string = "%s(%s) at position %d";
            Object[] objectArray = new Object[]{this.type.name(), this.lexeme, this.position};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006\""}, d2={"Ldorkbox/version/expr/Lexer$Token$Type;", "", "Ldorkbox/version/util/Stream$ElementType;", "Ldorkbox/version/expr/Lexer$Token;", "regexp", "", "(Ljava/lang/String;ILjava/lang/String;)V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "isMatchedBy", "", "char", "toString", "NUMERIC", "DOT", "HYPHEN", "EQUAL", "NOT_EQUAL", "GREATER", "GREATER_EQUAL", "LESS", "LESS_EQUAL", "TILDE", "WILDCARD", "CARET", "AND", "OR", "NOT", "LEFT_PAREN", "RIGHT_PAREN", "WHITESPACE", "EOI", "Version"})
        public static final class Type
        extends Enum<Type>
        implements Stream.ElementType<Token> {
            @NotNull
            private final Pattern pattern;
            public static final /* enum */ Type NUMERIC = new Type("0|[1-9][0-9]*");
            public static final /* enum */ Type DOT = new Type("\\.");
            public static final /* enum */ Type HYPHEN = new Type("-");
            public static final /* enum */ Type EQUAL = new Type("=");
            public static final /* enum */ Type NOT_EQUAL = new Type("!=");
            public static final /* enum */ Type GREATER = new Type(">(?!=)");
            public static final /* enum */ Type GREATER_EQUAL = new Type(">=");
            public static final /* enum */ Type LESS = new Type("<(?!=)");
            public static final /* enum */ Type LESS_EQUAL = new Type("<=");
            public static final /* enum */ Type TILDE = new Type("~");
            public static final /* enum */ Type WILDCARD = new Type("[\\*xX]");
            public static final /* enum */ Type CARET = new Type("\\^");
            public static final /* enum */ Type AND = new Type("&");
            public static final /* enum */ Type OR = new Type("\\|");
            public static final /* enum */ Type NOT = new Type("!(?!=)");
            public static final /* enum */ Type LEFT_PAREN = new Type("\\(");
            public static final /* enum */ Type RIGHT_PAREN = new Type("\\)");
            public static final /* enum */ Type WHITESPACE = new Type("\\s+");
            public static final /* enum */ Type EOI = new Type("?!");
            private static final /* synthetic */ Type[] $VALUES;

            private Type(String regexp) {
                Pattern pattern = Pattern.compile("^(" + regexp + ')');
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^($regexp)\")");
                this.pattern = pattern;
            }

            @NotNull
            public final Pattern getPattern() {
                return this.pattern;
            }

            @Override
            public boolean isMatchedBy(@Nullable Token token) {
                return token == null ? false : this == token.getType();
            }

            @NotNull
            public String toString() {
                return this.name() + '(' + this.pattern + ')';
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            static {
                $VALUES = typeArray = new Type[]{Type.NUMERIC, Type.DOT, Type.HYPHEN, Type.EQUAL, Type.NOT_EQUAL, Type.GREATER, Type.GREATER_EQUAL, Type.LESS, Type.LESS_EQUAL, Type.TILDE, Type.WILDCARD, Type.CARET, Type.AND, Type.OR, Type.NOT, Type.LEFT_PAREN, Type.RIGHT_PAREN, Type.WHITESPACE, Type.EOI};
            }
        }
    }
}

