package com.dotdashpay.api;

import com.dotdashpay.api.internal.DDPUtils;
import com.dotdashpay.api.internal.Request;
import com.dotdashpay.api.internal.Server;
import com.dotdashpay.api.internal.protobufs.CheckSerialConnection;
import com.dotdashpay.api.internal.protobufs.ListPeripherals;
import com.dotdashpay.api.internal.protobufs.ListenForPaymentData;

/**
 * Created by colorado on 10/30/15.
 */
public class Hardware {
    private Hardware() {}
    private static Hardware thisInstance = new Hardware();
    public static Hardware getInstance () {
        return thisInstance;
    }

    /**
     * Listen for payment data from the payments-related peripheral hardware
     *
     * @param onlyNewData specify whether we should only listen
     *                    for new payments data from the payments hardware, e.g. ignore
     *                    card swipes that occured before this method was called
     * @param responseHandler
     */
    public static void listenForPaymentData (boolean onlyNewData, ResponseHandler responseHandler) {
        ListenForPaymentData listenForPaymentDataObject =
                ListenForPaymentData.newBuilder()
                        .setData(
                                ListenForPaymentData.Data.newBuilder()
                                        .setOnlyNewData(onlyNewData))
                        .setMeta(
                                DDPUtils.getRequestMeta())
                        .build();
        Request req = new Request(listenForPaymentDataObject);
        Server.sendRequest(req, responseHandler);
    }

    /**
     *  Check the serial connection to the DotDashPay Chip.
     *
      * @param responseHandler
     */
    public static void checkSerialConnection (ResponseHandler responseHandler) {
        CheckSerialConnection checkSerialConnection =
                CheckSerialConnection.newBuilder()
                        .setData(
                                CheckSerialConnection.Data.newBuilder()
                        )
                        .setMeta(
                                DDPUtils.getRequestMeta())
                        .build();
        Request req = new Request(checkSerialConnection);
        Server.sendRequest(req, responseHandler);
    }

    /**
     * Asks the DotDashPay chip to return a list of all attached hardware peripherals.
     *
     * @param responseHandler
     */
    public static void listPeripherals (ResponseHandler responseHandler) {
        ListPeripherals listPeripherals =
                ListPeripherals.newBuilder()
                        .setData(
                                ListPeripherals.Data.newBuilder()
                        )
                        .setMeta(
                                DDPUtils.getRequestMeta())
                        .build();
        Request req = new Request(listPeripherals);
        Server.sendRequest(req, responseHandler);
    }
}
