package com.dotdashpay.api;

import com.dotdashpay.api.internal.DDPUtils;
import com.dotdashpay.api.internal.Request;
import com.dotdashpay.api.internal.Server;
import com.dotdashpay.api.internal.protobufs.CheckNetworkConnectivity;
import com.dotdashpay.api.internal.protobufs.PostData;


/**
 * Created by colorado on 11/4/15.
 */
public class Network {
    private Network() {}
    private static Network thisInstance = new Network();
    public static Network getInstance () {
        return thisInstance;
    }

    /**
     * Check the network connectivity for the DotDashPay Chip.
     *
     * @param responseHandler
     */
    public static void checkNetworkConnectivity(ResponseHandler responseHandler) {
        CheckNetworkConnectivity checkNetworkConnectivityObject = CheckNetworkConnectivity.newBuilder()
                .setData(
                        CheckNetworkConnectivity.Data.newBuilder()
                )
                .setMeta(DDPUtils.getRequestMeta())
                .build();
        Server.sendRequest(new Request(checkNetworkConnectivityObject), responseHandler);
    }

    /**
     * Send an HTTP POST request with the `data` argument to the `url` argument
     *
     * @param data: the data that will be posted to `url` and is encoded into the POST string
     *            by calling data.toString()
     * @param url: the url where the data is POSTed to
     * @param responseHandler:
     */
    public static void postData(Object data, String url, ResponseHandler responseHandler) {
        PostData postDataObject = PostData.newBuilder()
                .setData(
                        PostData.Data.newBuilder()
                        .setPostData(data.toString())
                        .setUrl(url)
                )
                .setMeta(DDPUtils.getRequestMeta())
                .build();
        Server.sendRequest(new Request(postDataObject), responseHandler);
    }
}
