package com.dotdashpay.api.internal;


import android.util.Log;

import com.dotdashpay.api.Response;
import com.dotdashpay.api.ResponseHandler;
import com.google.protobuf.Message;

import java.util.HashMap;

/**
 * Server class to manage requests/responses to/from the DDP device
 */
public class Server {
    private static ServerCommunicatorInterface serverCommunicator = null;
    private static HashMap<String, ResponseHandler> requestsMap = new HashMap<>();

    private Server () {}

    /**
     * @param simulator
     */
    public static void setup (boolean simulator) {
        if (simulator) {
            Server.serverCommunicator = new DotSimulator();
        } else {
            throw new RuntimeException("not implemented yet");
        }
    }

    public static void sendRequest (Request request, ResponseHandler responseHandler) {
        assert Server.serverCommunicator != null : new RuntimeException("you must first call Server.setup before sending a request");

        requestsMap.put(request.getId(), responseHandler);
        serverCommunicator.handleOutgoingRequest(request);
    }

    public static void handleResponse (Message protomsg) {
        String messageName = DDPUtils.getMessageName(protomsg);
        DDPLog.debug("server handling response " + messageName);

        Response response = DDPUtils.convertProtoMessageToResponse(protomsg);
        ResponseHandler responseHandler = requestsMap.get(response.getId());

        // TODO(cjrd) handle errors correctly
        if (DDPUtils.isResponseUpdate(protomsg)) {
            DDPLog.debug("Update Response: " + response);
            responseHandler.onUpdate(null, response);
        } else {
            DDPLog.debug("Completion Response: " + response);
            responseHandler.onCompletion(null, response);
        }

        // TODO(cjrd) we need to clean up the hashmap at some point

    }

    public static void close () {

    }
}
