package com.dotdashpay.api.internal;

import java.util.HashMap;

/**
 * Created by colorado on 11/4/15.
 */
public class Shared {
    private static HashMap<String, String> configuration = new HashMap<>();
    private static Shared thisInstance = new Shared();

    /**
     * Use singleton constructor to setup default configuration
     */
    private Shared() {
        // setup default configuration
        configuration.put("simulate_request_to_responses_file", "res/raw/simulate_request_to_responses.json");
        configuration.put("dev_ddp_cloud_id", "DEMO_DEV_CLOUD_ID");
        configuration.put("dev_ddp_cloud_key", "DEMO_DEV_CLOUD_KEY");
    }

    /**
     *
     * @param key
     * @param value
     */
    public static void set(String key, String value) {
        configuration.put(key, value);
    }


    /**
     * Same as set except a runtime error is thrown if the value does not already exist
     *
     * @param key
     * @param value
     */
    public static void override(String key, String value) {
        if (!configuration.containsKey(key)) {
            throw new RuntimeException(String.format("Cannot override configuration key %s: configuration does not contain this key", key));
        }
        configuration.put(key, value);
    }

    /**
     *
     * @param key
     * @return
     */
    public static String get(String key) {
        return configuration.get(key);
    }

    public static String get(String key, String defaultKey) {
        if (configuration.containsKey(key)) {
            return configuration.get(key);
        } else {
            return defaultKey;
        }

    }

    /**
     *
     * @param key
     * @return
     */
    public static boolean containsKey (String key) {
        return configuration.containsKey(key);
    }
}
