/*
 * Decompiled with CFR 0.152.
 */
package com.dotdashpay.api;

import com.dotdashpay.api.ResponseHandler;
import com.dotdashpay.api.internal.DDPUtils;
import com.dotdashpay.api.internal.Request;
import com.dotdashpay.api.internal.Server;
import com.dotdashpay.api.internal.protobufs.AuthorizePayment;
import com.dotdashpay.api.internal.protobufs.ListenForPaymentDataThenSettle;
import com.dotdashpay.api.internal.protobufs.RefundPayment;
import com.dotdashpay.api.internal.protobufs.SettlePayment;
import com.dotdashpay.api.internal.protobufs.VoidPayment;
import com.google.protobuf.Message;
import java.util.Map;

public class Payment {
    private static Payment thisInstance = new Payment();

    private Payment() {
    }

    public static Payment getInstance() {
        return thisInstance;
    }

    public static void authorizePayment(Map paymentData, ResponseHandler responseHandler) {
        int dollars = (Integer)paymentData.get("dollars");
        int cents = (Integer)paymentData.get("cents");
        String payid = (String)paymentData.get("payid");
        AuthorizePayment authorizePaymentObject = AuthorizePayment.newBuilder().setData(AuthorizePayment.Data.newBuilder().setCents(cents).setDollars(dollars).setPayid(payid)).setMeta(DDPUtils.getRequestMeta()).build();
        Request req = new Request((Message)authorizePaymentObject);
        Server.sendRequest(req, responseHandler);
    }

    public static void settlePayment(Map paymentData, ResponseHandler responseHandler) {
        int dollars = (Integer)paymentData.get("dollars");
        int cents = (Integer)paymentData.get("cents");
        String payid = (String)paymentData.get("payid");
        SettlePayment settlePaymentDataObject = SettlePayment.newBuilder().setData(SettlePayment.Data.newBuilder().setCents(cents).setDollars(dollars).setPayid(payid)).setMeta(DDPUtils.getRequestMeta()).build();
        Request req = new Request((Message)settlePaymentDataObject);
        Server.sendRequest(req, responseHandler);
    }

    public static void listenForPaymentDataThenSettle(Map paymentData, ResponseHandler responseHandler) {
        int dollars = (Integer)paymentData.get("dollars");
        int cents = (Integer)paymentData.get("cents");
        ListenForPaymentDataThenSettle listenForPaymentDataThenSettleObject = ListenForPaymentDataThenSettle.newBuilder().setData(ListenForPaymentDataThenSettle.Data.newBuilder().setCents(cents).setDollars(dollars)).setMeta(DDPUtils.getRequestMeta()).build();
        Request req = new Request((Message)listenForPaymentDataThenSettleObject);
        Server.sendRequest(req, responseHandler);
    }

    public static void refundPayment(String transactionId, ResponseHandler responseHandler) {
        RefundPayment refundPaymentObject = RefundPayment.newBuilder().setData(RefundPayment.Data.newBuilder().setTransactionId(transactionId)).setMeta(DDPUtils.getRequestMeta()).build();
        Request req = new Request((Message)refundPaymentObject);
        Server.sendRequest(req, responseHandler);
    }

    public static void voidPayment(String transactionId, ResponseHandler responseHandler) {
        VoidPayment voidPaymentObject = VoidPayment.newBuilder().setData(VoidPayment.Data.newBuilder().setTransactionId(transactionId)).setMeta(DDPUtils.getRequestMeta()).build();
        Request req = new Request((Message)voidPaymentObject);
        Server.sendRequest(req, responseHandler);
    }
}

