/*
 * Decompiled with CFR 0.152.
 */
package com.dotdashpay.api.internal;

import com.dotdashpay.api.Response;
import com.dotdashpay.api.internal.Shared;
import com.dotdashpay.api.internal.protobufs.CloudPaymentInitiated;
import com.dotdashpay.api.internal.protobufs.RequestMeta;
import com.dotdashpay.api.internal.protobufs.ResponseMeta;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public final class DDPUtils {
    private DDPUtils() {
    }

    public static RequestMeta.Builder getRequestMeta() {
        return RequestMeta.newBuilder().setId(UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String file) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        StringWriter writer = new StringWriter();
        InputStream inputStream = null;
        inputStream = DDPUtils.class.getClassLoader().getResourceAsStream(file);
        if (inputStream != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        } else {
            FileReader fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        char[] buffer = new char[1024];
        try {
            int n;
            while ((n = bufferedReader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            bufferedReader.close();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        String jsonString = ((Object)writer).toString();
        return jsonString;
    }

    public static JsonObject convertProtoToJsonObject(Message protomsg) {
        JsonObject returnJSONObject = new JsonObject();
        List fields = protomsg.getDescriptorForType().getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
            switch (fieldDescriptor.getJavaType()) {
                case INT: {
                    returnJSONObject.set(fieldDescriptor.getName(), ((Integer)protomsg.getField(fieldDescriptor)).intValue());
                    break;
                }
                case LONG: {
                    returnJSONObject.set(fieldDescriptor.getName(), ((Long)protomsg.getField(fieldDescriptor)).longValue());
                    break;
                }
                case FLOAT: {
                    returnJSONObject.set(fieldDescriptor.getName(), ((Float)protomsg.getField(fieldDescriptor)).floatValue());
                    break;
                }
                case DOUBLE: {
                    returnJSONObject.set(fieldDescriptor.getName(), ((Double)protomsg.getField(fieldDescriptor)).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    returnJSONObject.set(fieldDescriptor.getName(), ((Boolean)protomsg.getField(fieldDescriptor)).booleanValue());
                    break;
                }
                case STRING: {
                    returnJSONObject.set(fieldDescriptor.getName(), (String)protomsg.getField(fieldDescriptor));
                    break;
                }
                case BYTE_STRING: {
                    returnJSONObject.set(fieldDescriptor.getName(), (String)protomsg.getField(fieldDescriptor));
                    break;
                }
                case ENUM: {
                    Descriptors.EnumValueDescriptor enumDescript = (Descriptors.EnumValueDescriptor)protomsg.getField(fieldDescriptor);
                    returnJSONObject.set(fieldDescriptor.getName(), enumDescript.getFullName());
                    break;
                }
                case MESSAGE: {
                    returnJSONObject.set(fieldDescriptor.getName(), (JsonValue)DDPUtils.convertProtoToJsonObject((Message)protomsg.getField(fieldDescriptor)));
                }
            }
        }
        return returnJSONObject;
    }

    public static Response convertProtoMessageToResponse(Message protomsg) {
        String name = DDPUtils.getMessageName(protomsg);
        JsonObject jsonObject = DDPUtils.convertProtoToJsonObject(protomsg);
        String id = jsonObject.get("meta").asObject().get("id").asString();
        return new Response(id, name, jsonObject.get("data").asObject());
    }

    public static String getMessageName(Message protomsg) {
        return protomsg.getDescriptorForType().getFullName();
    }

    public static Class<?> getProtobufClass(String msgName) throws ClassNotFoundException {
        return Class.forName("com.dotdashpay.api.internal.protobufs." + msgName);
    }

    private static DynamicMessage.Builder getDynamicMessageBuilder(String msgName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        Class<?> MsgClass = DDPUtils.getProtobufClass(msgName);
        Method getDescriptorMethod = MsgClass.getDeclaredMethod("getDescriptor", null);
        Descriptors.Descriptor msgDescriptor = (Descriptors.Descriptor)getDescriptorMethod.invoke(null, null);
        return DynamicMessage.newBuilder((Descriptors.Descriptor)msgDescriptor);
    }

    public static Message buildProtobuf(String msgName, byte[] encodedMsg) {
        DynamicMessage returnMsg = null;
        try {
            DynamicMessage.Builder dynamicBuilder = DDPUtils.getDynamicMessageBuilder(msgName);
            returnMsg = ((DynamicMessage.Builder)dynamicBuilder.mergeFrom(encodedMsg)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMsg;
    }

    public static Message buildProtobuf(String msgName, JsonObject msgJson) {
        Message returnMsg = null;
        try {
            DynamicMessage.Builder dynamicBuilder = DDPUtils.getDynamicMessageBuilder(msgName);
            DynamicMessage dynamicMsg = dynamicBuilder.getDefaultInstanceForType();
            returnMsg = DDPUtils.createMessageFromJsonObject(msgJson, (Message)dynamicMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMsg;
    }

    private static Message createMessageFromJsonObject(JsonObject jsonObj, Message inputMsg) {
        List fields = inputMsg.getDescriptorForType().getFields();
        List jsonFieldNames = jsonObj.names();
        Message.Builder msgBuilder = inputMsg.toBuilder();
        for (Descriptors.FieldDescriptor msgField : fields) {
            String fieldName = msgField.getName();
            if (!jsonFieldNames.contains(fieldName)) continue;
            switch (msgField.getJavaType()) {
                case INT: {
                    msgBuilder.setField(msgField, (Object)jsonObj.get(fieldName).asInt());
                    break;
                }
                case LONG: {
                    msgBuilder.setField(msgField, (Object)jsonObj.get(fieldName).asLong());
                    break;
                }
                case FLOAT: {
                    msgBuilder.setField(msgField, (Object)Float.valueOf(jsonObj.get(fieldName).asFloat()));
                    break;
                }
                case DOUBLE: {
                    msgBuilder.setField(msgField, (Object)jsonObj.get(fieldName).asDouble());
                    break;
                }
                case BOOLEAN: {
                    msgBuilder.setField(msgField, (Object)jsonObj.get(fieldName).asBoolean());
                    break;
                }
                case STRING: {
                    msgBuilder.setField(msgField, (Object)jsonObj.get(fieldName).asString());
                    break;
                }
                case BYTE_STRING: {
                    throw new RuntimeException("Not yet implemented");
                }
                case ENUM: {
                    Descriptors.EnumDescriptor enumType = msgField.getEnumType();
                    Descriptors.EnumValueDescriptor enumValue = enumType.findValueByNumber(jsonObj.get(fieldName).asInt());
                    msgBuilder.setField(msgField, (Object)enumValue);
                    break;
                }
                case MESSAGE: {
                    Message embeddedMsg = (Message)inputMsg.getField(msgField);
                    Message mergedMsg = DDPUtils.createMessageFromJsonObject(jsonObj.get(fieldName).asObject(), embeddedMsg);
                    msgBuilder.setField(msgField, (Object)mergedMsg);
                }
            }
        }
        return msgBuilder.build();
    }

    public static boolean isResponseUpdate(Message responseMsg) {
        Descriptors.EnumValueDescriptor responseTypeDescriptor = (Descriptors.EnumValueDescriptor)DDPUtils.getValueFromMessage(responseMsg, "meta.response_type");
        ResponseMeta.ResponseType responseType = ResponseMeta.ResponseType.valueOf(responseTypeDescriptor);
        return responseType == ResponseMeta.ResponseType.UPDATE;
    }

    public static Object getValueFromMessage(Message msg, String accessString) {
        List<String> keys = Arrays.asList(accessString.split("\\."));
        Object returnObject = null;
        int numKeys = keys.size();
        Message currentMsg = msg;
        for (int i = 0; i < numKeys; ++i) {
            try {
                returnObject = currentMsg.getField(currentMsg.getDescriptorForType().findFieldByName(keys.get(i)));
            }
            catch (NullPointerException npe) {
                return null;
            }
            if (i >= numKeys - 1) continue;
            currentMsg = (Message)returnObject;
        }
        return returnObject;
    }

    public static CloudPaymentInitiated parseCloudPaymentJsonToProto(JsonObject paymentData, String paymentDataId) {
        return CloudPaymentInitiated.newBuilder().setData(CloudPaymentInitiated.Data.newBuilder().setPayid(paymentData.get("transaction_id").asString()).setBrand(paymentData.get("payment_method").asString()).setDollars(paymentData.get("amount").asObject().get("dollars").asInt()).setCents(paymentData.get("amount").asObject().get("cents").asInt()).setCurrency(paymentData.get("amount").asObject().get("currency").asString())).setMeta(ResponseMeta.newBuilder().setId(paymentDataId).setResponseType(ResponseMeta.ResponseType.COMPLETION)).build();
    }

    public static String getAMQPConnectionURL() {
        return String.format("amqp://%s:%s@dev.dotdashpay.com:5672", Shared.get("dev_ddp_cloud_id"), Shared.get("dev_ddp_cloud_key"));
    }
}

