/*
 * Decompiled with CFR 0.152.
 */
package com.dotdashpay.api.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.dotdashpay.api.internal.DDPLog;
import com.dotdashpay.api.internal.DDPUtils;
import com.dotdashpay.api.internal.Request;
import com.dotdashpay.api.internal.Server;
import com.dotdashpay.api.internal.ServerCommunicatorInterface;
import com.dotdashpay.api.internal.Shared;
import com.dotdashpay.api.internal.protobufs.CloudPaymentInitiated;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class DotSimulator
implements ServerCommunicatorInterface {
    protected JsonObject requestToResponsesJson;
    protected static HashMap<String, com.google.protobuf.Message> simulatorResponses = new HashMap();
    protected static HashMap<String, Boolean> disabledSimulatorRequests = new HashMap();
    protected String lastWaitForPaymentDataId = "";
    protected Thread subscribeThread;
    protected Thread publishThread;
    protected String opsQueueName = "ops-gaspump-test";
    protected String opsReturnQueueName = "ops-return-gaspump-test";
    private BlockingDeque<String> queue = new LinkedBlockingDeque<String>();
    private boolean operationsConnectionSetup = false;
    private ConnectionFactory factory = new ConnectionFactory();
    private final Handler incomingMessageHandler = new Handler(){

        public void handleMessage(Message msg) {
            String message = msg.getData().getString("msg");
            JsonObject jsonMessage = null;
            JsonObject paymentData = null;
            try {
                jsonMessage = Json.parse((String)message).asObject();
                paymentData = jsonMessage.get("arguments").asArray().get(0).asObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                DDPLog.debug("could not parse json message");
                return;
            }
            String msgType = jsonMessage.get("operation").asString();
            switch (msgType.toLowerCase(Locale.ENGLISH)) {
                case "cloudpayment": {
                    CloudPaymentInitiated cloudPaymentInitiated = DDPUtils.parseCloudPaymentJsonToProto(paymentData, DotSimulator.this.lastWaitForPaymentDataId);
                    Server.handleResponse((com.google.protobuf.Message)cloudPaymentInitiated);
                    break;
                }
            }
        }
    };

    public DotSimulator() {
        String requestToResponseJsonString = "{}";
        try {
            String file = Shared.get("simulate_request_to_responses_file");
            requestToResponseJsonString = DDPUtils.readFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to read simulation request-to-responses file");
        }
        this.requestToResponsesJson = Json.parse((String)requestToResponseJsonString).asObject();
    }

    @Override
    public void handleOutgoingRequest(Request request) {
        if (disabledSimulatorRequests.containsKey(request.getName())) {
            this.setupOperationsConnection();
            if (request.getName().equalsIgnoreCase("ListenForPaymentData")) {
                this.lastWaitForPaymentDataId = request.getId();
            }
            return;
        }
        JsonArray responses = this.requestToResponsesJson.get(request.getName()).asObject().get("default").asArray();
        for (JsonValue resp : responses) {
            JsonObject respInfo = resp.asObject();
            respInfo.get("meta").asObject().set("id", request.getId());
            String messageName = respInfo.get("message").asString();
            Server.handleResponse(DDPUtils.buildProtobuf(messageName, respInfo));
        }
    }

    public static void disableSimulatorRequestResponses(String requestName) {
        disabledSimulatorRequests.put(requestName, true);
    }

    public static void enableSimulatorRequestResponses(String requestName) {
        if (disabledSimulatorRequests.containsKey(requestName)) {
            disabledSimulatorRequests.remove(requestName);
        }
    }

    private void setupOperationsConnection() {
        if (this.operationsConnectionSetup) {
            return;
        }
        this.operationsConnectionSetup = true;
        this.setupAMQPConnectionFactory();
        this.setupAMQPPublishing();
        this.listenForCloudData(this.incomingMessageHandler);
    }

    private void publishAMQPReturnMessage(String message) {
        try {
            DDPLog.debug("[q] " + message);
            this.queue.putLast(message);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setupAMQPPublishing() {
        this.publishThread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.publishThread.start();
    }

    private void setupAMQPConnectionFactory() {
        try {
            this.factory.setAutomaticRecoveryEnabled(false);
            this.factory.setUri(DDPUtils.getAMQPConnectionURL());
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
    }

    private void listenForCloudData(final Handler handler) {
        this.subscribeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Connection connection = DotSimulator.this.factory.newConnection();
                        Channel channel = connection.createChannel();
                        channel.basicQos(1);
                        channel.queueDeclare(DotSimulator.this.opsQueueName, false, false, false, new HashMap());
                        QueueingConsumer consumer = new QueueingConsumer(channel);
                        channel.basicConsume(DotSimulator.this.opsQueueName, true, (Consumer)consumer);
                        while (true) {
                            QueueingConsumer.Delivery delivery = consumer.nextDelivery();
                            Envelope envelope = delivery.getEnvelope();
                            channel.basicAck(envelope.getDeliveryTag(), false);
                            String message = new String(delivery.getBody());
                            DDPLog.debug("[r] " + message);
                            Message msg = handler.obtainMessage();
                            Bundle bundle = new Bundle();
                            bundle.putString("msg", message);
                            msg.setData(bundle);
                            String correlationId = delivery.getProperties().getCorrelationId();
                            DotSimulator.this.publishAMQPReturnMessage(correlationId + " {\"status\": 0}");
                            handler.sendMessage(msg);
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e1) {
                        DDPLog.debug("Connection broken: " + e1.getClass().getName());
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        });
        this.subscribeThread.start();
    }

    static /* synthetic */ BlockingDeque access$100(DotSimulator x0) {
        return x0.queue;
    }
}

