/*
 * Decompiled with CFR 0.152.
 */
package com.dotdashpay.api.internal;

import com.dotdashpay.api.Response;
import com.dotdashpay.api.ResponseHandler;
import com.dotdashpay.api.internal.DDPLog;
import com.dotdashpay.api.internal.DDPUtils;
import com.dotdashpay.api.internal.DotSimulator;
import com.dotdashpay.api.internal.Request;
import com.dotdashpay.api.internal.ServerCommunicatorInterface;
import com.google.protobuf.Message;
import java.util.HashMap;

public class Server {
    private static ServerCommunicatorInterface serverCommunicator = null;
    private static HashMap<String, ResponseHandler> requestsMap = new HashMap();

    private Server() {
    }

    public static void setup(boolean simulator) {
        if (!simulator) {
            throw new RuntimeException("not implemented yet");
        }
        serverCommunicator = new DotSimulator();
    }

    public static void sendRequest(Request request, ResponseHandler responseHandler) {
        assert (serverCommunicator != null) : new RuntimeException("you must first call Server.setup before sending a request");
        requestsMap.put(request.getId(), responseHandler);
        serverCommunicator.handleOutgoingRequest(request);
    }

    public static void handleResponse(Message protomsg) {
        String messageName = DDPUtils.getMessageName(protomsg);
        DDPLog.debug("server handling response " + messageName);
        Response response = DDPUtils.convertProtoMessageToResponse(protomsg);
        ResponseHandler responseHandler = requestsMap.get(response.getId());
        if (DDPUtils.isResponseUpdate(protomsg)) {
            DDPLog.debug("Update Response: " + response);
            responseHandler.onUpdate(null, response);
        } else {
            DDPLog.debug("Completion Response: " + response);
            responseHandler.onCompletion(null, response);
        }
    }

    public static void close() {
    }
}

