DDP APIs interact with the Dot via "requests": a request either prompts action from the Dot or asks the Dot to inform the requestor of certain events that take place on the Dot, e.g. changes in wifi/cell connectivity. 

## Requests
Requests are communicated to the Dot using [protocol buffers](https://developers.google.com/protocol-buffers). You can view the request specifications in [/spec](spec). Each request has two important fields, the _meta_ field, which keeps track of the request you're making and the associated information with that request, and the _data_ field, which holds the necessary data for the request. In json format, a request looks like:

```json
{
    "meta": 
    {
        "id": "xyz123",
        "name": "RequestName",
        "message_type": 0,
    },

    "data":
    {
        "key1": "value1",
        ...
    }
}
```

## Responses
Every request has a set of associated responses from the Dot. Response are **event-driven** and a single request can **produce many responses** where each response is associated with an event. For example, the request `WaitForPaymentDataFromHardware` will result in a sequence of two responses from the Dot, i.e. one response for each of the following events, depending on what type of payment hardware is used:

* `MSRStartRead`
* `NFCStartRead`

then one of the following events

* `MSRFinishedRead`
* `NFCFinishedRead`

This relationship between requests and responses is expressed in each request proto file, e.g. [WaitForPaymentDataFromHardware.proto](spec/WaitForPaymentDataFromHardware.proto) has a section `RESPONSES` that specifies all responses from this request. The format for each response messages is specified as a protocol buffer and can be found in the apropo request proto file. 


## Requests API Example
This is a working example of the requests API documentation. The full documentation will be auto-generated from the proto files and will be made available in Oct. 2015.

### **ListenForPaymentData**
This request asks for payment data from any payment peripheral, such as a magstripe reader.

#### Data
* `only_new_data` <bool>: if true, then only return new data, e.g. from a new magstripe swipe or NFC touch, if false, then return data from a recent interaction with a payment peripheral, e.g. return data from the user swiping their card before being prompted.
