/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AjpMessage;
import com.doyensec.ajp13.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class AbstractAjpMessage
implements AjpMessage {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    AbstractAjpMessage(int packetType) {
        if (packetType == 0 || packetType == 2 || packetType == 7 || packetType == 8 || packetType == 10) {
            this.bos.write(Constants.AJP_TAG_REQ, 0, Constants.AJP_TAG_REQ.length);
        } else {
            this.bos.write(Constants.AJP_TAG_RESP, 0, Constants.AJP_TAG_RESP.length);
        }
        this.bos.write(0);
        this.bos.write(0);
        if (packetType != 0) {
            this.bos.write(packetType);
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.getBytes());
        out.flush();
    }

    @Override
    public final byte[] getBytes() {
        byte[] bytes = this.bos.toByteArray();
        int length = bytes.length - 4;
        if (length == -1) {
            bytes[2] = -1;
            bytes[3] = -1;
        } else {
            bytes[2] = (byte)((length & 0xFF00) >> 8);
            bytes[3] = (byte)(length & 0xFF);
        }
        return bytes;
    }

    void writeByte(int b) {
        this.bos.write(b);
    }

    void writeBytes(byte[] ba) throws IOException {
        this.bos.write(ba);
    }

    void writeInt(int i) {
        this.bos.write((i & 0xFF00) >> 8);
        this.bos.write(i & 0xFF);
    }

    void writeBoolean(boolean b) {
        this.bos.write(b ? 1 : 0);
    }

    void writeString(String s, boolean term) {
        if (s == null) {
            this.bos.write(0);
        } else {
            this.writeInt(s.length());
            try {
                byte[] buf = s.getBytes("UTF-8");
                this.bos.write(buf, 0, buf.length);
                if (term) {
                    this.bos.write(0);
                }
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("[!] AbstractAjpMessage UnsupportedEncodingException: " + ex.getLocalizedMessage());
            }
        }
    }
}

