/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AbstractAjpMessage;
import com.doyensec.ajp13.AjpReader;
import com.doyensec.ajp13.Constants;
import com.doyensec.ajp13.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ForwardRequestMessage
extends AbstractAjpMessage {
    private int method;
    private String protocol;
    private String requestUri;
    private String remoteAddr;
    private String remoteHost;
    private String serverName;
    private int serverPort;
    private boolean isSsl;
    private List<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
    private List<Pair<String, String>> attributes = new LinkedList<Pair<String, String>>();

    public ForwardRequestMessage(int method, URL url, List<Pair<String, String>> headers, List<Pair<String, String>> attributes) throws UnknownHostException {
        this(method, "HTTP/1.1", url.getPath(), InetAddress.getLocalHost().getHostAddress(), InetAddress.getLocalHost().getCanonicalHostName(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), url.getProtocol().equalsIgnoreCase("https"), headers, attributes);
        if (url.getQuery() != null) {
            this.addAttribute("query_string", url.getQuery());
        }
    }

    public ForwardRequestMessage(int method, String protocol, String requestUri, String remoteAddr, String remoteHost, String serverName, int serverPort, boolean isSsl, List<Pair<String, String>> headers, List<Pair<String, String>> attributes) {
        super(2);
        String value;
        String name;
        this.method = method;
        this.writeByte(method);
        this.protocol = protocol;
        this.writeString(protocol, true);
        this.requestUri = requestUri;
        this.writeString(requestUri, true);
        this.remoteAddr = remoteAddr;
        this.writeString(remoteAddr, true);
        this.remoteHost = remoteHost;
        this.writeString(remoteHost, true);
        this.serverName = serverName;
        this.writeString(serverName, true);
        this.serverPort = serverPort;
        this.writeInt(serverPort);
        this.isSsl = isSsl;
        this.writeBoolean(isSsl);
        if (headers == null) {
            headers = new LinkedList<Pair<String, String>>();
        }
        this.headers = headers;
        if (headers.isEmpty()) {
            this.addHeader("Host", serverName + ":" + serverPort);
        }
        this.writeInt(headers.size());
        for (Pair<String, String> header : headers) {
            name = (String)header.a;
            value = (String)header.b;
            if (Constants.COMMON_HEADERS.containsKey(name.toLowerCase())) {
                this.writeByte(160);
                this.writeByte(Constants.COMMON_HEADERS.get(name.toLowerCase()));
            } else {
                this.writeString(name, true);
            }
            this.writeString(value, true);
        }
        if (attributes == null) {
            attributes = new LinkedList<Pair<String, String>>();
        }
        this.attributes = attributes;
        for (Pair<String, String> attribute : attributes) {
            name = (String)attribute.a;
            value = (String)attribute.b;
            if (Constants.COMMON_ATTRIBUTES.containsKey(name.toLowerCase())) {
                this.writeByte(Constants.COMMON_ATTRIBUTES.get(name.toLowerCase()));
            } else {
                this.writeByte(Constants.COMMON_ATTRIBUTES.get("req_attribute"));
                this.writeString(name, true);
            }
            this.writeString(value, true);
        }
        this.writeByte(255);
    }

    public static ForwardRequestMessage ForwardRequestMessageGetBuilder(URL url) throws UnknownHostException {
        return new ForwardRequestMessage(2, url, null, null);
    }

    public static ForwardRequestMessage ForwardRequestMessagePostBuilder(URL url, int contentLength) throws UnknownHostException {
        LinkedList<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
        headers.add(Pair.make("Content-Length", String.valueOf(contentLength)));
        if (contentLength > 0) {
            headers.add(Pair.make("Content-Type", "application/x-www-form-urlencoded"));
        }
        return new ForwardRequestMessage(4, url, headers, null);
    }

    public int getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    public List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    final void addHeader(String name, String value) {
        this.headers.add(Pair.make(name, value));
    }

    final void addAttribute(String name, String value) {
        this.attributes.add(Pair.make(name, value));
    }

    public int numHeaders() {
        return this.headers.size();
    }

    public int numAttributes() {
        return this.attributes.size();
    }

    static ForwardRequestMessage readFrom(InputStream in) throws IOException {
        int next;
        int method = AjpReader.readByte(in);
        String protocol = AjpReader.readString(in);
        String requestUri = AjpReader.readString(in);
        String remoteAddr = AjpReader.readString(in);
        String remoteHost = AjpReader.readString(in);
        String serverName = AjpReader.readString(in);
        int serverPort = AjpReader.readInt(in);
        boolean isSsl = AjpReader.readBoolean(in);
        int numHeaders = AjpReader.readInt(in);
        LinkedList<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
        for (int i = 0; i < numHeaders; ++i) {
            int b1 = AjpReader.readByte(in);
            int b2 = AjpReader.readByte(in);
            String name = "";
            if (b1 == 160 && Constants.COMMON_HEADERS.containsValue(b2)) {
                for (Map.Entry<String, Integer> entry : Constants.COMMON_HEADERS.entrySet()) {
                    String key = entry.getKey();
                    Integer value = entry.getValue();
                    if (value != b2) continue;
                    name = key;
                }
            } else {
                name = AjpReader.readString(AjpReader.makeInt(b1, b2), in);
            }
            headers.add(Pair.make(name, AjpReader.readString(in)));
        }
        LinkedList<Pair<String, String>> attributes = new LinkedList<Pair<String, String>>();
        while (in.available() > 0 && (next = AjpReader.readByte(in)) != 255) {
            if (Constants.COMMON_ATTRIBUTES.containsValue(next)) {
                String name = "";
                for (Map.Entry<String, Integer> entry : Constants.COMMON_ATTRIBUTES.entrySet()) {
                    String key = entry.getKey();
                    Integer value = entry.getValue();
                    if (value != next || !(name = key).equalsIgnoreCase("req_attribute")) continue;
                    name = AjpReader.readString(in);
                }
                attributes.add(Pair.make(name, AjpReader.readString(in)));
                continue;
            }
            System.out.println("[!] ForwardRequestMessage Unexpected Attribute: " + next);
        }
        return new ForwardRequestMessage(method, protocol, requestUri, remoteAddr, remoteHost, serverName, serverPort, isSsl, headers, attributes);
    }

    public String toString() {
        String value;
        String name;
        StringBuilder sb = new StringBuilder();
        sb.append("Method: ").append(this.method).append("\n");
        sb.append("Protocol: ").append(this.protocol).append("\n");
        sb.append("RequestUri: ").append(this.requestUri).append("\n");
        sb.append("RemoteAddr: ").append(this.remoteAddr).append("\n");
        sb.append("RemoteHost: ").append(this.remoteHost).append("\n");
        sb.append("ServerName: ").append(this.serverName).append("\n");
        sb.append("ServerPort: ").append(this.serverPort).append("\n");
        sb.append("isSsl: ").append(this.isSsl).append("\n");
        for (Pair<String, String> header : this.headers) {
            name = (String)header.a;
            value = (String)header.b;
            sb.append("Header: ").append(name).append(" ").append(value).append("\n");
        }
        for (Pair<String, String> attribute : this.attributes) {
            name = (String)attribute.a;
            value = (String)attribute.b;
            sb.append("Attribute: ").append(name).append(" ").append(value).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "Forward Request (begin the request-processing cycle)";
    }

    @Override
    public String getDescription() {
        return "Begin the request-processing cycle with the following data.\n" + this.toString();
    }
}

