/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AbstractAjpMessage;
import com.doyensec.ajp13.AjpReader;
import com.doyensec.ajp13.Constants;
import com.doyensec.ajp13.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SendHeadersMessage
extends AbstractAjpMessage {
    private int statusCode;
    private String statusMessage;
    private List<Pair<String, String>> headers;

    public SendHeadersMessage(int statusCode, String statusMessage, List<Pair<String, String>> headers) throws IOException {
        super(4);
        this.statusCode = statusCode;
        this.writeInt(statusCode);
        this.statusMessage = statusMessage;
        this.writeString(statusMessage, true);
        this.headers = headers;
        int numHeaders = headers.size();
        this.writeInt(numHeaders);
        for (Pair<String, String> header : headers) {
            String name = (String)header.a;
            String value = (String)header.b;
            if (Constants.RESPONSE_HEADERS.containsKey(name.toLowerCase())) {
                this.writeByte(160);
                this.writeByte(Constants.RESPONSE_HEADERS.get(name.toLowerCase()));
            } else {
                this.writeString(name, true);
            }
            this.writeString(value, true);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.statusCode).append(" ").append(this.statusMessage).append("\n");
        ret.append("Headers:\n");
        for (Pair<String, String> header : this.headers) {
            ret.append((String)header.a).append(": ").append((String)header.b).append("\n");
        }
        return ret.toString();
    }

    static SendHeadersMessage readFrom(InputStream in) throws IOException {
        int statusCode = AjpReader.readInt(in);
        String statusMessage = AjpReader.readString(in);
        int numHeaders = AjpReader.readInt(in);
        LinkedList<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();
        for (int i = 0; i < numHeaders; ++i) {
            int b1 = AjpReader.readByte(in);
            int b2 = AjpReader.readByte(in);
            String name = "";
            if (b1 == 160 && Constants.RESPONSE_HEADERS.containsValue(b2)) {
                for (Map.Entry<String, Integer> entry : Constants.RESPONSE_HEADERS.entrySet()) {
                    String key = entry.getKey();
                    Integer value = entry.getValue();
                    if (value != b2) continue;
                    name = key;
                }
            } else {
                name = AjpReader.readString(AjpReader.makeInt(b1, b2), in);
            }
            headers.add(Pair.make(name, AjpReader.readString(in)));
        }
        return new SendHeadersMessage(statusCode, statusMessage, headers);
    }

    @Override
    public String getName() {
        return "Send Headers";
    }

    @Override
    public String getDescription() {
        return "Send the response headers from the servlet container to the web server.\nContent:\n" + this.toString();
    }
}

