/*
 * Decompiled with CFR 0.152.
 */
package com.dpforge.ocubator;

import com.dpforge.ocubator.CompilationError;
import com.dpforge.ocubator.GeneratedFile;
import com.dpforge.ocubator.InstanceCreator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompilationResult {
    private final boolean success;
    private final List<GeneratedFile> generatedFiles;
    private final List<CompilationError> errors;
    private final ClassLoader classLoader;
    private final Map<String, GeneratedFile> generatedFilePathMap;

    private CompilationResult(Builder builder) {
        this.success = builder.success;
        this.generatedFiles = builder.generatedFiles;
        this.errors = builder.errors;
        this.classLoader = builder.classLoader;
        this.generatedFilePathMap = new HashMap<String, GeneratedFile>(this.generatedFiles.size());
        for (GeneratedFile file : this.generatedFiles) {
            this.generatedFilePathMap.put(file.getPath(), file);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<GeneratedFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public GeneratedFile getGeneratedFile(String path) {
        return this.generatedFilePathMap.get(path);
    }

    public List<CompilationError> getErrors() {
        return this.errors;
    }

    public InstanceCreator newInstanceOf(String qualifiedName) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(qualifiedName, true, this.classLoader);
        return new InstanceCreator(clazz);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private boolean success;
        private List<CompilationError> errors = Collections.emptyList();
        private List<GeneratedFile> generatedFiles = Collections.emptyList();
        private ClassLoader classLoader;

        Builder() {
        }

        Builder success(boolean success) {
            this.success = success;
            return this;
        }

        Builder generatedFiles(List<GeneratedFile> generatedFiles) {
            this.generatedFiles = generatedFiles;
            return this;
        }

        Builder errors(List<CompilationError> errors) {
            this.errors = errors;
            return this;
        }

        Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        CompilationResult build() {
            return new CompilationResult(this);
        }
    }
}

