/*
 * Decompiled with CFR 0.152.
 */
package com.dpforge.ocubator;

import com.dpforge.ocubator.CompilationResult;
import com.dpforge.ocubator.TaskCompiler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Processor;

public class CompilationTask {
    private final TaskCompiler compiler;
    final List<String> sources = new ArrayList<String>();
    final List<String> sourcePathList = new ArrayList<String>();
    final List<Processor> processors = new ArrayList<Processor>();

    CompilationTask(TaskCompiler compiler) {
        this.compiler = compiler;
    }

    public CompilationTask sourceCode(String code) {
        this.sources.add(code);
        return this;
    }

    public CompilationTask sourceCode(String ... lines) {
        this.sources.add(String.join((CharSequence)"\n", lines));
        return this;
    }

    public CompilationTask sourcePath(File file) {
        this.sourcePath(file.getAbsolutePath());
        return this;
    }

    public CompilationTask sourcePath(String sourcePath) {
        this.sourcePathList.add(sourcePath);
        return this;
    }

    public CompilationTask withProcessor(Processor processor) {
        this.processors.add(processor);
        return this;
    }

    public CompilationResult please() {
        return this.compiler.compileTask(this);
    }
}

