/*
 * Decompiled with CFR 0.152.
 */
package com.dpforge.ocubator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class InMemoryFile
extends SimpleJavaFileObject {
    private byte[] data;

    protected InMemoryFile(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
    }

    protected InMemoryFile(URI uri, JavaFileObject.Kind kind, String content) {
        super(uri, kind);
        this.data = content.getBytes(StandardCharsets.UTF_8);
    }

    String getContentAsString() {
        return new String(this.getContentAsByteArray());
    }

    byte[] getContentAsByteArray() {
        if (this.data == null) {
            throw new NullPointerException("Cannot get content. File not found");
        }
        return this.data;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        this.ensureFileExists();
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public OutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                InMemoryFile.access$002(InMemoryFile.this, this.toByteArray());
                super.close();
            }
        };
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.openInputStream());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        this.ensureFileExists();
        return new String(this.data);
    }

    @Override
    public Writer openWriter() {
        return new OutputStreamWriter(this.openOutputStream());
    }

    private void ensureFileExists() throws FileNotFoundException {
        if (this.data == null) {
            throw new FileNotFoundException();
        }
    }

    static /* synthetic */ byte[] access$002(InMemoryFile x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

