/*
 * Decompiled with CFR 0.152.
 */
package com.dpforge.ocubator;

import com.dpforge.ocubator.GeneratedFile;
import com.dpforge.ocubator.InMemoryFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

class InMemoryFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final Map<URI, InMemoryFile> memory = new HashMap<URI, InMemoryFile>();

    InMemoryFileManager(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        return this.getMemoryFile(InMemoryFileManager.toJavaFileUri(location, className, kind), kind);
    }

    @Override
    public ClassLoader getClassLoader(final JavaFileManager.Location location) {
        return new ClassLoader(InMemoryFileManager.class.getClassLoader()){

            @Override
            protected Class<?> findClass(String name) {
                URI classUri = InMemoryFileManager.toJavaFileUri(location, name, JavaFileObject.Kind.CLASS);
                byte[] byteArray = InMemoryFileManager.this.getMemoryFile(classUri, JavaFileObject.Kind.CLASS).getContentAsByteArray();
                return super.defineClass(name, byteArray, 0, byteArray.length);
            }
        };
    }

    List<GeneratedFile> getGeneratedFiles() {
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>(this.memory.size());
        for (Map.Entry<URI, InMemoryFile> entry : this.memory.entrySet()) {
            if (entry.getValue().getKind() != JavaFileObject.Kind.SOURCE || !InMemoryFileManager.isGeneratedFile(entry.getKey())) continue;
            result.add(new GeneratedFile(InMemoryFileManager.extractSourceOutputFilePath(entry.getKey()), entry.getValue().getContentAsString()));
        }
        return result;
    }

    static JavaFileObject createSourceFile(String packageName, String className, String sourceCode) {
        URI uri = InMemoryFileManager.toJavaFileUri(StandardLocation.SOURCE_PATH, packageName + "." + className, JavaFileObject.Kind.SOURCE);
        return new InMemoryFile(uri, JavaFileObject.Kind.SOURCE, sourceCode);
    }

    private static boolean isGeneratedFile(URI uri) {
        return uri.getPath().startsWith("/" + StandardLocation.SOURCE_OUTPUT.name());
    }

    private static String extractSourceOutputFilePath(URI uri) {
        return uri.getPath().substring(StandardLocation.SOURCE_OUTPUT.getName().length() + 2);
    }

    private static URI toJavaFileUri(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        return URI.create("memory:///" + location.getName() + '/' + className.replace('.', '/') + kind.extension);
    }

    private InMemoryFile getMemoryFile(URI uri, JavaFileObject.Kind kind) {
        return this.memory.computeIfAbsent(uri, computeUri -> new InMemoryFile((URI)computeUri, kind));
    }
}

