/*
 * Decompiled with CFR 0.152.
 */
package com.dpforge.ocubator;

import com.dpforge.ocubator.CompilationDiagnostics;
import com.dpforge.ocubator.CompilationResult;
import com.dpforge.ocubator.CompilationTask;
import com.dpforge.ocubator.InMemoryFileManager;
import com.dpforge.ocubator.SourceCodePropertyExtractor;
import com.dpforge.ocubator.TaskCompiler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class OcubatorCompiler
implements TaskCompiler {
    private OcubatorCompiler() {
    }

    public static CompilationTask compile() {
        return new CompilationTask(new OcubatorCompiler());
    }

    @Override
    public CompilationResult compileTask(CompilationTask task) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        CompilationDiagnostics diagnostics = new CompilationDiagnostics();
        InMemoryFileManager fileManager = new InMemoryFileManager(compiler.getStandardFileManager(diagnostics, null, null));
        JavaCompiler.CompilationTask javacTask = compiler.getTask(null, fileManager, diagnostics, OcubatorCompiler.collectCompilationOptions(task), null, OcubatorCompiler.collectSources(task));
        javacTask.setProcessors(Collections.unmodifiableList(task.processors));
        return CompilationResult.newBuilder().success(javacTask.call()).generatedFiles(fileManager.getGeneratedFiles()).errors(diagnostics.getErrors()).classLoader(fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT)).build();
    }

    private static Collection<JavaFileObject> collectSources(CompilationTask task) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(task.sources.size());
        for (String sourceCode : task.sources) {
            String packageName = SourceCodePropertyExtractor.extractPackage(sourceCode);
            String className = SourceCodePropertyExtractor.extractClassName(sourceCode);
            result.add(InMemoryFileManager.createSourceFile(packageName, className, sourceCode));
        }
        return result;
    }

    static Collection<String> collectCompilationOptions(CompilationTask task) {
        ArrayList<String> result = new ArrayList<String>();
        if (!task.sourcePathList.isEmpty()) {
            result.add("-sourcepath");
            result.add(String.join((CharSequence)";", task.sourcePathList));
        }
        return result;
    }
}

