/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto.model;

import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.internal.CryptoUtils;
import com.dracoon.sdk.crypto.internal.CryptoVersion;
import com.dracoon.sdk.crypto.model.FileKey;

public class PlainFileKey
extends FileKey<Version> {
    public PlainFileKey(Version version, byte[] key, byte[] iv) throws IllegalArgumentException {
        super(version, key, iv);
    }

    public static enum Version implements CryptoVersion
    {
        AES256GCM("A");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version getByValue(String value) throws UnknownVersionException {
            Version v = (Version)CryptoUtils.findCryptoVersionEnum((CryptoVersion[])Version.values(), (String)value);
            if (v == null) {
                throw new UnknownVersionException("Unknown plain file key version.");
            }
            return v;
        }
    }
}

