/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto.model;

import com.dracoon.sdk.crypto.internal.Validator;

public abstract class FileKey<T> {
    private final T version;
    private final byte[] key;
    private final byte[] iv;
    private byte[] tag;

    protected FileKey(T version, byte[] key, byte[] iv) throws IllegalArgumentException {
        Validator.validateNotNull("version", version);
        Validator.validateByteArray("key", key);
        Validator.validateByteArray("iv", iv);
        this.version = version;
        this.key = key;
        this.iv = iv;
    }

    public T getVersion() {
        return this.version;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public void setTag(byte[] tag) {
        this.tag = tag;
    }
}

