/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk;

import com.dracoon.sdk.internal.validator.ValidatorUtils;

public class DracoonAuth {
    private final Mode mMode;
    private String mClientId;
    private String mClientSecret;
    private String mAuthorizationCode;
    private String mAccessToken;
    private String mRefreshToken;

    public DracoonAuth(String clientId, String clientSecret, String authorizationCode) {
        this.mMode = Mode.AUTHORIZATION_CODE;
        ValidatorUtils.validateString("Client ID", clientId, false);
        this.mClientId = clientId;
        ValidatorUtils.validateString("Client secret", clientSecret, false);
        this.mClientSecret = clientSecret;
        ValidatorUtils.validateString("Authorization code", authorizationCode, false);
        this.mAuthorizationCode = authorizationCode;
    }

    public DracoonAuth(String accessToken) {
        this.mMode = Mode.ACCESS_TOKEN;
        ValidatorUtils.validateString("Access token", accessToken, false);
        this.mAccessToken = accessToken;
    }

    public DracoonAuth(String clientId, String clientSecret, String accessToken, String refreshToken) {
        this.mMode = Mode.ACCESS_REFRESH_TOKEN;
        ValidatorUtils.validateString("Client ID", clientId, false);
        this.mClientId = clientId;
        ValidatorUtils.validateString("Client secret", clientSecret, false);
        this.mClientSecret = clientSecret;
        ValidatorUtils.validateString("Access token", accessToken, false);
        this.mAccessToken = accessToken;
        ValidatorUtils.validateString("Refresh token", refreshToken, true);
        this.mRefreshToken = refreshToken;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public String getAuthorizationCode() {
        return this.mAuthorizationCode;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public static enum Mode {
        AUTHORIZATION_CODE,
        ACCESS_TOKEN,
        ACCESS_REFRESH_TOKEN;

    }
}

