/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.Log;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.filter.GetDownloadSharesFilter;
import com.dracoon.sdk.filter.GetNodesFilters;
import com.dracoon.sdk.filter.GetUploadSharesFilter;
import com.dracoon.sdk.filter.SearchNodesFilters;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import com.dracoon.sdk.model.ClassificationPolicies;
import com.dracoon.sdk.model.CopyNodesRequest;
import com.dracoon.sdk.model.CreateDownloadShareRequest;
import com.dracoon.sdk.model.CreateFolderRequest;
import com.dracoon.sdk.model.CreateNodeCommentRequest;
import com.dracoon.sdk.model.CreateRoomRequest;
import com.dracoon.sdk.model.CreateUploadShareRequest;
import com.dracoon.sdk.model.CustomerAccount;
import com.dracoon.sdk.model.DeleteNodesRequest;
import com.dracoon.sdk.model.DownloadShare;
import com.dracoon.sdk.model.DownloadShareList;
import com.dracoon.sdk.model.FileDownloadCallback;
import com.dracoon.sdk.model.FileDownloadStream;
import com.dracoon.sdk.model.FileUploadCallback;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.FileUploadStream;
import com.dracoon.sdk.model.FileVirusScanInfo;
import com.dracoon.sdk.model.FileVirusScanInfoList;
import com.dracoon.sdk.model.GetFilesVirusScanInfoRequest;
import com.dracoon.sdk.model.MoveNodesRequest;
import com.dracoon.sdk.model.Node;
import com.dracoon.sdk.model.NodeComment;
import com.dracoon.sdk.model.NodeCommentList;
import com.dracoon.sdk.model.NodeList;
import com.dracoon.sdk.model.PasswordPolicies;
import com.dracoon.sdk.model.ServerDefaults;
import com.dracoon.sdk.model.ServerGeneralSettings;
import com.dracoon.sdk.model.UpdateFileRequest;
import com.dracoon.sdk.model.UpdateFolderRequest;
import com.dracoon.sdk.model.UpdateNodeCommentRequest;
import com.dracoon.sdk.model.UpdateRoomConfigRequest;
import com.dracoon.sdk.model.UpdateRoomRequest;
import com.dracoon.sdk.model.UploadShare;
import com.dracoon.sdk.model.UploadShareList;
import com.dracoon.sdk.model.UserAccount;
import com.dracoon.sdk.model.UserKeyPairAlgorithm;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class DracoonClient {
    protected URL mServerUrl;

    protected DracoonClient(URL serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public URL getServerUrl() {
        return this.mServerUrl;
    }

    public abstract DracoonAuth getAuth();

    public abstract boolean isAuthValid() throws DracoonNetIOException, DracoonApiException;

    public abstract void checkAuthValid() throws DracoonNetIOException, DracoonApiException;

    public abstract char[] getEncryptionPassword();

    public abstract void setEncryptionPassword(char[] var1);

    public abstract Server server();

    public abstract Account account();

    public abstract Users users();

    public abstract Groups groups();

    public abstract Nodes nodes();

    public abstract Shares shares();

    public static class Builder {
        private final DracoonClientImpl mClient;

        public Builder(URL serverUrl) {
            ValidatorUtils.validateServerURL(serverUrl);
            this.mClient = new DracoonClientImpl(serverUrl);
        }

        public Builder auth(DracoonAuth auth) {
            this.mClient.setAuth(auth);
            return this;
        }

        public Builder encryptionPassword(char[] encryptionPassword) {
            this.mClient.setEncryptionPassword(encryptionPassword);
            return this;
        }

        public Builder log(Log log) {
            this.mClient.setLog(log);
            return this;
        }

        public Builder httpConfig(DracoonHttpConfig httpConfig) {
            this.mClient.setHttpConfig(httpConfig);
            return this;
        }

        public DracoonClient build() throws DracoonNetIOException, DracoonApiException {
            this.mClient.init();
            this.mClient.checkApiVersionSupported();
            this.mClient.retrieveAuthTokens();
            return this.mClient;
        }
    }

    public static interface Shares {
        public DownloadShare createDownloadShare(CreateDownloadShareRequest var1) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public DownloadShareList getDownloadShares() throws DracoonNetIOException, DracoonApiException;

        public DownloadShareList getDownloadShares(long var1, long var3) throws DracoonNetIOException, DracoonApiException;

        public DownloadShareList getDownloadShares(GetDownloadSharesFilter var1) throws DracoonNetIOException, DracoonApiException;

        public DownloadShareList getDownloadShares(GetDownloadSharesFilter var1, long var2, long var4) throws DracoonNetIOException, DracoonApiException;

        public byte[] getDownloadShareQrCode(long var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteDownloadShare(long var1) throws DracoonNetIOException, DracoonApiException;

        public UploadShare createUploadShare(CreateUploadShareRequest var1) throws DracoonNetIOException, DracoonApiException;

        public UploadShareList getUploadShares() throws DracoonNetIOException, DracoonApiException;

        public UploadShareList getUploadShares(long var1, long var3) throws DracoonNetIOException, DracoonApiException;

        public UploadShareList getUploadShares(GetUploadSharesFilter var1) throws DracoonNetIOException, DracoonApiException;

        public UploadShareList getUploadShares(GetUploadSharesFilter var1, long var2, long var4) throws DracoonNetIOException, DracoonApiException;

        public byte[] getUploadShareQrCode(long var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteUploadShare(long var1) throws DracoonNetIOException, DracoonApiException;
    }

    public static interface Nodes {
        public NodeList getNodes(long var1) throws DracoonNetIOException, DracoonApiException;

        public NodeList getNodes(long var1, GetNodesFilters var3) throws DracoonNetIOException, DracoonApiException;

        public NodeList getNodes(long var1, long var3, long var5) throws DracoonNetIOException, DracoonApiException;

        public NodeList getNodes(long var1, GetNodesFilters var3, long var4, long var6) throws DracoonNetIOException, DracoonApiException;

        public Node getNode(long var1) throws DracoonNetIOException, DracoonApiException;

        public Node getNode(String var1) throws DracoonNetIOException, DracoonApiException;

        public Node createRoom(CreateRoomRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node updateRoom(UpdateRoomRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node updateRoomConfig(UpdateRoomConfigRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node createFolder(CreateFolderRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node updateFolder(UpdateFolderRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node updateFile(UpdateFileRequest var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteNodes(DeleteNodesRequest var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteNode(long var1) throws DracoonNetIOException, DracoonApiException;

        public Node copyNodes(CopyNodesRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node moveNodes(MoveNodesRequest var1) throws DracoonNetIOException, DracoonApiException;

        public Node uploadFile(String var1, FileUploadRequest var2, File var3, FileUploadCallback var4) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public Node uploadFile(String var1, FileUploadRequest var2, InputStream var3, long var4, FileUploadCallback var6) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public void startUploadFileAsync(String var1, FileUploadRequest var2, File var3, FileUploadCallback var4) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public void startUploadFileAsync(String var1, FileUploadRequest var2, InputStream var3, long var4, FileUploadCallback var6) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public void cancelUploadFileAsync(String var1);

        public FileUploadStream createFileUploadStream(String var1, FileUploadRequest var2, long var3, FileUploadCallback var5) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public void downloadFile(String var1, long var2, File var4, FileDownloadCallback var5) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException;

        public void downloadFile(String var1, long var2, OutputStream var4, FileDownloadCallback var5) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException;

        public void startDownloadFileAsync(String var1, long var2, File var4, FileDownloadCallback var5) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException;

        public void startDownloadFileAsync(String var1, long var2, OutputStream var4, FileDownloadCallback var5) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public void cancelDownloadFileAsync(String var1);

        public FileDownloadStream createFileDownloadStream(String var1, long var2, FileDownloadCallback var4) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public NodeList searchNodes(long var1, String var3) throws DracoonNetIOException, DracoonApiException;

        public NodeList searchNodes(long var1, String var3, SearchNodesFilters var4) throws DracoonNetIOException, DracoonApiException;

        public NodeList searchNodes(long var1, String var3, long var4, long var6) throws DracoonNetIOException, DracoonApiException;

        public NodeList searchNodes(long var1, String var3, SearchNodesFilters var4, long var5, long var7) throws DracoonNetIOException, DracoonApiException;

        public boolean generateMissingFileKeys(int var1) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public boolean generateMissingFileKeys(long var1, int var3) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public void markFavorite(long var1) throws DracoonNetIOException, DracoonApiException;

        public void unmarkFavorite(long var1) throws DracoonNetIOException, DracoonApiException;

        public NodeList getFavorites() throws DracoonNetIOException, DracoonApiException;

        public NodeList getFavorites(long var1, long var3) throws DracoonNetIOException, DracoonApiException;

        public NodeCommentList getNodeComments(long var1) throws DracoonNetIOException, DracoonApiException;

        public NodeCommentList getNodeComments(long var1, long var3, long var5) throws DracoonNetIOException, DracoonApiException;

        public NodeComment createNodeComment(CreateNodeCommentRequest var1) throws DracoonNetIOException, DracoonApiException;

        public NodeComment updateNodeComment(UpdateNodeCommentRequest var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteNodeComment(long var1) throws DracoonNetIOException, DracoonApiException;

        public FileVirusScanInfoList getFilesVirusScanInformation(GetFilesVirusScanInfoRequest var1) throws DracoonNetIOException, DracoonApiException;

        public FileVirusScanInfo getFileVirusScanInformation(long var1) throws DracoonNetIOException, DracoonApiException;

        public void deleteMaliciousFile(long var1) throws DracoonNetIOException, DracoonApiException;

        public URL buildMediaUrl(String var1, int var2, int var3);
    }

    public static interface Groups {
    }

    public static interface Users {
        public byte[] getUserAvatar(long var1, UUID var3) throws DracoonNetIOException, DracoonApiException;
    }

    public static interface Account {
        public UserAccount getUserAccount() throws DracoonNetIOException, DracoonApiException;

        public CustomerAccount getCustomerAccount() throws DracoonNetIOException, DracoonApiException;

        public List<UserKeyPairAlgorithm.Version> getUserKeyPairAlgorithmVersions() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException;

        public void setUserKeyPair(UserKeyPairAlgorithm.Version var1) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public void deleteUserKeyPair(UserKeyPairAlgorithm.Version var1) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public boolean checkUserKeyPairPassword(UserKeyPairAlgorithm.Version var1) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public boolean checkUserKeyPairPassword(UserKeyPairAlgorithm.Version var1, char[] var2) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException;

        public void setUserProfileAttribute(String var1, String var2) throws DracoonNetIOException, DracoonApiException;

        public String getUserProfileAttribute(String var1) throws DracoonNetIOException, DracoonApiException;

        public void setUserAvatar(byte[] var1) throws DracoonNetIOException, DracoonApiException;

        public byte[] getUserAvatar() throws DracoonNetIOException, DracoonApiException;

        public void deleteUserAvatar() throws DracoonNetIOException, DracoonApiException;
    }

    public static interface ServerPolicies {
        public PasswordPolicies getEncryptionPasswordPolicies() throws DracoonNetIOException, DracoonApiException;

        public PasswordPolicies getSharesPasswordPolicies() throws DracoonNetIOException, DracoonApiException;

        public ClassificationPolicies getClassificationPolicies() throws DracoonNetIOException, DracoonApiException;
    }

    public static interface ServerSettings {
        public ServerGeneralSettings getGeneralSettings() throws DracoonNetIOException, DracoonApiException;

        public ServerDefaults getDefaults() throws DracoonNetIOException, DracoonApiException;

        public List<UserKeyPairAlgorithm> getAvailableUserKeyPairAlgorithms() throws DracoonNetIOException, DracoonApiException;
    }

    public static interface Server {
        public String getVersion() throws DracoonNetIOException, DracoonApiException;

        public Boolean isDracoonCloud() throws DracoonNetIOException, DracoonApiException;

        public Date getTime() throws DracoonNetIOException, DracoonApiException;

        public ServerSettings settings();

        public ServerPolicies policies();
    }
}

