/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.filter;

import com.dracoon.sdk.filter.Filter;
import com.dracoon.sdk.internal.util.DateUtils;
import java.util.Date;

abstract class DateFilter
extends Filter<String> {
    private static final Filter.Type TYPE = Filter.Type.MULTI_RESTRICTION;

    protected DateFilter(String name) {
        super(name, TYPE);
    }

    public static class Concater<T extends DateFilter>
    extends Filter.Concater<Date, String> {
        private final T mFilter;

        Concater(T filter) {
            this.mFilter = filter;
        }

        public Builder<T> and() {
            return new Builder<T>(this.mFilter);
        }

        public T build() {
            return this.mFilter;
        }
    }

    protected static class Builder<T extends DateFilter>
    extends Filter.Builder<Date, String> {
        private final T mFilter;

        protected Builder(T filter) {
            this.mFilter = filter;
        }

        public Concater<T> ge(Date value) {
            this.validateRestrictionValue(value);
            ((Filter)this.mFilter).addValue("ge", (String)DateUtils.formatDate(value));
            return new Concater<T>(this.mFilter);
        }

        public Concater<T> le(Date value) {
            this.validateRestrictionValue(value);
            ((Filter)this.mFilter).addValue("le", (String)DateUtils.formatDate(value));
            return new Concater<T>(this.mFilter);
        }
    }
}

