/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.FileDecryptionCipher;
import com.dracoon.sdk.crypto.error.BadFileException;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.CryptoErrorParser;
import com.dracoon.sdk.internal.CryptoWrapper;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonErrorParser;
import com.dracoon.sdk.internal.DracoonService;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.model.ApiDownloadToken;
import com.dracoon.sdk.internal.model.ApiNode;
import com.dracoon.sdk.internal.util.StreamUtils;
import com.dracoon.sdk.model.FileDownloadCallback;
import com.dracoon.sdk.model.FileDownloadStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;

public class DownloadStream
extends FileDownloadStream {
    private static final String LOG_TAG = DownloadStream.class.getSimpleName();
    private static final int BLOCK_SIZE = 2048;
    private static final long PROGRESS_UPDATE_INTERVAL = 100L;
    private final Log mLog;
    private final DracoonService mService;
    private final OkHttpClient mHttpClient;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;
    private final CryptoWrapper mCrypto;
    private final String mId;
    private final long mNodeId;
    private final PlainFileKey mFileKey;
    private FileDecryptionCipher mDecryptionCipher;
    private boolean mIsDecryptionStarted = false;
    private boolean mIsDecryptionFinished = false;
    private long mDownloadOffset = 0L;
    private long mDownloadLength;
    private String mDownloadUrl;
    private final Buffer mDownloadBuffer = new Buffer();
    private InputStream mDownloadInputStream = null;
    private final int mChunkSize;
    private int mChunkNum = 0;
    private int mChunkOffset = 0;
    private boolean mRequestNextChunk = true;
    private boolean mIsClosed = false;
    private Thread mThread;
    private long mProgressUpdateTime = System.currentTimeMillis();
    private final List<FileDownloadCallback> mCallbacks = new ArrayList<FileDownloadCallback>();

    private DownloadStream(DracoonClientImpl client, String id, long nodeId, PlainFileKey fileKey) {
        this.mLog = client.getLog();
        this.mService = client.getDracoonService();
        this.mHttpClient = client.getHttpClient();
        this.mHttpHelper = client.getHttpHelper();
        this.mErrorParser = client.getDracoonErrorParser();
        this.mCrypto = client.getCryptoWrapper();
        this.mId = id;
        this.mNodeId = nodeId;
        this.mFileKey = fileKey;
        this.mChunkSize = client.getHttpConfig().getChunkSize() * 1024;
    }

    void start() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        this.mThread = Thread.currentThread();
        this.mDownloadUrl = null;
        this.mIsClosed = false;
        try {
            this.notifyStarted(this.mId);
            if (this.isEncryptedDownload()) {
                this.mDecryptionCipher = this.createDecryptionCipher();
            }
            this.mDownloadLength = this.getFileSize();
            this.mDownloadUrl = this.createDownload();
        }
        catch (InterruptedException e) {
            this.notifyCanceled(this.mId);
            this.mThread.interrupt();
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw e;
        }
    }

    private boolean isEncryptedDownload() {
        return this.mFileKey != null;
    }

    public void addCallback(FileDownloadCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(FileDownloadCallback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int len = this.read(b);
        return len > 0 ? b[0] : len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertStarted();
        this.assertNotClosed();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int read = -1;
        int bOff = off;
        int bLen = len;
        while (bLen > 0) {
            int bRead = this.mDownloadBuffer.read(b, bOff, bLen);
            if (bRead < 0) {
                boolean more;
                try {
                    more = this.downloadData();
                }
                catch (InterruptedException e) {
                    this.notifyCanceled(this.mId);
                    this.mThread.interrupt();
                    return -1;
                }
                catch (DracoonException e) {
                    this.notifyFailed(this.mId, e);
                    throw new IOException("Could not read from download stream.", e);
                }
                if (!more) break;
                continue;
            }
            bOff += bRead;
            bLen -= bRead;
            read = read >= 0 ? read + bRead : bRead;
        }
        if (read == -1) {
            this.notifyFinished(this.mId);
        }
        return read;
    }

    @Override
    public long skip(long skip) throws IOException {
        long count;
        this.assertStarted();
        this.assertNotClosed();
        if (skip <= 0L) {
            return 0L;
        }
        if (this.mDownloadBuffer.size() > skip) {
            this.mDownloadBuffer.skip(skip);
            return skip;
        }
        long skipped = this.mDownloadBuffer.size();
        this.mDownloadBuffer.clear();
        for (long toSkip = skip - skipped; toSkip > 0L; toSkip -= count) {
            try {
                count = this.skipData(toSkip);
            }
            catch (InterruptedException e) {
                this.notifyCanceled(this.mId);
                this.mThread.interrupt();
                break;
            }
            catch (DracoonException e) {
                this.notifyFailed(this.mId, e);
                throw new IOException("Could not read from download stream.", e);
            }
            if (count < 0L) break;
            skipped += count;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        long remaining;
        this.assertStarted();
        this.assertNotClosed();
        long bufferSize = this.mDownloadBuffer.size();
        if (this.isEncryptedDownload() && this.mIsDecryptionStarted && !this.mIsDecryptionFinished) {
            bufferSize += (long)this.mFileKey.getTag().length;
        }
        return (remaining = this.mDownloadLength - this.mDownloadOffset + bufferSize) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
    }

    @Override
    public void close() throws IOException {
        this.assertNotClosed();
        StreamUtils.closeStream(this.mDownloadInputStream);
        this.mIsClosed = true;
    }

    private FileDecryptionCipher createDecryptionCipher() throws DracoonCryptoException {
        try {
            return this.mCrypto.createFileDecryptionCipher(this.mFileKey);
        }
        catch (CryptoException | IllegalArgumentException e) {
            String errorText = DownloadStream.createDecryptionErrorMessage(this.mId, (Exception)e);
            this.mLog.d(LOG_TAG, errorText);
            DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)e);
            throw new DracoonCryptoException(errorCode, e);
        }
    }

    private long getFileSize() throws DracoonNetIOException, DracoonApiException, InterruptedException {
        retrofit2.Call<ApiNode> call = this.mService.getNode(this.mNodeId);
        retrofit2.Response<ApiNode> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = DownloadStream.createStartDownloadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode node = (ApiNode)response.body();
        return node.size;
    }

    private String createDownload() throws DracoonNetIOException, DracoonApiException, InterruptedException {
        retrofit2.Call<ApiDownloadToken> call = this.mService.getDownloadToken(this.mNodeId);
        retrofit2.Response<ApiDownloadToken> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseDownloadTokenGetError(response);
            String errorText = DownloadStream.createStartDownloadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiDownloadToken downloadToken = (ApiDownloadToken)response.body();
        return downloadToken.downloadUrl;
    }

    private boolean downloadData() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException, InterruptedException {
        byte[] bytes;
        int count;
        if (this.mDownloadOffset == this.mDownloadLength) {
            return false;
        }
        if (this.mRequestNextChunk) {
            long offset = this.mDownloadOffset;
            long remaining = this.mDownloadLength - this.mDownloadOffset;
            long size = remaining > (long)this.mChunkSize ? (long)this.mChunkSize : remaining;
            this.mDownloadInputStream = this.requestNextChunk(offset, size);
            this.mRequestNextChunk = false;
            ++this.mChunkNum;
            this.mChunkOffset = 0;
        }
        if ((count = (bytes = this.downloadBytes(this.mDownloadInputStream, 2048)).length) == 0) {
            this.mRequestNextChunk = true;
            return true;
        }
        this.mChunkOffset += count;
        this.mDownloadOffset += (long)count;
        if (this.isEncryptedDownload()) {
            boolean isLastBytes = this.mDownloadOffset == this.mDownloadLength;
            bytes = this.decryptBytes(bytes, isLastBytes);
        }
        this.mDownloadBuffer.write(bytes);
        return true;
    }

    private long skipData(long skip) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException, InterruptedException {
        if (!this.isEncryptedDownload()) {
            return this.skipDataPlain(skip);
        }
        return this.skipDataEncrypted(skip);
    }

    private long skipDataPlain(long skip) throws DracoonNetIOException, InterruptedException {
        if (this.mDownloadOffset == this.mDownloadLength) {
            return -1L;
        }
        if (this.mRequestNextChunk) {
            long remaining = this.mDownloadLength - this.mDownloadOffset;
            long remainingInChunk = remaining > (long)this.mChunkSize ? (long)this.mChunkSize : remaining;
            long toSkip = skip > remainingInChunk ? remainingInChunk : skip;
            ++this.mChunkNum;
            this.mChunkOffset = 0;
            this.mDownloadOffset += toSkip;
            return toSkip;
        }
        int toSkip = skip > 2048L ? 2048 : (int)skip;
        int skipped = this.skipBytes(this.mDownloadInputStream, toSkip);
        if (skipped == 0) {
            this.mRequestNextChunk = true;
            return 0L;
        }
        this.mChunkOffset += skipped;
        this.mDownloadOffset += (long)skipped;
        return skipped;
    }

    private long skipDataEncrypted(long skip) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException, InterruptedException {
        byte[] bytes;
        int toSkip = skip > (long)(bytes = new byte[2048]).length ? bytes.length : (int)skip;
        int skipped = this.mDownloadBuffer.read(bytes, 0, toSkip);
        if (skipped < 0) {
            boolean more = this.downloadData();
            skipped = more ? 0 : -1;
        }
        return skipped;
    }

    private InputStream requestNextChunk(long offset, long size) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        String range = "bytes=" + offset + "-" + (offset + size - 1L);
        Request request = new Request.Builder().url(this.mDownloadUrl).addHeader("Range", range).build();
        Call call = this.mHttpClient.newCall(request);
        Response response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseDownloadError(response);
            String errorText = DownloadStream.createDownloadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return new BufferedInputStream(response.body().byteStream());
    }

    private byte[] downloadBytes(InputStream is, int length) throws DracoonNetIOException, InterruptedException {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int count;
            byte[] buffer = new byte[length];
            for (int read = 0; read < length && (count = is.read(buffer, 0, length)) >= 0; read += count) {
                os.write(buffer, 0, count);
                if (this.mProgressUpdateTime + 100L >= System.currentTimeMillis() || this.mThread.isInterrupted()) continue;
                this.notifyRunning(this.mId, this.mDownloadOffset + (long)read, this.mDownloadLength);
                this.mProgressUpdateTime = System.currentTimeMillis();
            }
            byArray = os.toByteArray();
        }
        catch (Throwable buffer) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable) {
                    buffer.addSuppressed(throwable);
                }
                throw buffer;
            }
            catch (IOException e) {
                if (this.mThread.isInterrupted()) {
                    throw new InterruptedException();
                }
                String errorText = "Server communication failed!";
                this.mLog.d(LOG_TAG, errorText);
                throw new DracoonNetIOException(errorText, e);
            }
        }
        os.close();
        return byArray;
    }

    private int skipBytes(InputStream is, int n) throws DracoonNetIOException, InterruptedException {
        try {
            return (int)is.skip(n);
        }
        catch (IOException e) {
            if (this.mThread.isInterrupted()) {
                throw new InterruptedException();
            }
            String errorText = "Server communication failed!";
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonNetIOException(errorText, e);
        }
    }

    private byte[] decryptBytes(byte[] bytes, boolean isLast) throws DracoonFileIOException, DracoonCryptoException, InterruptedException {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            EncryptedDataContainer encData = new EncryptedDataContainer(bytes, null);
            PlainDataContainer plainData = this.mDecryptionCipher.processBytes(encData);
            this.mIsDecryptionStarted = true;
            os.write(plainData.getContent());
            if (isLast) {
                encData = new EncryptedDataContainer(null, this.mFileKey.getTag());
                plainData = this.mDecryptionCipher.doFinal(encData);
                this.mIsDecryptionFinished = true;
                os.write(plainData.getContent());
            }
            byArray = os.toByteArray();
        }
        catch (Throwable encData) {
            try {
                try {
                    os.close();
                }
                catch (Throwable plainData) {
                    encData.addSuppressed(plainData);
                }
                throw encData;
            }
            catch (BadFileException | CryptoSystemException | IllegalArgumentException | IllegalStateException e) {
                String errorText = DownloadStream.createDecryptionErrorMessage(this.mId, (Exception)e);
                this.mLog.d(LOG_TAG, errorText);
                DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)e);
                throw new DracoonCryptoException(errorCode, e);
            }
            catch (IOException e) {
                if (this.mThread.isInterrupted()) {
                    throw new InterruptedException();
                }
                String errorText = "Buffer write failed!";
                this.mLog.d(LOG_TAG, errorText);
                throw new DracoonFileIOException(errorText, e);
            }
        }
        os.close();
        return byArray;
    }

    private void assertStarted() throws IOException {
        if (this.mDownloadUrl == null) {
            throw new IOException("Download stream was not started.");
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.mIsClosed) {
            throw new IOException("Download stream was already closed.");
        }
    }

    private void notifyStarted(String id) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onStarted(id);
        }
    }

    private void notifyRunning(String id, long bytesRead, long bytesTotal) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onRunning(id, bytesRead, bytesTotal);
        }
    }

    private void notifyFinished(String id) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onFinished(id);
        }
    }

    private void notifyCanceled(String id) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onCanceled(id);
        }
    }

    private void notifyFailed(String id, DracoonException e) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onFailed(id, e);
        }
    }

    private static String createDecryptionErrorMessage(String id, Exception e) {
        return String.format("Decryption failed at download of '%s'! %s", id, e.getMessage());
    }

    private static String createStartDownloadErrorMessage(String id, DracoonApiCode errorCode) {
        return String.format("Creation of download stream for '%s' failed with '%s'!", id, errorCode.name());
    }

    private static String createDownloadErrorMessage(String id, DracoonApiCode errorCode) {
        return String.format("Download of '%s' failed with '%s'!", id, errorCode.name());
    }

    public static DownloadStream create(DracoonClientImpl client, String id, long nodeId, PlainFileKey fileKey) {
        return new DownloadStream(client, id, nodeId, fileKey);
    }
}

