/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.CryptoErrorParser;
import com.dracoon.sdk.internal.CryptoVersionConverter;
import com.dracoon.sdk.internal.CryptoWrapper;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonRequestHandler;
import com.dracoon.sdk.internal.HttpStatus;
import com.dracoon.sdk.internal.mapper.CustomerMapper;
import com.dracoon.sdk.internal.mapper.UserMapper;
import com.dracoon.sdk.internal.model.ApiCustomerAccount;
import com.dracoon.sdk.internal.model.ApiUserAccount;
import com.dracoon.sdk.internal.model.ApiUserAvatarInfo;
import com.dracoon.sdk.internal.model.ApiUserKeyPair;
import com.dracoon.sdk.internal.model.ApiUserProfileAttributes;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import com.dracoon.sdk.model.CustomerAccount;
import com.dracoon.sdk.model.UserAccount;
import com.dracoon.sdk.model.UserKeyPairAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Response;

public class DracoonAccountImpl
extends DracoonRequestHandler
implements DracoonClient.Account {
    private static final String LOG_TAG = DracoonAccountImpl.class.getSimpleName();

    DracoonAccountImpl(DracoonClientImpl client) {
        super(client);
    }

    public void pingUser() throws DracoonNetIOException, DracoonApiException {
        Call<Void> call = this.mService.pingUser();
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Auth ping failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public UserAccount getUserAccount() throws DracoonNetIOException, DracoonApiException {
        Call<ApiUserAccount> accountCall = this.mService.getUserAccount();
        Response<ApiUserAccount> accountResponse = this.mHttpHelper.executeRequest(accountCall);
        if (!accountResponse.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(accountResponse);
            String errorText = String.format("Query of user account failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiUserAccount accountData = (ApiUserAccount)accountResponse.body();
        Call<ApiUserAvatarInfo> avatarInfoCall = this.mService.getUserAvatarInfo();
        Response<ApiUserAvatarInfo> avatarInfoResponse = this.mHttpHelper.executeRequest(avatarInfoCall);
        if (!avatarInfoResponse.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(avatarInfoResponse);
            String errorText = String.format("Query of user account failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiUserAvatarInfo avatarInfoData = (ApiUserAvatarInfo)avatarInfoResponse.body();
        return UserMapper.fromApiUserAccount(accountData, avatarInfoData);
    }

    @Override
    public CustomerAccount getCustomerAccount() throws DracoonNetIOException, DracoonApiException {
        Call<ApiCustomerAccount> call = this.mService.getCustomerAccount();
        Response<ApiCustomerAccount> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of customer account failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiCustomerAccount data = (ApiCustomerAccount)response.body();
        return CustomerMapper.fromApiCustomerAccount(data);
    }

    @Override
    public List<UserKeyPairAlgorithm.Version> getUserKeyPairAlgorithmVersions() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        List<UserKeyPair> userKeyPairs = this.getUserKeyPairs();
        ArrayList<UserKeyPairAlgorithm.Version> versions = new ArrayList<UserKeyPairAlgorithm.Version>();
        for (UserKeyPair userKeyPair : userKeyPairs) {
            versions.add(CryptoVersionConverter.fromUserKeyPairVersion(userKeyPair.getUserPrivateKey().getVersion()));
        }
        return versions;
    }

    @Override
    public void setUserKeyPair(UserKeyPairAlgorithm.Version version) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.toUserKeyPairVersion(version);
        this.mClient.checkUserKeyPairVersionSupported(userKeyPairVersion);
        char[] encryptionPassword = this.mClient.getEncryptionPasswordOrAbort();
        CryptoWrapper crypto = this.mClient.getCryptoWrapper();
        UserKeyPair userKeyPair = crypto.generateUserKeyPair(userKeyPairVersion, encryptionPassword);
        ApiUserKeyPair apiUserKeyPair = UserMapper.toApiUserKeyPair(userKeyPair);
        Call<Void> call = this.mService.setUserKeyPair(apiUserKeyPair);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserKeyPairSetError(response);
            String errorText = String.format("Setting user key pair failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    private List<UserKeyPair> getUserKeyPairs() throws DracoonNetIOException, DracoonApiException {
        List<ApiUserKeyPair> apiUserKeyPairs = this.getAllUserKeyPairs();
        ArrayList<UserKeyPair> userKeyPairs = new ArrayList<UserKeyPair>();
        for (ApiUserKeyPair apiUserKeyPair : apiUserKeyPairs) {
            try {
                userKeyPairs.add(UserMapper.fromApiUserKeyPair(apiUserKeyPair));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return userKeyPairs;
    }

    private List<ApiUserKeyPair> getAllUserKeyPairs() throws DracoonNetIOException, DracoonApiException {
        Call<List<ApiUserKeyPair>> call = this.mService.getUserKeyPairs();
        Response<List<ApiUserKeyPair>> response = this.mHttpHelper.executeRequest(call);
        if (DracoonAccountImpl.existsNoUserKeyPair(response)) {
            return Collections.emptyList();
        }
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserKeyPairsQueryError(response);
            String errorText = String.format("Query of user key pairs failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (List)response.body();
    }

    private static boolean existsNoUserKeyPair(Response<?> response) {
        return !response.isSuccessful() && response.code() == HttpStatus.NOT_FOUND.getNumber();
    }

    private UserKeyPair getUserKeyPair(UserKeyPair.Version userKeyPairVersion) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        this.mClient.checkUserKeyPairVersionSupported(userKeyPairVersion);
        Call<ApiUserKeyPair> call = this.mService.getUserKeyPair(userKeyPairVersion.getValue());
        Response<ApiUserKeyPair> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserKeyPairQueryError(response);
            String errorText = String.format("Query of user key pair failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiUserKeyPair data = (ApiUserKeyPair)response.body();
        try {
            return UserMapper.fromApiUserKeyPair(data);
        }
        catch (UnknownVersionException e) {
            String errorText = "Query of user key pair failed! Key pair version is unknown!";
            this.mLog.d(LOG_TAG, errorText);
            DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)((Object)e));
            throw new DracoonCryptoException(errorCode, (Throwable)e);
        }
    }

    public UserKeyPair getPreferredUserKeyPair() throws DracoonNetIOException, DracoonApiException {
        List<UserKeyPairAlgorithm> userKeyPairAlgorithms = this.mClient.getServerSettingsImpl().getAvailableUserKeyPairAlgorithms();
        List<UserKeyPair> userKeyPairs = this.getUserKeyPairs();
        for (UserKeyPairAlgorithm userKeyPairAlgorithm : userKeyPairAlgorithms) {
            Optional<UserKeyPair> userKeyPair = userKeyPairs.stream().filter(kp -> Objects.equals(kp.getUserPrivateKey().getVersion().getValue(), userKeyPairAlgorithm.getVersion().getValue())).findAny();
            if (!userKeyPair.isPresent()) continue;
            return userKeyPair.get();
        }
        throw new DracoonApiException(DracoonApiCode.SERVER_USER_KEY_PAIR_NOT_FOUND);
    }

    public List<UserKeyPair> getAndCheckUserKeyPairs() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        char[] encryptionPassword = this.mClient.getEncryptionPasswordOrAbort();
        List<UserKeyPair> userKeyPairs = this.getUserKeyPairs();
        if (userKeyPairs.isEmpty()) {
            throw new DracoonApiException(DracoonApiCode.SERVER_USER_KEY_PAIR_NOT_FOUND);
        }
        for (UserKeyPair userKeyPair : userKeyPairs) {
            this.checkUserKeyPair(userKeyPair, encryptionPassword);
        }
        return userKeyPairs;
    }

    public UserKeyPair getAndCheckUserKeyPair(UserKeyPair.Version userKeyPairVersion) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        char[] encryptionPassword = this.mClient.getEncryptionPasswordOrAbort();
        UserKeyPair userKeyPair = this.getUserKeyPair(userKeyPairVersion);
        this.checkUserKeyPair(userKeyPair, encryptionPassword);
        return userKeyPair;
    }

    private void checkUserKeyPair(UserKeyPair userKeyPair, char[] encryptionPassword) throws DracoonCryptoException {
        CryptoWrapper crypto = this.mClient.getCryptoWrapper();
        boolean isValid = crypto.checkUserKeyPairPassword(userKeyPair, encryptionPassword);
        if (!isValid) {
            throw new DracoonCryptoException(DracoonCryptoCode.INVALID_PASSWORD_ERROR);
        }
    }

    @Override
    public void deleteUserKeyPair(UserKeyPairAlgorithm.Version version) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.toUserKeyPairVersion(version);
        this.mClient.checkUserKeyPairVersionSupported(userKeyPairVersion);
        Call<Void> call = this.mService.deleteUserKeyPair(userKeyPairVersion.getValue());
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserKeyPairDeleteError(response);
            String errorText = String.format("Deleting user key pair failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public boolean checkUserKeyPairPassword(UserKeyPairAlgorithm.Version version) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        char[] encryptionPassword = this.mClient.getEncryptionPasswordOrAbort();
        return this.checkUserKeyPairPassword(version, encryptionPassword);
    }

    @Override
    public boolean checkUserKeyPairPassword(UserKeyPairAlgorithm.Version version, char[] encryptionPassword) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.toUserKeyPairVersion(version);
        UserKeyPair userKeyPair = this.getUserKeyPair(userKeyPairVersion);
        CryptoWrapper crypto = this.mClient.getCryptoWrapper();
        return crypto.checkUserKeyPairPassword(userKeyPair, encryptionPassword);
    }

    @Override
    public void setUserProfileAttribute(String key, String value) throws DracoonNetIOException, DracoonApiException {
        ValidatorUtils.validateString("key", key, false);
        if (value != null) {
            ApiUserProfileAttributes.Item profileAttribute = new ApiUserProfileAttributes.Item();
            profileAttribute.key = key;
            profileAttribute.value = value;
            ApiUserProfileAttributes profileAttributes = new ApiUserProfileAttributes();
            profileAttributes.items = Collections.singletonList(profileAttribute);
            this.setUserProfileAttributes(profileAttributes);
        } else {
            this.deleteUserProfileAttribute(key);
        }
    }

    @Override
    public String getUserProfileAttribute(String key) throws DracoonNetIOException, DracoonApiException {
        ValidatorUtils.validateString("key", key, false);
        ApiUserProfileAttributes profileAttributes = this.getUserProfileAttributes();
        if (profileAttributes.items == null) {
            return null;
        }
        for (ApiUserProfileAttributes.Item profileAttribute : profileAttributes.items) {
            if (!Objects.equals(profileAttribute.key, key)) continue;
            return profileAttribute.value;
        }
        return null;
    }

    private void setUserProfileAttributes(ApiUserProfileAttributes profileAttributes) throws DracoonNetIOException, DracoonApiException {
        Call<Void> call = this.mService.setUserProfileAttributes(profileAttributes);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserProfileAttributesSetError(response);
            String errorText = String.format("Setting user profile attributes failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    private ApiUserProfileAttributes getUserProfileAttributes() throws DracoonNetIOException, DracoonApiException {
        Call<ApiUserProfileAttributes> call = this.mService.getUserProfileAttributes();
        Response<ApiUserProfileAttributes> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserProfileAttributesQueryError(response);
            String errorText = String.format("Query of user profile attributes failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiUserProfileAttributes)response.body();
    }

    private void deleteUserProfileAttribute(String key) throws DracoonNetIOException, DracoonApiException {
        Call<Void> call = this.mService.deleteUserProfileAttribute(key);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            if (response.code() == HttpStatus.NOT_FOUND.getNumber()) {
                return;
            }
            DracoonApiCode errorCode = this.mErrorParser.parseUserProfileAttributeDeleteError(response);
            String errorText = String.format("Deleting user profile attribute failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public void setUserAvatar(byte[] avatarImage) throws DracoonNetIOException, DracoonApiException {
        ValidatorUtils.validateByteArray("Avatar image", avatarImage, false, 1L, 0x500000L);
        Call<Void> call = this.mService.setUserAvatar(RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])avatarImage));
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserAvatarSetError(response);
            String errorText = String.format("Setting user avatar failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public byte[] getUserAvatar() throws DracoonNetIOException, DracoonApiException {
        Call<ApiUserAvatarInfo> avatarInfoCall = this.mService.getUserAvatarInfo();
        Response<ApiUserAvatarInfo> avatarInfoResponse = this.mHttpHelper.executeRequest(avatarInfoCall);
        if (!avatarInfoResponse.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(avatarInfoResponse);
            String errorText = String.format("Download of avatar failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiUserAvatarInfo avatarInfoData = (ApiUserAvatarInfo)avatarInfoResponse.body();
        String downloadUrl = avatarInfoData != null ? avatarInfoData.avatarUri : null;
        return this.mClient.getAvatarDownloader().downloadAvatar(downloadUrl);
    }

    @Override
    public void deleteUserAvatar() throws DracoonNetIOException, DracoonApiException {
        Call<Void> call = this.mService.deleteUserAvatar();
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUserAvatarDeleteError(response);
            String errorText = String.format("Deleting user avatar failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }
}

