/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.AvatarDownloader;
import com.dracoon.sdk.internal.BufferedSocketFactory;
import com.dracoon.sdk.internal.CryptoWrapper;
import com.dracoon.sdk.internal.DracoonAccountImpl;
import com.dracoon.sdk.internal.DracoonErrorParser;
import com.dracoon.sdk.internal.DracoonNodesImpl;
import com.dracoon.sdk.internal.DracoonServerImpl;
import com.dracoon.sdk.internal.DracoonServerPoliciesImpl;
import com.dracoon.sdk.internal.DracoonServerSettingsImpl;
import com.dracoon.sdk.internal.DracoonService;
import com.dracoon.sdk.internal.DracoonSharesImpl;
import com.dracoon.sdk.internal.DracoonUsersImpl;
import com.dracoon.sdk.internal.FileKeyFetcher;
import com.dracoon.sdk.internal.FileKeyGenerator;
import com.dracoon.sdk.internal.FileStreamHelper;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.HttpStatus;
import com.dracoon.sdk.internal.InterceptedIOException;
import com.dracoon.sdk.internal.NullLog;
import com.dracoon.sdk.internal.ThreadHelper;
import com.dracoon.sdk.internal.UserAgentInterceptor;
import com.dracoon.sdk.internal.oauth.OAuthClient;
import com.dracoon.sdk.internal.oauth.OAuthTokens;
import com.dracoon.sdk.internal.util.GsonCharArrayTypeAdapter;
import com.dracoon.sdk.internal.util.GsonDateTypeAdapter;
import com.dracoon.sdk.internal.util.GsonVoidTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class DracoonClientImpl
extends DracoonClient {
    private static final int HTTP_SOCKET_BUFFER_SIZE = 16384;
    private static final long AUTH_REFRESH_SKIP_INTERVAL = 15000L;
    private DracoonAuth mAuth;
    private final Interceptor mAuthInterceptor = new Interceptor(){
        private long mLastRefreshTime = 0L;
        private InterceptedIOException mLastRefreshException = null;

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (this.isPublicRequest(request)) {
                return chain.proceed(request);
            }
            if (DracoonClientImpl.this.mAuth == null) {
                return chain.proceed(request);
            }
            Response response = chain.proceed(this.addAuthorizationHeader(request));
            if (this.isSuccessfulResponse(response)) {
                return response;
            }
            if (DracoonClientImpl.this.mAuth.getRefreshToken() == null) {
                return response;
            }
            response.close();
            this.refreshAuthTokens();
            return chain.proceed(this.addAuthorizationHeader(request));
        }

        private boolean isPublicRequest(Request request) {
            return request.url().encodedPath().startsWith("/api/v4/public/");
        }

        private boolean isSuccessfulResponse(Response response) {
            return response.code() != HttpStatus.UNAUTHORIZED.getNumber();
        }

        private Request addAuthorizationHeader(Request request) {
            return request.newBuilder().header("Authorization", "Bearer " + DracoonClientImpl.this.mAuth.getAccessToken()).build();
        }

        private synchronized void refreshAuthTokens() throws InterceptedIOException {
            if (this.mLastRefreshTime + 15000L > System.currentTimeMillis()) {
                if (this.mLastRefreshException != null) {
                    throw this.mLastRefreshException;
                }
                return;
            }
            try {
                OAuthTokens tokens = DracoonClientImpl.this.mOAuthClient.refreshTokens(DracoonClientImpl.this.mAuth.getRefreshToken());
                DracoonClientImpl.this.mAuth = new DracoonAuth(DracoonClientImpl.this.mAuth.getClientId(), DracoonClientImpl.this.mAuth.getClientSecret(), tokens.accessToken, tokens.refreshToken);
                this.mLastRefreshTime = System.currentTimeMillis();
                this.mLastRefreshException = null;
            }
            catch (DracoonNetIOException e) {
                throw new InterceptedIOException(e);
            }
            catch (DracoonApiException e) {
                this.mLastRefreshTime = System.currentTimeMillis();
                this.mLastRefreshException = new InterceptedIOException(e);
                throw this.mLastRefreshException;
            }
        }
    };
    private char[] mEncryptionPassword;
    protected Log mLog = new NullLog();
    private DracoonHttpConfig mHttpConfig = new DracoonHttpConfig();
    private OkHttpClient mHttpClient;
    protected HttpHelper mHttpHelper;
    protected CryptoWrapper mCryptoWrapper;
    protected ThreadHelper mThreadHelper;
    protected FileStreamHelper mFileStreamHelper;
    private OAuthClient mOAuthClient;
    protected DracoonService mDracoonService;
    protected DracoonErrorParser mDracoonErrorParser;
    protected DracoonServerImpl mServer;
    protected DracoonServerSettingsImpl mServerSettings;
    protected DracoonServerPoliciesImpl mServerPolicies;
    protected DracoonAccountImpl mAccount;
    protected DracoonClient.Users mUsers;
    protected DracoonClient.Groups mGroups;
    protected DracoonNodesImpl mNodes;
    protected DracoonSharesImpl mShares;
    protected FileKeyFetcher mFileKeyFetcher;
    protected FileKeyGenerator mFileKeyGenerator;
    protected AvatarDownloader mAvatarDownloader;
    protected String mApiVersion = null;

    public DracoonClientImpl(URL serverUrl) {
        super(serverUrl);
    }

    @Override
    public DracoonAuth getAuth() {
        return this.mAuth;
    }

    public void setAuth(DracoonAuth auth) {
        this.mAuth = auth;
    }

    @Override
    public char[] getEncryptionPassword() {
        return this.mEncryptionPassword;
    }

    @Override
    public void setEncryptionPassword(char[] encryptionPassword) {
        this.mEncryptionPassword = encryptionPassword;
    }

    public char[] getEncryptionPasswordOrAbort() throws DracoonCryptoException {
        char[] encryptionPassword = this.getEncryptionPassword();
        if (encryptionPassword == null) {
            throw new DracoonCryptoException(DracoonCryptoCode.MISSING_PASSWORD_ERROR);
        }
        return encryptionPassword;
    }

    public Log getLog() {
        return this.mLog;
    }

    public void setLog(Log log) {
        this.mLog = log != null ? log : new NullLog();
    }

    public DracoonHttpConfig getHttpConfig() {
        return this.mHttpConfig;
    }

    public void setHttpConfig(DracoonHttpConfig httpConfig) {
        this.mHttpConfig = httpConfig != null ? httpConfig : new DracoonHttpConfig();
    }

    public OkHttpClient getHttpClient() {
        return this.mHttpClient;
    }

    public DracoonService getDracoonService() {
        return this.mDracoonService;
    }

    public DracoonErrorParser getDracoonErrorParser() {
        return this.mDracoonErrorParser;
    }

    public HttpHelper getHttpHelper() {
        return this.mHttpHelper;
    }

    public int getS3DefaultChunkSize() {
        return 0x500000;
    }

    public CryptoWrapper getCryptoWrapper() {
        return this.mCryptoWrapper;
    }

    public ThreadHelper getThreadHelper() {
        return this.mThreadHelper;
    }

    public FileStreamHelper getFileStreamHelper() {
        return this.mFileStreamHelper;
    }

    public void init() {
        this.initOAuthClient();
        this.initHttpClient();
        this.initHttpHelper();
        this.initDracoonService();
        this.initDracoonErrorParser();
        this.mCryptoWrapper = new CryptoWrapper(this.mLog);
        this.mThreadHelper = new ThreadHelper();
        this.mFileStreamHelper = new FileStreamHelper();
        this.mServer = new DracoonServerImpl(this);
        this.mServerSettings = new DracoonServerSettingsImpl(this);
        this.mServerPolicies = new DracoonServerPoliciesImpl(this);
        this.mAccount = new DracoonAccountImpl(this);
        this.mUsers = new DracoonUsersImpl(this);
        this.mNodes = new DracoonNodesImpl(this);
        this.mShares = new DracoonSharesImpl(this);
        this.mFileKeyFetcher = new FileKeyFetcher(this);
        this.mFileKeyGenerator = new FileKeyGenerator(this);
        this.mAvatarDownloader = new AvatarDownloader(this);
    }

    protected void initOAuthClient() {
        if (this.mAuth == null) {
            return;
        }
        this.mOAuthClient = new OAuthClient(this.mServerUrl, this.mAuth.getClientId(), this.mAuth.getClientSecret());
        this.mOAuthClient.setLog(this.mLog);
        this.mOAuthClient.setHttpConfig(this.mHttpConfig);
        this.mOAuthClient.init();
    }

    protected void initHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)this.mHttpConfig.getConnectTimeout(), TimeUnit.SECONDS);
        builder.readTimeout((long)this.mHttpConfig.getReadTimeout(), TimeUnit.SECONDS);
        builder.writeTimeout((long)this.mHttpConfig.getWriteTimeout(), TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        builder.socketFactory((SocketFactory)new BufferedSocketFactory(16384));
        if (this.mHttpConfig.isProxyEnabled()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.mHttpConfig.getProxyAddress(), (int)this.mHttpConfig.getProxyPort()));
            builder.proxy(proxy);
        }
        for (Interceptor interceptor : this.mHttpConfig.getOkHttpApplicationInterceptors()) {
            builder.addInterceptor(interceptor);
        }
        builder.addNetworkInterceptor((Interceptor)new UserAgentInterceptor(this.mHttpConfig.getUserAgent()));
        for (Interceptor interceptor : this.mHttpConfig.getOkHttpNetworkInterceptors()) {
            builder.addNetworkInterceptor(interceptor);
        }
        this.mHttpClient = builder.build();
    }

    protected void initHttpHelper() {
        this.mHttpHelper = new HttpHelper();
        this.mHttpHelper.setLog(this.mLog);
        this.mHttpHelper.setRetryEnabled(this.mHttpConfig.isRetryEnabled());
        this.mHttpHelper.setRateLimitingEnabled(this.mHttpConfig.isRateLimitingEnabled());
        this.mHttpHelper.init();
    }

    protected void initDracoonService() {
        OkHttpClient httpClient = this.mHttpClient.newBuilder().followRedirects(false).addInterceptor(this.mAuthInterceptor).build();
        Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(GsonVoidTypeAdapter.TYPE, (Object)new GsonVoidTypeAdapter()).registerTypeAdapter(GsonDateTypeAdapter.TYPE, (Object)new GsonDateTypeAdapter()).registerTypeAdapter(GsonCharArrayTypeAdapter.TYPE, (Object)new GsonCharArrayTypeAdapter()).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.mServerUrl.toString()).client(httpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.mDracoonService = (DracoonService)retrofit.create(DracoonService.class);
    }

    protected void initDracoonErrorParser() {
        this.mDracoonErrorParser = new DracoonErrorParser();
        this.mDracoonErrorParser.setLog(this.mLog);
    }

    public void checkApiVersionSupported() throws DracoonNetIOException, DracoonApiException {
        if (this.mApiVersion != null) {
            return;
        }
        if (!this.isApiVersionGreaterEqual("4.33.0")) {
            throw new DracoonApiException(DracoonApiCode.API_VERSION_NOT_SUPPORTED);
        }
    }

    public void checkApiVersionGreaterEqual(String apiVersion) throws DracoonNetIOException, DracoonApiException {
        if (!this.isApiVersionGreaterEqual(apiVersion)) {
            throw new DracoonApiException(DracoonApiCode.API_VERSION_NOT_SUFFICIENT);
        }
    }

    public boolean isApiVersionGreaterEqual(String minApiVersion) throws DracoonNetIOException, DracoonApiException {
        if (this.mApiVersion == null) {
            this.mApiVersion = this.mServer.getVersion();
        }
        if (this.mApiVersion == null || this.mApiVersion.isEmpty()) {
            return false;
        }
        String[] av = this.mApiVersion.split("\\-")[0].split("\\.");
        String[] mav = minApiVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int mv;
            int v;
            try {
                v = Integer.valueOf(av[i]);
                mv = Integer.valueOf(mav[i]);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse server API version.", e);
            }
            if (v > mv) break;
            if (v >= mv) continue;
            return false;
        }
        return true;
    }

    public void checkUserKeyPairVersionSupported(UserKeyPair.Version version) throws DracoonNetIOException, DracoonApiException {
        if (version == null) {
            throw new IllegalArgumentException("Version can't be null.");
        }
        List<UserKeyPair.Version> versions = this.mServerSettings.getAvailableUserKeyPairVersions();
        boolean apiSupportsVersion = versions.stream().anyMatch(v -> v == version);
        if (!apiSupportsVersion) {
            throw new DracoonApiException(DracoonApiCode.SERVER_CRYPTO_VERSION_NOT_SUPPORTED);
        }
    }

    public void retrieveAuthTokens() throws DracoonApiException, DracoonNetIOException {
        if (this.mAuth == null || !this.mAuth.getMode().equals((Object)DracoonAuth.Mode.AUTHORIZATION_CODE)) {
            return;
        }
        OAuthTokens tokens = this.mOAuthClient.retrieveTokens(this.mAuth.getAuthorizationCode());
        this.mAuth = new DracoonAuth(this.mAuth.getClientId(), this.mAuth.getClientSecret(), tokens.accessToken, tokens.refreshToken);
    }

    @Override
    public boolean isAuthValid() throws DracoonNetIOException, DracoonApiException {
        try {
            this.mAccount.pingUser();
        }
        catch (DracoonApiException e) {
            if (e.getCode().isAuthError()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public void checkAuthValid() throws DracoonNetIOException, DracoonApiException {
        this.mAccount.pingUser();
    }

    @Override
    public DracoonClient.Server server() {
        return this.mServer;
    }

    @Override
    public DracoonClient.Account account() {
        return this.mAccount;
    }

    @Override
    public DracoonClient.Users users() {
        return this.mUsers;
    }

    @Override
    public DracoonClient.Groups groups() {
        return this.mGroups;
    }

    @Override
    public DracoonClient.Nodes nodes() {
        return this.mNodes;
    }

    @Override
    public DracoonClient.Shares shares() {
        return this.mShares;
    }

    public DracoonServerImpl getServerImpl() {
        return this.mServer;
    }

    public DracoonServerSettingsImpl getServerSettingsImpl() {
        return this.mServerSettings;
    }

    public DracoonServerPoliciesImpl getServerPoliciesImpl() {
        return this.mServerPolicies;
    }

    public DracoonAccountImpl getAccountImpl() {
        return this.mAccount;
    }

    public DracoonNodesImpl getNodesImpl() {
        return this.mNodes;
    }

    public DracoonSharesImpl getSharesImpl() {
        return this.mShares;
    }

    public FileKeyFetcher getFileKeyFetcher() {
        return this.mFileKeyFetcher;
    }

    public FileKeyGenerator getFileKeyGenerator() {
        return this.mFileKeyGenerator;
    }

    public AvatarDownloader getAvatarDownloader() {
        return this.mAvatarDownloader;
    }

    public String buildApiUrl(String ... pathSegments) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mServerUrl);
        sb.append("/api/v4");
        for (String pathSegment : pathSegments) {
            sb.append("/").append(pathSegment);
        }
        return sb.toString();
    }
}

