/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.internal.HttpStatus;
import com.dracoon.sdk.internal.NullLog;
import com.dracoon.sdk.internal.model.ApiErrorResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DracoonErrorParser {
    private static final String LOG_TAG = DracoonErrorParser.class.getSimpleName();
    private static final String HEADER_X_FORBIDDEN = "X-Forbidden";
    private static final GsonBuilder sGsonBuilder = new GsonBuilder();
    private Log mLog = new NullLog();

    public void setLog(Log log) {
        this.mLog = log != null ? log : new NullLog();
    }

    public DracoonApiCode parseStandardError(retrofit2.Response response) {
        Error error = this.getError(response);
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseServerInfoQueryError(retrofit2.Response response) {
        HttpStatus statusCode = HttpStatus.valueOf(response.code());
        if (statusCode.is3xxRedirection() || statusCode == HttpStatus.UNAUTHORIZED || statusCode == HttpStatus.FORBIDDEN || statusCode == HttpStatus.NOT_FOUND) {
            return DracoonApiCode.API_NOT_FOUND;
        }
        return this.parseStandardError(response);
    }

    public DracoonApiCode parseUserKeyPairSetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -70022 || error.errorCode == -70023) {
                    return DracoonApiCode.VALIDATION_USER_KEY_PAIR_INVALID;
                }
                return this.parseValidationError(error.errorCode);
            }
            case CONFLICT: {
                if (error.errorCode == -70021) {
                    return DracoonApiCode.SERVER_USER_KEY_PAIR_ALREADY_SET;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserKeyPairsQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserKeyPairQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_USER_KEY_PAIR_NOT_FOUND;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserKeyPairDeleteError(retrofit2.Response response) {
        return this.parseUserKeyPairQueryError(response);
    }

    public DracoonApiCode parseUserProfileAttributesSetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -80023) {
                    return DracoonApiCode.VALIDATION_INVALID_KEY;
                }
                return this.parseValidationError(error.errorCode);
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserProfileAttributesQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserProfileAttributeDeleteError(retrofit2.Response response) {
        return this.parseUserProfileAttributesSetError(response);
    }

    public DracoonApiCode parseUserAvatarSetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -80042 || error.errorCode == -80043 || error.errorCode == -80044) {
                    return DracoonApiCode.VALIDATION_INVALID_IMAGE;
                }
                return this.parseValidationError(error.errorCode);
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUserAvatarDeleteError(retrofit2.Response response) {
        return this.parseStandardError(response);
    }

    public DracoonApiCode parseNodesQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_READ_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseRoomCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40755) {
                    return DracoonApiCode.VALIDATION_FILE_NAME_INVALID;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_CREATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_ROOM_NOT_FOUND;
                }
                if (error.errorCode == -70501) {
                    return DracoonApiCode.SERVER_USER_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseRoomUpdateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40755) {
                    return DracoonApiCode.VALIDATION_FILE_NAME_INVALID;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UPDATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_ROOM_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFolderCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_CREATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFolderUpdateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UPDATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_FOLDER_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFileUpdateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40755) {
                    return DracoonApiCode.VALIDATION_FILE_NAME_INVALID;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                if (error.errorCode == -80006) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_IN_PAST;
                }
                if (error.errorCode == -80008) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_TOO_LATE;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UPDATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40751) {
                    return DracoonApiCode.SERVER_FILE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodesDeleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_DELETE_ERROR);
            }
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_NODE_NOT_FOUND;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodesCopyError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40001) {
                    return DracoonApiCode.VALIDATION_SOURCE_ROOM_ENCRYPTED;
                }
                if (error.errorCode == -40002) {
                    return DracoonApiCode.VALIDATION_TARGET_ROOM_ENCRYPTED;
                }
                if (error.errorCode == -41052) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_COPY_ROOM;
                }
                if (error.errorCode == -41053) {
                    return DracoonApiCode.VALIDATION_FILE_CAN_NOT_BE_TARGET_NODE;
                }
                if (error.errorCode == -41054) {
                    return DracoonApiCode.VALIDATION_NODES_NOT_IN_SAME_PARENT;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                if (error.errorCode == -41302 || error.errorCode == -41303) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_COPY_NODE_TO_OWN_PLACE_WITHOUT_RENAME;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                if (error.errorCode == -40764) {
                    return DracoonApiCode.SERVER_VIRUS_SCAN_IN_PROGRESS;
                }
                if (error.errorCode == -40765) {
                    return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
                }
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_CREATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40014) {
                    return DracoonApiCode.VALIDATION_USER_HAS_NO_FILE_KEY;
                }
                if (error.errorCode == -41050) {
                    return DracoonApiCode.SERVER_SOURCE_NODE_NOT_FOUND;
                }
                if (error.errorCode == -41051) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                if (error.errorCode == -40010) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_OVERWRITE_ROOM_FOLDER;
                }
                if (error.errorCode == -41001) {
                    return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
                }
                if (error.errorCode == -41304) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_COPY_TO_CHILD;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodesMoveError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40001) {
                    return DracoonApiCode.VALIDATION_SOURCE_ROOM_ENCRYPTED;
                }
                if (error.errorCode == -40002) {
                    return DracoonApiCode.VALIDATION_TARGET_ROOM_ENCRYPTED;
                }
                if (error.errorCode == -41052) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_MOVE_ROOM;
                }
                if (error.errorCode == -41053) {
                    return DracoonApiCode.VALIDATION_FILE_CAN_NOT_BE_TARGET_NODE;
                }
                if (error.errorCode == -41054) {
                    return DracoonApiCode.VALIDATION_NODES_NOT_IN_SAME_PARENT;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                if (error.errorCode == -41302) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_MOVE_NODE_TO_OWN_PLACE;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                if (error.errorCode == -40764) {
                    return DracoonApiCode.SERVER_VIRUS_SCAN_IN_PROGRESS;
                }
                if (error.errorCode == -40765) {
                    return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
                }
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UPDATE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40014) {
                    return DracoonApiCode.VALIDATION_USER_HAS_NO_FILE_KEY;
                }
                if (error.errorCode == -41050) {
                    return DracoonApiCode.SERVER_SOURCE_NODE_NOT_FOUND;
                }
                if (error.errorCode == -41051) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                if (error.errorCode == -40010) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_OVERWRITE_ROOM_FOLDER;
                }
                if (error.errorCode == -41001) {
                    return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
                }
                if (error.errorCode == -41304) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_MOVE_TO_CHILD;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40755) {
                    return DracoonApiCode.VALIDATION_FILE_NAME_INVALID;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                if (error.errorCode == -80006) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_IN_PAST;
                }
                if (error.errorCode == -80008) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_TOO_LATE;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_CREATE_ERROR);
            }
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
            }
            case GATEWAY_TIMEOUT: {
                if (error.errorCode == -90027) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case INSUFFICIENT_STORAGE: {
                if (error.errorCode == -40200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_ROOM_QUOTA;
                }
                if (error.errorCode == -50504) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_UL_SHARE_QUOTA;
                }
                if (error.errorCode == -90200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_CUSTOMER_QUOTA;
                }
                return DracoonApiCode.SERVER_INSUFFICIENT_STORAGE;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                String avHeader = response.headers().get(HEADER_X_FORBIDDEN);
                if (avHeader != null && avHeader.equals("403")) {
                    return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
                }
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case INSUFFICIENT_STORAGE: {
                if (error.errorCode == -40200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_ROOM_QUOTA;
                }
                if (error.errorCode == -50504) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_UL_SHARE_QUOTA;
                }
                if (error.errorCode == -90200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_CUSTOMER_QUOTA;
                }
                return DracoonApiCode.SERVER_INSUFFICIENT_STORAGE;
            }
            case MALICIOUS_FILE_DETECTED: {
                return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadCompleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                if (error.errorCode == -40010) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_OVERWRITE_ROOM_FOLDER;
                }
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseS3UploadGetUrlsError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                if (error.errorCode == -90034) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case GATEWAY_TIMEOUT: {
                if (error.errorCode == -90027) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case INSUFFICIENT_STORAGE: {
                if (error.errorCode == -40200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_ROOM_QUOTA;
                }
                if (error.errorCode == -90200) {
                    return DracoonApiCode.SERVER_INSUFFICIENT_CUSTOMER_QUOTA;
                }
                return DracoonApiCode.SERVER_INSUFFICIENT_STORAGE;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseS3UploadCompleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                if (error.errorCode == -90034) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                if (error.errorCode == -40010) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_OVERWRITE_ROOM_FOLDER;
                }
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
            case GATEWAY_TIMEOUT: {
                if (error.errorCode == -90027) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseS3UploadStatusError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                if (error.errorCode == -90034) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseDownloadTokenGetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                if (error.errorCode == -40764) {
                    return DracoonApiCode.SERVER_VIRUS_SCAN_IN_PROGRESS;
                }
                if (error.errorCode == -40765) {
                    return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
                }
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_FILE_NOT_FOUND;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseDownloadShareCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -10002) {
                    return DracoonApiCode.VALIDATION_PASSWORD_NOT_SECURE;
                }
                if (error.errorCode == -50004) {
                    return DracoonApiCode.VALIDATION_DL_SHARE_CAN_NOT_CREATE_ON_ENCRYPTED_ROOM_FOLDER;
                }
                if (error.errorCode == -80006) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_IN_PAST;
                }
                if (error.errorCode == -80008) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_TOO_LATE;
                }
                if (error.errorCode == -80009) {
                    return DracoonApiCode.VALIDATION_EMAIL_ADDRESS_INVALID;
                }
                if (error.errorCode == -80030) {
                    return DracoonApiCode.SERVER_SMS_IS_DISABLED;
                }
                if (error.errorCode == -80064) {
                    return DracoonApiCode.VALIDATION_CLASSIFICATION_POLICY_VIOLATION;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_MANAGE_DL_SHARES_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case BAD_GATEWAY: {
                if (error.errorCode == -90090) {
                    return DracoonApiCode.SERVER_SMS_COULD_NOT_BE_SEND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseDownloadSharesQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseDownloadShareDeleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                return this.parsePermissionError(error.errorCode, DracoonApiCode.PERMISSION_MANAGE_DL_SHARES_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                if (error.errorCode == -60000) {
                    return DracoonApiCode.SERVER_DL_SHARE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadShareCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -10002) {
                    return DracoonApiCode.VALIDATION_PASSWORD_NOT_SECURE;
                }
                if (error.errorCode == -41200) {
                    return DracoonApiCode.VALIDATION_PATH_TOO_LONG;
                }
                if (error.errorCode == -80006) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_IN_PAST;
                }
                if (error.errorCode == -80008) {
                    return DracoonApiCode.VALIDATION_EXPIRATION_DATE_TOO_LATE;
                }
                if (error.errorCode == -80009) {
                    return DracoonApiCode.VALIDATION_EMAIL_ADDRESS_INVALID;
                }
                if (error.errorCode == -80030) {
                    return DracoonApiCode.SERVER_SMS_IS_DISABLED;
                }
                if (error.errorCode == -80064) {
                    return DracoonApiCode.VALIDATION_CLASSIFICATION_POLICY_VIOLATION;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_MANAGE_UL_SHARES_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                return DracoonApiCode.VALIDATION_UL_SHARE_NAME_ALREADY_EXISTS;
            }
            case BAD_GATEWAY: {
                if (error.errorCode == -90090) {
                    return DracoonApiCode.SERVER_SMS_COULD_NOT_BE_SEND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadSharesQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseUploadShareDeleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                return this.parsePermissionError(error.errorCode, DracoonApiCode.PERMISSION_MANAGE_DL_SHARES_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                if (error.errorCode == -60500) {
                    return DracoonApiCode.SERVER_UL_SHARE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFileKeyQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40751) {
                    return DracoonApiCode.SERVER_FILE_NOT_FOUND;
                }
                if (error.errorCode == -40761) {
                    return DracoonApiCode.SERVER_USER_FILE_KEY_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseMissingFileKeysQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40001) {
                    return DracoonApiCode.VALIDATION_ROOM_NOT_ENCRYPTED;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_ROOM_NOT_FOUND;
                }
                if (error.errorCode == -40751) {
                    return DracoonApiCode.SERVER_FILE_NOT_FOUND;
                }
                if (error.errorCode == -70501) {
                    return DracoonApiCode.SERVER_USER_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFileKeysSetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -40001) {
                    return DracoonApiCode.VALIDATION_ROOM_NOT_ENCRYPTED;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                if (error.errorCode == -40761) {
                    return DracoonApiCode.VALIDATION_USER_HAS_NO_FILE_KEY;
                }
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40751) {
                    return DracoonApiCode.SERVER_FILE_NOT_FOUND;
                }
                if (error.errorCode == -70501) {
                    return DracoonApiCode.SERVER_USER_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseFavoriteMarkError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodeCommentsQueryError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodeCommentCreateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -80023) {
                    return DracoonApiCode.VALIDATION_NODE_COMMENT_CONTAINS_INVALID_CHARACTERS;
                }
                return this.parseValidationError(error.errorCode);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodeCommentUpdateError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -80023) {
                    return DracoonApiCode.VALIDATION_NODE_COMMENT_CONTAINS_INVALID_CHARACTERS;
                }
                if (error.errorCode == -80039) {
                    return DracoonApiCode.SERVER_NODE_COMMENT_ALREADY_DELETED;
                }
                return this.parseValidationError(error.errorCode);
            }
            case NOT_FOUND: {
                if (error.errorCode == -41400) {
                    return DracoonApiCode.SERVER_NODE_COMMENT_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodeCommentDeleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -80039) {
                    return DracoonApiCode.SERVER_NODE_COMMENT_ALREADY_DELETED;
                }
                return this.parseValidationError(error.errorCode);
            }
            case NOT_FOUND: {
                if (error.errorCode == -41400) {
                    return DracoonApiCode.SERVER_NODE_COMMENT_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseNodesVirusProtectionInfoGetError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -41002) {
                    return DracoonApiCode.VALIDATION_NODE_NOT_A_FILE;
                }
                return this.parseValidationError(error.errorCode);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    public DracoonApiCode parseMaliciousFileDeleteError(retrofit2.Response response) {
        Error error = this.getError(response);
        switch (HttpStatus.valueOf(error.statusCode)) {
            case BAD_REQUEST: {
                if (error.errorCode == -41002) {
                    return DracoonApiCode.VALIDATION_NODE_NOT_A_FILE;
                }
                return this.parseValidationError(error.errorCode);
            }
            case FORBIDDEN: {
                return this.parseNodePermissionError(error.errorCode, DracoonApiCode.PERMISSION_DELETE_ERROR);
            }
            case NOT_FOUND: {
                if (error.errorCode == -40000 || error.errorCode == -41000) {
                    return DracoonApiCode.SERVER_NODE_NOT_FOUND;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(error.statusCode, error.errorCode);
    }

    private DracoonApiCode parseStandardError(int statusCode, int errorCode) {
        switch (HttpStatus.valueOf(statusCode)) {
            case BAD_REQUEST: {
                return this.parseValidationError(errorCode);
            }
            case UNAUTHORIZED: {
                if (errorCode == -10006) {
                    return DracoonApiCode.AUTH_OAUTH_CLIENT_NO_PERMISSION;
                }
                return DracoonApiCode.AUTH_UNAUTHORIZED;
            }
            case PAYMENT_REQUIRED: {
                return DracoonApiCode.PRECONDITION_PAYMENT_REQUIRED;
            }
            case FORBIDDEN: {
                return this.parsePermissionError(errorCode, DracoonApiCode.PERMISSION_UNKNOWN_ERROR);
            }
            case PRECONDITION_FAILED: {
                if (errorCode == -10103) {
                    return DracoonApiCode.PRECONDITION_MUST_ACCEPT_EULA;
                }
                if (errorCode == -10104) {
                    return DracoonApiCode.PRECONDITION_MUST_CHANGE_PASSWORD;
                }
                if (errorCode == -10106) {
                    return DracoonApiCode.PRECONDITION_MUST_CHANGE_USER_NAME;
                }
                return DracoonApiCode.PRECONDITION_UNKNOWN_ERROR;
            }
            case TOO_MANY_REQUESTS: {
                return DracoonApiCode.SERVER_TOO_MANY_REQUESTS;
            }
        }
        return DracoonApiCode.SERVER_UNKNOWN_ERROR;
    }

    private DracoonApiCode parseValidationError(int errorCode) {
        if (errorCode == -80000) {
            return DracoonApiCode.VALIDATION_FIELD_CAN_NOT_BE_EMPTY;
        }
        if (errorCode == -80001) {
            return DracoonApiCode.VALIDATION_FIELD_NOT_POSITIVE;
        }
        if (errorCode == -80003) {
            return DracoonApiCode.VALIDATION_FIELD_NOT_ZERO_POSITIVE;
        }
        if (errorCode == -80007) {
            return DracoonApiCode.VALIDATION_FIELD_MAX_LENGTH_EXCEEDED;
        }
        if (errorCode == -80018) {
            return DracoonApiCode.VALIDATION_FIELD_NOT_BETWEEN_0_9999;
        }
        if (errorCode == -80019) {
            return DracoonApiCode.VALIDATION_FIELD_NOT_BETWEEN_1_9999;
        }
        if (errorCode == -80023) {
            return DracoonApiCode.VALIDATION_FIELD_CONTAINS_INVALID_CHARACTERS;
        }
        if (errorCode == -80024) {
            return DracoonApiCode.VALIDATION_INVALID_OFFSET_OR_LIMIT;
        }
        if (errorCode == -80035) {
            return DracoonApiCode.VALIDATION_FIELD_NOT_BETWEEN_0_10;
        }
        return DracoonApiCode.VALIDATION_UNKNOWN_ERROR;
    }

    private DracoonApiCode parseNodePermissionError(int errorCode, DracoonApiCode defaultResult) {
        if (errorCode == -70020) {
            return DracoonApiCode.VALIDATION_USER_HAS_NO_KEY_PAIR;
        }
        return this.parsePermissionError(errorCode, defaultResult);
    }

    private DracoonApiCode parsePermissionError(int errorCode, DracoonApiCode defaultResult) {
        if (errorCode == -10003 || errorCode == -10007) {
            return DracoonApiCode.AUTH_USER_LOCKED;
        }
        if (errorCode == -10004) {
            return DracoonApiCode.AUTH_USER_EXPIRED;
        }
        if (errorCode == -10005) {
            return DracoonApiCode.AUTH_USER_TEMPORARY_LOCKED;
        }
        return defaultResult;
    }

    private Error getError(retrofit2.Response response) {
        this.mLog.d(LOG_TAG, "Server API error: " + response.code());
        Error error = new Error();
        error.statusCode = response.code();
        ApiErrorResponse errorResponse = this.getApiErrorResponse(response.errorBody());
        if (errorResponse != null && errorResponse.errorCode != null) {
            error.errorCode = errorResponse.errorCode;
        }
        return error;
    }

    private ApiErrorResponse getApiErrorResponse(ResponseBody responseBody) {
        if (responseBody == null) {
            return null;
        }
        MediaType contentType = responseBody.contentType();
        if (contentType == null) {
            this.mLog.d(LOG_TAG, "Invalid server API error response!");
            try {
                this.mLog.d(LOG_TAG, responseBody.string());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        ApiErrorResponse errorResponse = null;
        try {
            Gson gson = sGsonBuilder.create();
            switch (contentType.subtype()) {
                case "json": {
                    errorResponse = (ApiErrorResponse)gson.fromJson(responseBody.string(), ApiErrorResponse.class);
                    break;
                }
                case "octet-stream": {
                    errorResponse = (ApiErrorResponse)gson.fromJson(responseBody.charStream(), ApiErrorResponse.class);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (errorResponse != null) {
            this.mLog.d(LOG_TAG, "Server API error response:");
            this.mLog.d(LOG_TAG, errorResponse.toString());
        }
        return errorResponse;
    }

    public DracoonApiCode parseS3UploadError(Response response) {
        int statusCode = response.code();
        this.mLog.d(LOG_TAG, "S3 error: " + statusCode);
        switch (HttpStatus.valueOf(statusCode)) {
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
            }
        }
        return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
    }

    public DracoonApiCode parseDownloadError(Response response) {
        int statusCode = response.code();
        this.mLog.d(LOG_TAG, "Server API error: " + statusCode);
        switch (HttpStatus.valueOf(statusCode)) {
            case FORBIDDEN: {
                String avHeader = response.headers().get(HEADER_X_FORBIDDEN);
                if (avHeader != null && avHeader.equals("403")) {
                    return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
                }
                return DracoonApiCode.PERMISSION_UNKNOWN_ERROR;
            }
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_FILE_NOT_FOUND;
            }
            case MALICIOUS_FILE_DETECTED: {
                return DracoonApiCode.SERVER_MALICIOUS_FILE_DETECTED;
            }
        }
        return this.parseStandardError(response);
    }

    public DracoonApiCode parseAvatarDownloadError(Response response) {
        int statusCode = response.code();
        this.mLog.d(LOG_TAG, "Server API error: " + statusCode);
        switch (HttpStatus.valueOf(statusCode)) {
            case NOT_FOUND: {
                return DracoonApiCode.SERVER_USER_AVATAR_NOT_FOUND;
            }
        }
        return this.parseStandardError(response);
    }

    public DracoonApiCode parseStandardError(Response response) {
        int statusCode = response.code();
        switch (HttpStatus.valueOf(statusCode)) {
            case UNAUTHORIZED: {
                return DracoonApiCode.AUTH_UNAUTHORIZED;
            }
            case PAYMENT_REQUIRED: {
                return DracoonApiCode.PRECONDITION_PAYMENT_REQUIRED;
            }
            case TOO_MANY_REQUESTS: {
                return DracoonApiCode.SERVER_TOO_MANY_REQUESTS;
            }
        }
        return DracoonApiCode.SERVER_UNKNOWN_ERROR;
    }

    public DracoonApiCode parseS3UploadStatusError(ApiErrorResponse errorResponse) {
        if (errorResponse == null) {
            return DracoonApiCode.SERVER_UNKNOWN_ERROR;
        }
        int statusCode = errorResponse.code != null ? errorResponse.code : 0;
        int errorCode = errorResponse.errorCode != null ? errorResponse.errorCode : 0;
        switch (HttpStatus.valueOf(statusCode)) {
            case NOT_FOUND: {
                if (errorCode == -20501) {
                    return DracoonApiCode.SERVER_UPLOAD_NOT_FOUND;
                }
                if (errorCode == -40000 || errorCode == -41000) {
                    return DracoonApiCode.SERVER_TARGET_NODE_NOT_FOUND;
                }
                if (errorCode == -90034) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
            case CONFLICT: {
                if (errorCode == -40010) {
                    return DracoonApiCode.VALIDATION_CAN_NOT_OVERWRITE_ROOM_FOLDER;
                }
                return DracoonApiCode.VALIDATION_NODE_ALREADY_EXISTS;
            }
            case GATEWAY_TIMEOUT: {
                if (errorCode == -90027) {
                    return DracoonApiCode.SERVER_S3_COMMUNICATION_FAILED;
                }
                return DracoonApiCode.SERVER_UNKNOWN_ERROR;
            }
        }
        return this.parseStandardError(statusCode, errorCode);
    }

    private static class Error {
        int statusCode;
        int errorCode;

        private Error() {
        }
    }
}

